/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.armor;

import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.armor.ComponentGridWidget;
import gregtech.api.gui.widgets.armor.ConnectionType;
import gregtech.api.gui.widgets.armor.ElementOrientation;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import javax.annotation.Nullable;

public abstract class GridElementWidget
extends Widget {
    protected final int slotSize;
    protected ElementOrientation orientation = ElementOrientation.TOP;
    protected final Size initialElementSize;
    @Nullable
    protected ComponentGridWidget parentWidget;

    public GridElementWidget(Size elementSize, int slotSize) {
        super(Position.ORIGIN, elementSize);
        this.initialElementSize = elementSize;
        this.slotSize = slotSize;
    }

    public void setParentWidget(ComponentGridWidget parentWidget) {
        this.parentWidget = parentWidget;
    }

    public void setOrientation(ElementOrientation orientation) {
        this.orientation = orientation;
        this.setSize(TextureArea.transformSize(TextureArea.createOrientation(this.initialElementSize, orientation.rotationValue), this.initialElementSize));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.setOrientation(ElementOrientation.values()[(this.orientation.ordinal() + 1) % 4]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public abstract boolean canConnect(ElementOrientation var1, Position var2, ConnectionType var3);
}

