/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.armor;

import codechicken.lib.vec.Transformation;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.armor.ConnectionType;
import gregtech.api.gui.widgets.armor.ElementOrientation;
import gregtech.api.util.Position;
import gregtech.api.util.PositionedRect;
import gregtech.api.util.Size;

public class GridConnection {
    private final ConnectionType connectionType;
    private final Size parentElementSize;
    private final PositionedRect parentElementRect;
    private final int connectionOffset;
    private final Size elementSize;
    private Position parentPosition = Position.ORIGIN;
    private Position selfPosition;
    private ElementOrientation parentOrientation = ElementOrientation.TOP;
    private ElementOrientation selfOrientation;

    public GridConnection(ConnectionType connectionType, int slotSize, Size elementSize, PositionedRect elementRect, ElementOrientation selfOrientation, int initialSlotIndex) {
        this.connectionOffset = initialSlotIndex * slotSize + (slotSize - connectionType.thickness) / 2;
        this.connectionType = connectionType;
        this.parentElementSize = elementSize;
        this.parentElementRect = elementRect;
        this.selfOrientation = selfOrientation;
        this.elementSize = this.computeConnectionSize();
        this.updateOrientation();
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    private Size computeConnectionSize() {
        int thickness = this.connectionType.thickness;
        switch (this.selfOrientation) {
            case LEFT: {
                return new Size(thickness, this.parentElementRect.position.x);
            }
            case RIGHT: {
                return new Size(thickness, this.parentElementSize.width - (this.parentElementRect.position.x + this.parentElementRect.size.width));
            }
            case TOP: {
                return new Size(thickness, this.parentElementRect.position.y);
            }
            case BOTTOM: {
                return new Size(thickness, this.parentElementSize.height - (this.parentElementRect.position.y + this.parentElementRect.size.height));
            }
        }
        return Size.ZERO;
    }

    private Position computePosition() {
        Transformation orientation = TextureArea.createOrientation(this.parentElementSize, this.parentOrientation.rotationValue);
        PositionedRect parentRect = TextureArea.transformRect(orientation, this.parentElementRect);
        switch (this.getOrientation()) {
            case LEFT: {
                return new Position(0, this.connectionOffset);
            }
            case RIGHT: {
                return new Position(parentRect.position.x + parentRect.size.width, this.connectionOffset);
            }
            case TOP: {
                return new Position(this.connectionOffset, 0);
            }
            case BOTTOM: {
                return new Position(this.connectionOffset, parentRect.position.y + parentRect.size.height);
            }
        }
        return Position.ORIGIN;
    }

    public Position getSelfPosition() {
        return this.selfPosition;
    }

    public Position getPosition() {
        return this.parentPosition.add(this.selfPosition);
    }

    public ElementOrientation getOrientation() {
        return ElementOrientation.values()[(this.parentOrientation.ordinal() + this.selfOrientation.ordinal()) % 4];
    }

    public void updateParentOrientation(ElementOrientation parentOrientation) {
        this.parentOrientation = parentOrientation;
        this.updateOrientation();
    }

    private void updateOrientation() {
        this.selfPosition = this.computePosition();
    }

    public void setParentPosition(Position parentPosition) {
        this.parentPosition = parentPosition;
    }

    public void draw() {
        Position position = this.getPosition();
        ElementOrientation orientation = this.getOrientation();
        this.connectionType.icon.drawRotated(position.x, position.y, this.elementSize, new PositionedRect(Position.ORIGIN, this.elementSize), orientation.rotationValue);
    }
}

