/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.armor;

import com.google.common.base.Preconditions;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.armor.ElementOrientation;
import gregtech.api.gui.widgets.armor.GridElementCable;
import gregtech.api.gui.widgets.armor.GridElementDef;
import gregtech.api.gui.widgets.armor.GridElementWidget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;

public class ComponentGridWidget
extends AbstractWidgetGroup {
    private final int gridSizeHorizontal;
    private final int gridSizeVertical;
    private final int slotSize;
    private final int offset;
    private int gridColor = -1;
    private TIntObjectMap<Widget> widgetBySlotIndex = new TIntObjectHashMap();
    private TObjectIntMap<Widget> originByWidget = new TObjectIntHashMap();

    public ComponentGridWidget(int x, int y, int slotSize, int offset, int gridSizeHorizontal, int gridSizeVertical) {
        super(new Position(x, y), ComponentGridWidget.computeGridSize(slotSize, offset, gridSizeHorizontal, gridSizeVertical));
        this.gridSizeHorizontal = gridSizeHorizontal;
        this.gridSizeVertical = gridSizeVertical;
        this.slotSize = slotSize;
        this.offset = offset;
    }

    public Position getWidgetOrigin(Widget widget) {
        int result = this.originByWidget.get((Object)widget);
        return new Position(result % this.gridSizeHorizontal, result / this.gridSizeHorizontal);
    }

    public Widget getWidgetAt(int x, int y) {
        return (Widget)this.widgetBySlotIndex.get(this.index(x, y));
    }

    public void placeWidgetAt(int x, int y, GridElementDef def, ElementOrientation orientation) {
        Preconditions.checkArgument((boolean)this.canPlaceWidgetAt(x, y, def, orientation), (Object)"Cannot place widget there!");
        GridElementWidget elementWidget = def.createWidget(orientation, this.slotSize);
        super.addWidget(elementWidget);
        elementWidget.setParentPosition(this.computeWidgetPosition(x, y));
        elementWidget.setParentWidget(this);
        this.setWidgetMapData(x, y, def.getSizeWithOrientation(orientation), elementWidget);
    }

    @Override
    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        if (widget instanceof GridElementWidget) {
            this.clearWidgetFromMap(widget);
            ((GridElementWidget)widget).setParentWidget(null);
        }
    }

    private Position computeWidgetPosition(int x, int y) {
        Position position = this.getPosition().add(new Position(this.offset, this.offset));
        return new Position(position.x + this.slotSize * x, position.y + this.slotSize * y);
    }

    public boolean canPlaceWidgetAt(int x, int y, GridElementDef elementDef, ElementOrientation orientation) {
        Size actualSize = elementDef.getSizeWithOrientation(orientation);
        for (int i = 0; i < actualSize.width; ++i) {
            for (int j = 0; j < actualSize.height; ++j) {
                int positionX = x + i;
                int positionY = y + j;
                if (!this.widgetBySlotIndex.containsKey(this.index(positionX, positionY)) && this.isValidPosition(positionX, positionY)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidPosition(int x, int y) {
        return x >= 0 && y >= 0 && x < this.gridSizeHorizontal && y < this.gridSizeVertical;
    }

    private int index(int x, int y) {
        return y * this.gridSizeHorizontal + x;
    }

    private void setWidgetMapData(int x, int y, Size actualSize, Widget widget) {
        this.originByWidget.put((Object)widget, this.index(x, y));
        for (int i = 0; i < actualSize.width; ++i) {
            for (int j = 0; j < actualSize.height; ++j) {
                int positionX = x + i;
                int positionY = y + j;
                this.widgetBySlotIndex.put(this.index(positionX, positionY), (Object)widget);
            }
        }
    }

    private void clearWidgetFromMap(Widget widget) {
        this.originByWidget.remove((Object)widget);
        TIntObjectIterator it = this.widgetBySlotIndex.iterator();
        while (it.hasNext()) {
            it.advance();
            if (it.value() != widget) continue;
            it.remove();
        }
    }

    @Override
    protected void clearAllWidgets() {
        this.widgets.forEach(it -> ((GridElementWidget)it).setParentWidget(null));
        super.clearAllWidgets();
        this.widgetBySlotIndex.clear();
        this.originByWidget.clear();
    }

    public ComponentGridWidget setGridColor(int gridColor) {
        this.gridColor = gridColor;
        return this;
    }

    private static Size computeGridSize(int slotSize, int offset, int slotsX, int slotsY) {
        return new Size(offset * 2 + slotSize * slotsX, offset * 2 + slotSize * slotsY);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        this.drawComponentGrid();
        super.drawInBackground(mouseX, mouseY, context);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        int mouseSlotY;
        int mouseSlotX;
        if (this.isMouseOverElement(mouseX, mouseY) && this.isValidPosition(mouseSlotX = (mouseX - this.getPosition().x - this.offset) / this.slotSize, mouseSlotY = (mouseY - this.getPosition().y - this.offset) / this.slotSize)) {
            GridElementDef elementDef;
            Widget widget = this.getWidgetAt(mouseSlotX, mouseSlotY);
            if (button == 1) {
                if (widget != null) {
                    this.removeWidget(widget);
                    return true;
                }
            } else if (button == 0 && widget == null && this.canPlaceWidgetAt(mouseSlotX, mouseSlotY, elementDef = new GridElementDef(1, 1, GridElementCable::new), ElementOrientation.TOP)) {
                this.placeWidgetAt(mouseSlotX, mouseSlotY, elementDef, ElementOrientation.TOP);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void drawComponentGrid() {
        for (int lineIndexX = 0; lineIndexX <= this.gridSizeHorizontal; ++lineIndexX) {
            int lineX = this.getPosition().x - 1 + this.offset + lineIndexX * this.slotSize;
            int lineStartY = this.getPosition().y;
            ComponentGridWidget.drawSolidRect(lineX, lineStartY, 1, this.getSize().height, this.gridColor);
        }
        for (int lineIndexY = 0; lineIndexY <= this.gridSizeVertical; ++lineIndexY) {
            int lineY = this.getPosition().y + this.offset + lineIndexY * this.slotSize;
            int lineStartX = this.getPosition().x;
            ComponentGridWidget.drawSolidRect(lineStartX, lineY, this.getSize().width, 1, this.gridColor);
        }
    }
}

