/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.RenderUtil;
import gregtech.api.util.Size;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.util.math.MathHelper;

public class ScrollableListWidget
extends AbstractWidgetGroup {
    protected int totalListHeight;
    protected int slotHeight;
    protected int scrollOffset;
    protected int scrollPaneWidth = 10;
    protected int lastMouseX;
    protected int lastMouseY;
    protected boolean draggedOnScrollBar;

    public ScrollableListWidget(int xPosition, int yPosition, int width, int height) {
        super(new Position(xPosition, yPosition), new Size(width, height));
    }

    @Override
    public void addWidget(Widget widget) {
        super.addWidget(widget);
    }

    @Override
    protected boolean recomputeSize() {
        this.updateElementPositions();
        return false;
    }

    private void addScrollOffset(int offset) {
        this.scrollOffset = MathHelper.func_76125_a((int)(this.scrollOffset + offset), (int)0, (int)(this.totalListHeight - this.getSize().height));
        this.updateElementPositions();
    }

    private boolean isOnScrollPane(int mouseX, int mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return ScrollableListWidget.isMouseOver(pos.x + size.width - this.scrollPaneWidth, pos.y, this.scrollPaneWidth, size.height, mouseX, mouseY);
    }

    @Override
    protected void onPositionUpdate() {
        this.updateElementPositions();
    }

    private void updateElementPositions() {
        Position position = this.getPosition();
        int currentPosY = position.y - this.scrollOffset;
        int totalListHeight = 0;
        for (Widget widget : this.widgets) {
            Position childPosition = new Position(position.x, currentPosY);
            widget.setParentPosition(childPosition);
            currentPosY += widget.getSize().getHeight();
            totalListHeight += widget.getSize().getHeight();
            Size size = this.getSize();
            widget.applyScissor(position.x, position.y, size.width - this.scrollPaneWidth, size.height);
        }
        this.totalListHeight = totalListHeight;
        this.slotHeight = this.widgets.isEmpty() ? 0 : totalListHeight / this.widgets.size();
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (!this.isPositionInsideScissor(mouseX, mouseY)) {
            mouseX = Integer.MAX_VALUE;
            mouseY = Integer.MAX_VALUE;
        }
        super.drawInForeground(mouseX, mouseY);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        if (!this.isPositionInsideScissor(mouseX, mouseY)) {
            mouseX = Integer.MAX_VALUE;
            mouseY = Integer.MAX_VALUE;
        }
        int finalMouseX = mouseX;
        int finalMouseY = mouseY;
        Position position = this.getPosition();
        Size size = this.getSize();
        int paneSize = this.scrollPaneWidth;
        int scrollX = position.x + size.width - paneSize;
        ScrollableListWidget.drawSolidRect(scrollX, position.y, paneSize, size.height, -10066330);
        ScrollableListWidget.drawSolidRect(scrollX + 1, position.y + 1, paneSize - 2, size.height - 2, -7829368);
        int maxScrollOffset = this.totalListHeight - this.getSize().height;
        float scrollPercent = maxScrollOffset == 0 ? 0.0f : (float)this.scrollOffset / ((float)maxScrollOffset * 1.0f);
        int scrollSliderHeight = 14;
        int scrollSliderY = Math.round((float)position.y + (float)(size.height - scrollSliderHeight) * scrollPercent);
        ScrollableListWidget.drawGradientRect(scrollX + 1, scrollSliderY, paneSize - 2, scrollSliderHeight, -11184811, -12237499);
        RenderUtil.useScissor(position.x, position.y, size.width - paneSize, size.height, () -> super.drawInBackground(finalMouseX, finalMouseY, context));
    }

    @Override
    public boolean isWidgetClickable(Widget widget) {
        if (!super.isWidgetClickable(widget)) {
            return false;
        }
        return this.isWidgetOverlapsScissor(widget);
    }

    private boolean isPositionInsideScissor(int mouseX, int mouseY) {
        return this.isMouseOverElement(mouseX, mouseY) && !this.isOnScrollPane(mouseX, mouseY);
    }

    private boolean isWidgetOverlapsScissor(Widget widget) {
        Position position = widget.getPosition();
        Size size = widget.getSize();
        int x0 = position.x;
        int y0 = position.y;
        int x1 = position.x + size.width - 1;
        int y1 = position.y + size.height - 1;
        return this.isPositionInsideScissor(x0, y0) || this.isPositionInsideScissor(x0, y1) || this.isPositionInsideScissor(x1, y0) || this.isPositionInsideScissor(x1, y1);
    }

    private boolean isBoxInsideScissor(Rectangle rectangle) {
        return this.isPositionInsideScissor(rectangle.x, rectangle.y) && this.isPositionInsideScissor(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY, true)) {
            int direction = -MathHelper.func_76125_a((int)wheelDelta, (int)-1, (int)1);
            int moveDelta = direction * (this.slotHeight / 2);
            this.addScrollOffset(moveDelta);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.isOnScrollPane(mouseX, mouseY)) {
            this.draggedOnScrollBar = true;
        }
        if (this.isPositionInsideScissor(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        int mouseDelta = mouseY - this.lastMouseY;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.draggedOnScrollBar) {
            this.addScrollOffset(mouseDelta);
            return true;
        }
        if (this.isPositionInsideScissor(mouseX, mouseY)) {
            return super.mouseDragged(mouseX, mouseY, button, timeDragged);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.draggedOnScrollBar = false;
        if (this.isPositionInsideScissor(mouseX, mouseY)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isPositionInsideScissor(mouseX, mouseY)) {
            return super.getIngredientOverMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        return super.getPhantomTargets(ingredient).stream().filter(it -> this.isBoxInsideScissor(it.getArea())).collect(Collectors.toList());
    }
}

