/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.igredient.IGhostIngredientTarget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.SlotUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget {
    public PhantomSlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        super((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, false, true);
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stackHeld = player.field_71071_by.func_70445_o();
        return SlotUtil.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    int mouseButton = Mouse.getEventButton();
                    boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.func_150788_a((ItemStack)ingredient);
                        buffer.func_150787_b(mouseButton);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack stackHeld;
            try {
                stackHeld = buffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int mouseButton = buffer.func_150792_a();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            SlotUtil.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        }
    }
}

