/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import com.google.common.base.Preconditions;
import gregtech.api.gui.resources.TextureArea;
import net.minecraft.util.ResourceLocation;

public class SpriteMap {
    private final ResourceLocation imageLocation;
    private final int spritesPerRow;

    public SpriteMap(ResourceLocation imageLocation, int spritesPerRow) {
        this.imageLocation = imageLocation;
        this.spritesPerRow = spritesPerRow;
    }

    public TextureArea getSprite(int x, int y) {
        Preconditions.checkElementIndex((int)x, (int)this.spritesPerRow, (String)"Invalid sprite x!");
        Preconditions.checkElementIndex((int)y, (int)this.spritesPerRow, (String)"Invalid sprite y!");
        double spriteUnit = 1.0 / ((double)this.spritesPerRow * 1.0);
        return new TextureArea(this.imageLocation, spriteUnit * (double)x, spriteUnit * (double)y, spriteUnit, spriteUnit);
    }
}

