/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.impl;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.net.NetworkHandler;
import gregtech.api.net.PacketUIClientAction;
import gregtech.api.net.PacketUIWidgetUpdate;
import gregtech.api.util.GTUtility;
import gregtech.api.util.PerTickIntCounter;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketSetSlot;

public class ModularUIContainer
extends Container
implements WidgetUIAccess {
    protected final HashMap<Slot, INativeWidget> slotMap = new HashMap();
    private final ModularUI modularUI;
    public boolean accumulateWidgetUpdateData = false;
    public List<PacketUIWidgetUpdate> accumulatedUpdates = new ArrayList<PacketUIWidgetUpdate>();
    private PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    public ModularUIContainer(ModularUI modularUI) {
        this.modularUI = modularUI;
        modularUI.guiWidgets.values().forEach(widget -> widget.setUiAccess(this));
        modularUI.guiWidgets.values().stream().flatMap(widget -> widget.getNativeWidgets().stream()).forEach(nativeWidget -> {
            Slot slot = nativeWidget.getHandle();
            this.slotMap.put(slot, (INativeWidget)nativeWidget);
            this.func_75146_a(slot);
        });
        modularUI.triggerOpenListeners();
    }

    @Override
    public void notifySizeChange() {
    }

    @Override
    public void notifyWidgetChange() {
        List nativeWidgets = this.modularUI.guiWidgets.values().stream().flatMap(widget -> widget.getNativeWidgets().stream()).collect(Collectors.toList());
        HashSet<INativeWidget> removedWidgets = new HashSet<INativeWidget>(this.slotMap.values());
        removedWidgets.removeAll(nativeWidgets);
        if (!removedWidgets.isEmpty()) {
            for (INativeWidget removedWidget : removedWidgets) {
                Slot slotHandle = removedWidget.getHandle();
                this.slotMap.remove(slotHandle);
                EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
                emptySlotPlaceholder.field_75222_d = slotHandle.field_75222_d;
                this.field_75151_b.set(slotHandle.field_75222_d, emptySlotPlaceholder);
                this.field_75153_a.set(slotHandle.field_75222_d, (Object)ItemStack.field_190927_a);
            }
        }
        HashSet addedWidgets = new HashSet(nativeWidgets);
        addedWidgets.removeAll(this.slotMap.values());
        if (!addedWidgets.isEmpty()) {
            int[] emptySlotIndexes = this.field_75151_b.stream().filter(it -> it instanceof EmptySlotPlaceholder).mapToInt(slot -> slot.field_75222_d).toArray();
            int currentIndex = 0;
            for (INativeWidget addedWidget : addedWidgets) {
                Slot slotHandle = addedWidget.getHandle();
                this.slotMap.put(slotHandle, addedWidget);
                if (currentIndex < emptySlotIndexes.length) {
                    int slotIndex;
                    slotHandle.field_75222_d = slotIndex = emptySlotIndexes[currentIndex++];
                    this.field_75151_b.set(slotIndex, slotHandle);
                    this.field_75153_a.set(slotIndex, (Object)ItemStack.field_190927_a);
                    continue;
                }
                slotHandle.field_75222_d = this.field_75151_b.size();
                this.field_75151_b.add(slotHandle);
                this.field_75153_a.add((Object)ItemStack.field_190927_a);
            }
        }
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
    }

    @Override
    public void sendSlotUpdate(INativeWidget slot) {
        Slot slotHandle = slot.getHandle();
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71111_a((Container)this, slotHandle.field_75222_d, slotHandle.func_75211_c());
        }
    }

    @Override
    public void sendHeldItemUpdate() {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)listener;
            player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.field_71071_by.func_70445_o()));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.field_75149_d.size() > 0) {
            this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack result = this.slotMap.get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == INativeWidget.VANILLA_LOGIC) {
                return super.func_184996_a(slotId, dragType, clickTypeIn, player);
            }
            return result;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private List<INativeWidget> getShiftClickSlots(ItemStack itemStack, boolean fromContainer) {
        return this.slotMap.values().stream().filter(it -> it.canMergeSlot(itemStack)).filter(it -> it.getSlotLocationInfo().isPlayerInventory == fromContainer).sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandle().field_75222_d)).collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
        List<Slot> inventorySlots = this.getShiftClickSlots(itemStack, fromContainer).stream().map(INativeWidget::getHandle).collect(Collectors.toList());
        return GTUtility.mergeItemStack(itemStack, inventorySlots, simulate);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        boolean fromContainer;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (!slot.func_82869_a(player)) {
            return ItemStack.field_190927_a;
        }
        if (!slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = slot.func_75211_c();
        ItemStack stackToMerge = this.slotMap.get(slot).onItemTake(player, stackInSlot.func_77946_l(), true);
        boolean bl = fromContainer = !this.slotMap.get((Object)slot).getSlotLocationInfo().isPlayerInventory;
        if (!this.attemptMergeStack(stackToMerge, fromContainer, true)) {
            return ItemStack.field_190927_a;
        }
        int itemsMerged = stackToMerge.func_190926_b() || this.slotMap.get(slot).canMergeSlot(stackToMerge) ? stackInSlot.func_190916_E() - stackToMerge.func_190916_E() : stackInSlot.func_190916_E();
        int itemsToExtract = itemsMerged;
        if ((itemsMerged += this.transferredPerTick.get(player.field_70170_p)) > stackInSlot.func_77976_d()) {
            return ItemStack.field_190927_a;
        }
        this.transferredPerTick.increment(player.field_70170_p, itemsToExtract);
        ItemStack extractedStack = stackInSlot.func_77979_a(itemsToExtract);
        if (stackInSlot.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        extractedStack = this.slotMap.get(slot).onItemTake(player, extractedStack, false);
        ItemStack resultStack = extractedStack.func_77946_l();
        if (!this.attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = ItemStack.field_190927_a;
        }
        if (!extractedStack.func_190926_b()) {
            player.func_146097_a(extractedStack, false, false);
            resultStack = ItemStack.field_190927_a;
        }
        return resultStack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.slotMap.get(slotIn).canMergeSlot(stack);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerSP) {
            PacketUIClientAction widgetUpdate = new PacketUIClientAction(this.field_75152_c, widgetId, packetBuffer);
            NetworkHandler.channel.sendToServer(NetworkHandler.packet2proxy(widgetUpdate));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerMP) {
            PacketUIWidgetUpdate widgetUpdate = new PacketUIWidgetUpdate(this.field_75152_c, widgetId, packetBuffer);
            if (!this.accumulateWidgetUpdateData) {
                NetworkHandler.channel.sendTo(NetworkHandler.packet2proxy(widgetUpdate), (EntityPlayerMP)this.modularUI.entityPlayer);
            } else {
                this.accumulatedUpdates.add(widgetUpdate);
            }
        }
    }

    private static class EmptySlotPlaceholder
    extends Slot {
        private static final IInventory EMPTY_INVENTORY = new InventoryBasic("Empty Inventory", false, 0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        public ItemStack func_75211_c() {
            return ItemStack.field_190927_a;
        }

        public void func_75215_d(ItemStack stack) {
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }

        public boolean func_111238_b() {
            return false;
        }
    }
}

