/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.google.common.base.Preconditions;
import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ISizeProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class Widget {
    protected ModularUI gui;
    protected ISizeProvider sizes;
    protected WidgetUIAccess uiAccess;
    private Position parentPosition = Position.ORIGIN;
    private Position selfPosition;
    private Position position;
    private Size size;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public void setSizes(ISizeProvider sizes) {
        this.sizes = sizes;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public void setParentPosition(Position parentPosition) {
        Preconditions.checkNotNull((Object)parentPosition, (Object)"parentPosition");
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    protected void setSelfPosition(Position selfPosition) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        this.selfPosition = selfPosition;
        this.recomputePosition();
    }

    protected void setSize(Size size) {
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.size = size;
        this.onSizeUpdate();
    }

    public final Position getPosition() {
        return this.position;
    }

    public final Size getSize() {
        return this.size;
    }

    public Rectangle toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new Rectangle(pos.x, pos.y, size.width, size.height);
    }

    private void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    public void applyScissor(int parentX, int parentY, int parentWidth, int parentHeight) {
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    public boolean isMouseOverElement(int mouseX, int mouseY, boolean correctPositionOnMouseWheelMoveEvent) {
        mouseX = correctPositionOnMouseWheelMoveEvent ? mouseX + this.getPosition().x : mouseX;
        return this.isMouseOverElement(mouseX, mouseY);
    }

    public boolean isMouseOverElement(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && x + width > mouseX && y + height > mouseY;
    }

    public void initWidget() {
    }

    public void detectAndSendChanges() {
    }

    public void updateScreen() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyTyped(char charTyped, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
    }

    public void handleClientAction(int id, PacketBuffer buffer) {
    }

    public List<INativeWidget> getNativeWidgets() {
        if (this instanceof INativeWidget) {
            return Collections.singletonList((INativeWidget)((Object)this));
        }
        return Collections.emptyList();
    }

    protected final void writeUpdateInfo(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected final void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null) {
            this.uiAccess.writeClientAction(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawHoveringText(ItemStack itemStack, List<String> tooltip, int maxTextWidth, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((ItemStack)itemStack, tooltip, (int)mouseX, (int)mouseY, (int)this.sizes.getScreenWidth(), (int)this.sizes.getScreenHeight(), (int)maxTextWidth, (FontRenderer)mc.field_71466_p);
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawStringSized(String text, double x, double y, int color, boolean dropShadow, float scale, boolean center) {
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledTextWidth = center ? (double)((float)fontRenderer.func_78256_a(text) * scale) : 0.0;
        GlStateManager.func_179137_b((double)(x + scaledTextWidth / 2.0), (double)y, (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, dropShadow);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawStringFixedCorner(String text, double x, double y, int color, boolean dropShadow, float scale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledWidth = (float)fontRenderer.func_78256_a(text) * scale;
        double scaledHeight = (float)fontRenderer.field_78288_b * scale;
        this.drawStringSized(text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawItemStack(ItemStack itemStack, int x, int y, @Nullable String altTxt) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRender = mc.func_175599_af();
        itemRender.func_180450_b(itemStack, x, y);
        itemRender.func_180453_a(mc.field_71466_p, itemStack, x, y, altTxt);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
    }

    @SideOnly(value=Side.CLIENT)
    protected static List<String> getItemToolTip(ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        ITooltipFlag.TooltipFlags flag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        List tooltip = itemStack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)flag);
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i == 0) {
                tooltip.set(i, itemStack.func_77973_b().getForgeRarity(itemStack).getColor() + (String)tooltip.get(i));
                continue;
            }
            tooltip.set(i, TextFormatting.GRAY + (String)tooltip.get(i));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawSelectionOverlay(int x, int y, int width, int height) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Widget.drawGradientRect(x, y, width, height, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawSolidRect(int x, int y, int width, int height, int color) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawGradientRect(int x, int y, int width, int height, int startColor, int endColor) {
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)startColor, (int)endColor);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    protected void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    protected static boolean isClientSide() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static class ClientSideField<T> {
        @SideOnly(value=Side.CLIENT)
        private T fieldValue;

        public ClientSideField(Supplier<T> initializer) {
            if (Widget.isClientSide()) {
                this.fieldValue = initializer.get();
            }
        }

        public void useOnClient(Consumer<T> callback) {
            if (Widget.isClientSide()) {
                callback.accept(this.fieldValue);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public T get() {
            return this.fieldValue;
        }
    }

    public static final class ClickData {
        public final int button;
        public final boolean isShiftClick;
        public final boolean isCtrlClick;

        public ClickData(int button, boolean isShiftClick, boolean isCtrlClick) {
            this.button = button;
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.func_150787_b(this.button);
            buf.writeBoolean(this.isShiftClick);
            buf.writeBoolean(this.isCtrlClick);
        }

        public static ClickData readFromBuf(PacketBuffer buf) {
            int button = buf.func_150792_a();
            boolean shiftClick = buf.readBoolean();
            boolean ctrlClick = buf.readBoolean();
            return new ClickData(button, shiftClick, ctrlClick);
        }
    }
}

