/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enchants;

import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.mc1120.enchantments.MCEnchantmentDefinition;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenClass(value="mods.gregtech.EnchantmentData")
public class EnchantmentData {
    public final Enchantment enchantment;
    public final int level;

    public EnchantmentData(Enchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    @ZenGetter(value="level")
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @ZenGetter(value="enchantment")
    @Optional.Method(modid="crafttweaker")
    public IEnchantmentDefinition ctGetEnchantment() {
        return new MCEnchantmentDefinition(this.enchantment);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantmentData that = (EnchantmentData)o;
        if (this.level != that.level) {
            return false;
        }
        return this.enchantment.equals(that.enchantment);
    }

    public int hashCode() {
        int result = this.enchantment.hashCode();
        result = 31 * result + this.level;
        return result;
    }
}

