/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.LongSupplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class AbstractRecipeLogic
extends MTETrait
implements IWorkable {
    private static final String ALLOW_OVERCLOCKING = "AllowOverclocking";
    private static final String OVERCLOCK_VOLTAGE = "OverclockVoltage";
    public final RecipeMap<?> recipeMap;
    protected boolean forceRecipeRecheck;
    protected ItemStack[] lastItemInputs;
    protected FluidStack[] lastFluidInputs;
    protected Recipe previousRecipe;
    protected boolean allowOverclocking = true;
    private long overclockVoltage = 0L;
    private LongSupplier overclockPolicy = this::getMaxVoltage;
    protected int progressTime;
    protected int maxProgressTime;
    protected int recipeEUt;
    protected List<FluidStack> fluidOutputs;
    protected NonNullList<ItemStack> itemOutputs;
    protected final Random random = new Random();
    protected boolean isActive;
    protected boolean workingEnabled = true;
    protected boolean hasNotEnoughEnergy;
    protected boolean wasActiveAndNeedsUpdate;

    public AbstractRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap) {
        super(tileEntity);
        this.recipeMap = recipeMap;
    }

    protected abstract long getEnergyStored();

    protected abstract long getEnergyCapacity();

    protected abstract boolean drawEnergy(int var1);

    protected abstract long getMaxVoltage();

    protected IItemHandlerModifiable getInputInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected IItemHandlerModifiable getOutputInventory() {
        return this.metaTileEntity.getExportItems();
    }

    protected IMultipleTankHandler getInputTank() {
        return this.metaTileEntity.getImportFluids();
    }

    protected IMultipleTankHandler getOutputTank() {
        return this.metaTileEntity.getExportFluids();
    }

    @Override
    public String getName() {
        return "RecipeMapWorkable";
    }

    @Override
    public int getNetworkID() {
        return 2;
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return null;
    }

    @Override
    public void update() {
        if (!this.getMetaTileEntity().getWorld().field_72995_K) {
            if (this.workingEnabled) {
                if (this.progressTime > 0) {
                    this.updateRecipeProgress();
                }
                if (this.progressTime == 0) {
                    this.trySearchNewRecipe();
                }
            }
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
                this.setActive(false);
            }
        }
    }

    protected void updateRecipeProgress() {
        boolean drawEnergy = this.drawEnergy(this.recipeEUt);
        if (drawEnergy || this.recipeEUt < 0) {
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
        } else if (this.recipeEUt > 0) {
            this.hasNotEnoughEnergy = true;
            if (this.progressTime >= 2) {
                this.progressTime = ConfigHolder.insufficientEnergySupplyWipesRecipeProgress ? 1 : Math.max(1, this.progressTime - 2);
            }
        }
    }

    protected void trySearchNewRecipe() {
        long maxVoltage = this.getMaxVoltage();
        Recipe currentRecipe = null;
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        if (this.previousRecipe != null && this.previousRecipe.matches(false, importInventory, importFluids)) {
            currentRecipe = this.previousRecipe;
        } else {
            boolean dirty = this.checkRecipeInputsDirty((IItemHandler)importInventory, importFluids);
            if (dirty || this.forceRecipeRecheck) {
                this.forceRecipeRecheck = false;
                currentRecipe = this.findRecipe(maxVoltage, importInventory, importFluids);
                if (currentRecipe != null) {
                    this.previousRecipe = currentRecipe;
                }
            }
        }
        if (currentRecipe != null && this.setupAndConsumeRecipeInputs(currentRecipe)) {
            this.setupRecipe(currentRecipe);
        }
    }

    public void forceRecipeRecheck() {
        this.forceRecipeRecheck = true;
    }

    protected int getMinTankCapacity(IMultipleTankHandler tanks) {
        if (tanks.getTanks() == 0) {
            return 0;
        }
        int result = Integer.MAX_VALUE;
        for (IFluidTank fluidTank : tanks.getFluidTanks()) {
            result = Math.min(fluidTank.getCapacity(), result);
        }
        return result;
    }

    protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.recipeMap.findRecipe(maxVoltage, inputs, fluidInputs, this.getMinTankCapacity(this.getOutputTank()));
    }

    protected boolean checkRecipeInputsDirty(IItemHandler inputs, IMultipleTankHandler fluidInputs) {
        ItemStack lastStack;
        ItemStack currentStack;
        int i;
        boolean shouldRecheckRecipe = false;
        if (this.lastItemInputs == null || this.lastItemInputs.length != inputs.getSlots()) {
            this.lastItemInputs = new ItemStack[inputs.getSlots()];
            Arrays.fill(this.lastItemInputs, ItemStack.field_190927_a);
        }
        if (this.lastFluidInputs == null || this.lastFluidInputs.length != fluidInputs.getTanks()) {
            this.lastFluidInputs = new FluidStack[fluidInputs.getTanks()];
        }
        for (i = 0; i < this.lastItemInputs.length; ++i) {
            currentStack = inputs.getStackInSlot(i);
            if (!AbstractRecipeLogic.areItemStacksEqual(currentStack, lastStack = this.lastItemInputs[i])) {
                this.lastItemInputs[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                shouldRecheckRecipe = true;
                continue;
            }
            if (currentStack.func_190916_E() == lastStack.func_190916_E()) continue;
            lastStack.func_190920_e(currentStack.func_190916_E());
            shouldRecheckRecipe = true;
        }
        for (i = 0; i < this.lastFluidInputs.length; ++i) {
            currentStack = fluidInputs.getTankAt(i).getFluid();
            lastStack = this.lastFluidInputs[i];
            if (currentStack == null && lastStack != null || currentStack != null && !currentStack.isFluidEqual((FluidStack)lastStack)) {
                this.lastFluidInputs[i] = currentStack == null ? null : currentStack.copy();
                shouldRecheckRecipe = true;
                continue;
            }
            if (currentStack == null || lastStack == null || currentStack.amount == lastStack.amount) continue;
            lastStack.amount = currentStack.amount;
            shouldRecheckRecipe = true;
        }
        return shouldRecheckRecipe;
    }

    protected static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_190926_b() && stackB.func_190926_b() || ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    protected boolean setupAndConsumeRecipeInputs(Recipe recipe) {
        int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), recipe.getDuration());
        int totalEUt = resultOverclock[0] * resultOverclock[1];
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IItemHandlerModifiable exportInventory = this.getOutputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        IMultipleTankHandler exportFluids = this.getOutputTank();
        return (totalEUt >= 0 ? this.getEnergyStored() >= (long)((long)totalEUt > this.getEnergyCapacity() / 2L ? resultOverclock[0] : totalEUt) : this.getEnergyStored() - (long)resultOverclock[0] <= this.getEnergyCapacity()) && MetaTileEntity.addItemsToItemHandler((IItemHandler)exportInventory, true, recipe.getAllItemOutputs(exportInventory.getSlots())) && MetaTileEntity.addFluidsToFluidHandler(exportFluids, true, recipe.getFluidOutputs()) && recipe.matches(true, importInventory, importFluids);
    }

    protected int[] calculateOverclock(int EUt, int duration) {
        return this.calculateOverclock(EUt, this.overclockPolicy.getAsLong(), duration);
    }

    protected int[] calculateOverclock(int EUt, long voltage, int duration) {
        double resultDuration;
        if (!this.allowOverclocking) {
            return new int[]{EUt, duration};
        }
        boolean negativeEU = EUt < 0;
        int tier = this.getOverclockingTier(voltage);
        if (GTValues.V[tier] <= (long)EUt || tier == 0) {
            return new int[]{EUt, duration};
        }
        if (negativeEU) {
            EUt = -EUt;
        }
        if (EUt <= 16) {
            int multiplier = EUt <= 8 ? tier : tier - 1;
            int resultEUt = EUt * (1 << multiplier) * (1 << multiplier);
            int resultDuration2 = duration / (1 << multiplier);
            return new int[]{negativeEU ? -resultEUt : resultEUt, resultDuration2};
        }
        int resultEUt = EUt;
        for (resultDuration = (double)duration; resultDuration >= 3.0 && (long)resultEUt <= GTValues.V[tier - 1]; resultDuration /= 2.8) {
            resultEUt *= 4;
        }
        return new int[]{negativeEU ? -resultEUt : resultEUt, (int)Math.ceil(resultDuration)};
    }

    protected int getOverclockingTier(long voltage) {
        return GTUtility.getTierByVoltage(voltage);
    }

    protected long getVoltageByTier(int tier) {
        return GTValues.V[tier];
    }

    public String[] getAvailableOverclockingTiers() {
        int maxTier = this.getOverclockingTier(this.getMaxVoltage());
        String[] result = new String[maxTier + 2];
        result[0] = "gregtech.gui.overclock.off";
        for (int i = 0; i < maxTier + 1; ++i) {
            result[i + 1] = GTValues.VN[i];
        }
        return result;
    }

    protected void setupRecipe(Recipe recipe) {
        int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), recipe.getDuration());
        this.progressTime = 1;
        this.setMaxProgress(resultOverclock[1]);
        this.recipeEUt = resultOverclock[0];
        this.fluidOutputs = GTUtility.copyFluidList(recipe.getFluidOutputs());
        int tier = this.getMachineTierForRecipe(recipe);
        this.itemOutputs = GTUtility.copyStackList(recipe.getResultItemOutputs(this.getOutputInventory().getSlots(), this.random, tier));
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    protected int getMachineTierForRecipe(Recipe recipe) {
        return GTUtility.getTierByVoltage(this.getMaxVoltage());
    }

    protected void completeRecipe() {
        MetaTileEntity.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), false, this.itemOutputs);
        MetaTileEntity.addFluidsToFluidHandler(this.getOutputTank(), false, this.fluidOutputs);
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.fluidOutputs = null;
        this.itemOutputs = null;
        this.hasNotEnoughEnergy = false;
        this.wasActiveAndNeedsUpdate = true;
        this.forceRecipeRecheck = true;
    }

    public double getProgressPercent() {
        return this.getMaxProgress() == 0 ? 0.0 : (double)this.getProgress() / ((double)this.getMaxProgress() * 1.0);
    }

    public int getTicksTimeLeft() {
        return this.maxProgressTime == 0 ? 0 : this.maxProgressTime - this.progressTime;
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgressTime;
    }

    public int getRecipeEUt() {
        return this.recipeEUt;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgressTime = maxProgress;
        this.metaTileEntity.markDirty();
    }

    protected void setActive(boolean active) {
        this.isActive = active;
        this.metaTileEntity.markDirty();
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.writeCustomData(1, buf -> buf.writeBoolean(active));
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        this.metaTileEntity.markDirty();
    }

    public void setAllowOverclocking(boolean allowOverclocking) {
        this.allowOverclocking = allowOverclocking;
        this.overclockVoltage = allowOverclocking ? this.getMaxVoltage() : 0L;
        this.metaTileEntity.markDirty();
    }

    public boolean isHasNotEnoughEnergy() {
        return this.hasNotEnoughEnergy;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isAllowOverclocking() {
        return this.allowOverclocking;
    }

    public long getOverclockVoltage() {
        return this.overclockVoltage;
    }

    public void setOverclockVoltage(long overclockVoltage) {
        this.overclockPolicy = this::getOverclockVoltage;
        this.overclockVoltage = overclockVoltage;
        this.allowOverclocking = overclockVoltage != 0L;
        this.metaTileEntity.markDirty();
    }

    public void enableOverclockVoltage() {
        this.setOverclockVoltage(this.getMaxVoltage());
    }

    public int getOverclockTier() {
        if (this.overclockVoltage == 0L) {
            return 0;
        }
        return 1 + this.getOverclockingTier(this.overclockVoltage);
    }

    public void setOverclockTier(int tier) {
        if (tier == 0) {
            this.setOverclockVoltage(0L);
            return;
        }
        this.setOverclockVoltage(this.getVoltageByTier(tier - 1));
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 1) {
            this.isActive = buf.readBoolean();
            this.getMetaTileEntity().getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialData(PacketBuffer buf) {
        this.isActive = buf.readBoolean();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("WorkEnabled", this.workingEnabled);
        compound.func_74757_a(ALLOW_OVERCLOCKING, this.allowOverclocking);
        compound.func_74772_a(OVERCLOCK_VOLTAGE, this.overclockVoltage);
        if (this.progressTime > 0) {
            compound.func_74768_a("Progress", this.progressTime);
            compound.func_74768_a("MaxProgress", this.maxProgressTime);
            compound.func_74768_a("RecipeEUt", this.recipeEUt);
            NBTTagList itemOutputsList = new NBTTagList();
            for (ItemStack itemOutput : this.itemOutputs) {
                itemOutputsList.func_74742_a((NBTBase)itemOutput.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList fluidOutputsList = new NBTTagList();
            for (FluidStack fluidOutput : this.fluidOutputs) {
                fluidOutputsList.func_74742_a((NBTBase)fluidOutput.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ItemOutputs", (NBTBase)itemOutputsList);
            compound.func_74782_a("FluidOutputs", (NBTBase)fluidOutputsList);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        this.workingEnabled = compound.func_74767_n("WorkEnabled");
        this.progressTime = compound.func_74762_e("Progress");
        if (compound.func_74764_b(ALLOW_OVERCLOCKING)) {
            this.allowOverclocking = compound.func_74767_n(ALLOW_OVERCLOCKING);
        }
        this.overclockVoltage = compound.func_74764_b(OVERCLOCK_VOLTAGE) ? compound.func_74763_f(OVERCLOCK_VOLTAGE) : (this.allowOverclocking ? this.getMaxVoltage() : 0L);
        this.isActive = false;
        if (this.progressTime > 0) {
            this.isActive = true;
            this.maxProgressTime = compound.func_74762_e("MaxProgress");
            this.recipeEUt = compound.func_74762_e("RecipeEUt");
            NBTTagList itemOutputsList = compound.func_150295_c("ItemOutputs", 10);
            this.itemOutputs = NonNullList.func_191196_a();
            for (int i = 0; i < itemOutputsList.func_74745_c(); ++i) {
                this.itemOutputs.add((Object)new ItemStack(itemOutputsList.func_150305_b(i)));
            }
            NBTTagList fluidOutputsList = compound.func_150295_c("FluidOutputs", 10);
            this.fluidOutputs = new ArrayList<FluidStack>();
            for (int i = 0; i < fluidOutputsList.func_74745_c(); ++i) {
                this.fluidOutputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidOutputsList.func_150305_b(i)));
            }
        }
    }
}

