/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IFuelInfo;

public abstract class AbstractFuelInfo
implements IFuelInfo {
    private int fuelRemaining;
    private int fuelCapacity;
    private int fuelMinConsumed;
    private long fuelBurnTime;

    public AbstractFuelInfo(int fuelRemaining, int fuelCapacity, int fuelMinConsumed, int fuelBurnTime) {
        this(fuelRemaining, fuelCapacity, fuelMinConsumed, (long)fuelBurnTime);
    }

    public AbstractFuelInfo(int fuelRemaining, int fuelCapacity, int fuelMinConsumed, long fuelBurnTime) {
        this.fuelRemaining = fuelRemaining;
        this.fuelCapacity = fuelCapacity;
        this.fuelMinConsumed = fuelMinConsumed;
        this.fuelBurnTime = fuelBurnTime;
    }

    @Override
    public int getFuelRemaining() {
        return this.fuelRemaining;
    }

    @Override
    public int getFuelCapacity() {
        return this.fuelCapacity;
    }

    @Override
    public int getFuelMinConsumed() {
        return this.fuelMinConsumed;
    }

    @Override
    public int getFuelBurnTime() {
        return this.fuelBurnTime > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.fuelBurnTime;
    }

    @Override
    public long getFuelBurnTimeLong() {
        return this.fuelBurnTime;
    }

    public void setFuelRemaining(int fuelRemaining) {
        this.fuelRemaining = fuelRemaining;
    }

    public void setFuelCapacity(int fuelCapacity) {
        this.fuelCapacity = fuelCapacity;
    }

    public void setMinConsumed(int fuelMinConsumed) {
        this.fuelMinConsumed = fuelMinConsumed;
    }

    @Deprecated
    public void setFuelBurnTime(int fuelBurnTime) {
        this.fuelBurnTime = fuelBurnTime;
    }

    public void setFuelBurnTime(long fuelBurnTime) {
        this.fuelBurnTime = fuelBurnTime;
    }

    public void addFuelRemaining(int fuelRemaining) {
        this.fuelRemaining += fuelRemaining;
    }

    public void addFuelCapacity(int fuelCapacity) {
        this.fuelCapacity += fuelCapacity;
    }

    @Deprecated
    public void addFuelBurnTime(int fuelBurnTime) {
        this.fuelBurnTime += (long)fuelBurnTime;
    }

    public void addFuelBurnTime(long fuelBurnTime) {
        this.fuelBurnTime += fuelBurnTime;
    }
}

