/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class BiomeRepository {
    private static Random generator = new Random();
    private static HashMap<Integer, Integer> IDtoColor = new HashMap(256);
    private static TreeMap<String, Integer> nameToColor = new TreeMap();
    private static boolean dirty = false;

    public static void loadBiomeColors() {
        File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
        File settingsFile = new File(saveDir, "biomeColors.txt");
        if (settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length != 2) continue;
                    String name = curLine[0];
                    int color = 0;
                    try {
                        color = Integer.decode(curLine[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                        color = 0;
                    }
                    if (nameToColor.put(name, color) == null) continue;
                    dirty = true;
                }
                br.close();
            }
            catch (Exception e) {
                System.err.println("biome load error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        try {
            String sCurrentLine;
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("voxelmap", "conf/biomecolors.txt")).func_110527_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] curLine = sCurrentLine.split(":");
                if (curLine.length != 2) continue;
                String name = curLine[0];
                int color = 0;
                try {
                    color = Integer.decode(curLine[1]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                    color = 0;
                }
                if (nameToColor.get(name) != null) continue;
                nameToColor.put(name, color);
                dirty = true;
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            System.out.println("Error loading biome color config file from litemod!");
            e.printStackTrace();
        }
    }

    public static void saveBiomeColors() {
        if (dirty) {
            File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File settingsFile = new File(saveDir, "biomeColors.txt");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (Map.Entry<String, Integer> entry : nameToColor.entrySet()) {
                    String name = entry.getKey();
                    Integer color = entry.getValue();
                    String hexColor = Integer.toHexString(color);
                    while (hexColor.length() < 6) {
                        hexColor = "0" + hexColor;
                    }
                    hexColor = "0x" + hexColor;
                    out.println(name + ":" + hexColor);
                }
                out.close();
            }
            catch (Exception e) {
                System.err.println("biome save error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        dirty = false;
    }

    public static int getBiomeColor(int biomeID) {
        Integer color = IDtoColor.get(biomeID);
        if (color == null) {
            Biome biome = Biome.func_185357_a((int)biomeID);
            if (biome != null) {
                String name = biome.func_185359_l();
                color = nameToColor.get(name);
                if (color == null) {
                    int r = generator.nextInt(255);
                    int g = generator.nextInt(255);
                    int b = generator.nextInt(255);
                    color = r << 16 | g << 8 | b;
                    nameToColor.put(name, color);
                    dirty = true;
                }
            } else {
                System.out.println("non biome");
                color = 0;
            }
            IDtoColor.put(biomeID, color);
        }
        return color;
    }
}

