/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiSlotMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public class GuiMobs
extends GuiScreenMinimap {
    private final GuiScreen parentScreen;
    protected final RadarSettingsManager options;
    protected String screenTitle = "Select Mobs";
    private GuiSlotMobs mobsList;
    private GuiButton buttonEnable;
    private GuiButton buttonDisable;
    protected GuiTextField filter;
    private String tooltip = null;
    protected String selectedMobName = null;

    public GuiMobs(GuiScreen parentScreen, RadarSettingsManager options) {
        this.parentScreen = parentScreen;
        this.options = options;
    }

    public void func_73876_c() {
        this.filter.func_146178_a();
    }

    public void func_73866_w_() {
        boolean isSomethingSelected;
        this.screenTitle = I18nUtils.getString("options.minimap.mobs.title", new Object[0]);
        Keyboard.enableRepeatEvents((boolean)true);
        this.mobsList = new GuiSlotMobs(this);
        this.mobsList.registerScrollButtons(7, 8);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new GuiTextField(2, this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 56, 305 - filterStringWidth - 5, 20);
        this.filter.func_146203_f(35);
        this.filter.func_146195_b(true);
        this.buttonEnable = new GuiButton(-1, this.getWidth() / 2 - 154, this.getHeight() - 28, 100, 20, I18nUtils.getString("options.minimap.mobs.enable", new Object[0]));
        this.getButtonList().add(this.buttonEnable);
        this.buttonDisable = new GuiButton(-2, this.getWidth() / 2 - 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("options.minimap.mobs.disable", new Object[0]));
        this.getButtonList().add(this.buttonDisable);
        this.getButtonList().add(new GuiButton(-200, this.getWidth() / 2 + 4 + 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("gui.done", new Object[0])));
        this.buttonEnable.field_146124_l = isSomethingSelected = this.selectedMobName != null;
        this.buttonDisable.field_146124_l = isSomethingSelected;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == -1) {
                this.setMobEnabled(this.selectedMobName, true);
            }
            if (par1GuiButton.field_146127_k == -2) {
                this.setMobEnabled(this.selectedMobName, false);
            }
            if (par1GuiButton.field_146127_k == -200) {
                this.getMinecraft().func_147108_a(this.parentScreen);
            }
        }
    }

    protected void func_73869_a(char character, int keycode) throws IOException {
        super.func_73869_a(character, keycode);
        if (this.filter.func_146201_a(character, keycode)) {
            this.mobsList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.filter.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void setSelectedMob(String mob) {
        this.selectedMobName = mob;
    }

    private boolean isMobEnabled(String selectedMobName2) {
        EnumMobs mob = EnumMobs.getMobByName(this.selectedMobName);
        if (mob != null) {
            return mob.enabled;
        }
        CustomMob customMob = CustomMobsManager.getCustomMobByType(this.selectedMobName);
        if (customMob != null) {
            return customMob.enabled;
        }
        return false;
    }

    private void setMobEnabled(String selectedMobName, boolean enabled) {
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.id.equals(selectedMobName)) continue;
            mob.enabled = enabled;
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if (!mob.id.equals(selectedMobName)) continue;
            mob.enabled = enabled;
        }
    }

    protected void toggleMobVisibility() {
        EnumMobs mob = EnumMobs.getMobByName(this.selectedMobName);
        if (mob != null) {
            this.setMobEnabled(this.selectedMobName, !mob.enabled);
        } else {
            CustomMob customMob = CustomMobsManager.getCustomMobByType(this.selectedMobName);
            if (customMob != null) {
                this.setMobEnabled(this.selectedMobName, !customMob.enabled);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.mobsList != null) {
            this.mobsList.handleMouseInput();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.drawMap();
        this.tooltip = null;
        this.mobsList.drawScreen(par1, par2, par3);
        this.func_73732_a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        boolean isSomethingSelected = this.selectedMobName != null;
        this.buttonEnable.field_146124_l = isSomethingSelected && !this.isMobEnabled(this.selectedMobName);
        this.buttonDisable.field_146124_l = isSomethingSelected && this.isMobEnabled(this.selectedMobName);
        super.func_73863_a(par1, par2, par3);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 51, 0xA0A0A0);
        this.filter.func_146194_f();
        if (this.tooltip != null) {
            this.drawTooltip(this.tooltip, par1, par2);
        }
    }

    protected void drawTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().func_78256_a(par1Str);
            this.func_73733_a(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().func_175063_a(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiMobs par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }
}

