/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.forgemod;

import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Timer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandler {
    private VoxelMap voxelMap;
    private Timer timer = null;

    public TickHandler(VoxelMap voxelMap) {
        this.voxelMap = voxelMap;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.timer == null) {
            this.timer = (Timer)ReflectionUtils.getPrivateFieldValueByType(Minecraft.func_71410_x(), Minecraft.class, Timer.class);
        }
        boolean clock = this.timer.field_74280_b > 0;
        this.voxelMap.onTick(Minecraft.func_71410_x(), clock);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.voxelMap.onTickInGame(Minecraft.func_71410_x());
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderWorldLastEvent event) {
        this.voxelMap.getWaypointManager().renderWaypoints(event.getPartialTicks());
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        String message;
        ITextComponent chat = event.getMessage();
        if (!CommandUtils.checkForWaypoints(chat, message = chat.func_150254_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSendChatMessage(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.startsWith("/newWaypoint")) {
            CommandUtils.waypointClicked(message);
            event.setCanceled(true);
        } else if (message.startsWith("/ztp")) {
            CommandUtils.teleport(message);
            event.setCanceled(true);
        }
    }
}

