/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.common.collect.Lists;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.FilesystemUtils;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mamiyaotaru.voxelmap.util.WaypointContainer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WaypointManager
implements IWaypointManager {
    IVoxelMap master;
    private Minecraft game;
    public MapSettingsManager options = null;
    TextureAtlas textureAtlas;
    TextureAtlas textureAtlasChooser;
    private boolean loaded = false;
    private boolean needSave = false;
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private ArrayList<Waypoint> old2dWayPts = new ArrayList();
    private ArrayList<Waypoint> updatedPts;
    private Waypoint highlightedWaypoint = null;
    private String worldName = "";
    private String latestRealmsID = "";
    private String currentSubWorldName = "";
    private String currentSubWorldHash = "";
    private String currentSubworldDescriptor = "";
    private String currentSubworldDescriptorNoCodes = "";
    private boolean multiworld = false;
    private boolean gotAutoSubworldName = false;
    private float currentDimension = 0.5f;
    private TreeSet<String> knownSubworldNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private HashSet<String> oldNorthWorldNames = new HashSet();
    private HashMap<String, String> worldSeeds = new HashMap();
    private BackgroundImageInfo backgroundImageInfo = null;
    private WaypointContainer waypointContainer = null;
    private File settingsFile;
    private Long lastNewWorldNameTime = 0L;
    private Object waypointLock = new Object();

    public WaypointManager(IVoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
        this.textureAtlas = new TextureAtlas("waypoints");
        this.textureAtlas.func_174937_a(false, false);
        this.textureAtlasChooser = new TextureAtlas("chooser");
        this.textureAtlasChooser.func_174937_a(false, false);
        this.waypointContainer = new WaypointContainer(this.options);
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        final ArrayList images = new ArrayList();
        IIconCreator iconCreator = new IIconCreator(){

            @Override
            public void addIcons(TextureAtlas textureAtlas) {
                Minecraft mc = Minecraft.func_71410_x();
                ArrayList packs = Lists.newArrayList();
                Object defaultResourcePacksObj = ReflectionUtils.getPrivateFieldValueByType(mc, Minecraft.class, List.class, 1);
                if (defaultResourcePacksObj != null) {
                    List defaultResourcePacks = (List)defaultResourcePacksObj;
                    packs.addAll(defaultResourcePacks);
                }
                List packEntries = mc.func_110438_M().func_110613_c();
                Iterator packEntriesIterator = packEntries.iterator();
                while (packEntriesIterator.hasNext()) {
                    IResourcePack pack = ((ResourcePackRepository.Entry)packEntriesIterator.next()).func_110514_c();
                    packs.add(pack);
                }
                if (mc.func_110438_M().func_148530_e() != null) {
                    packs.add(mc.func_110438_M().func_148530_e());
                }
                for (IResourcePack pack : packs) {
                    if (pack instanceof FileResourcePack) {
                        FileResourcePack filePack = (FileResourcePack)pack;
                        this.addImagesFromFilePack(filePack, images);
                        continue;
                    }
                    if (!(pack instanceof FolderResourcePack)) continue;
                    FolderResourcePack folderPack = (FolderResourcePack)pack;
                    this.addImagesFromFolderPack(folderPack, images);
                }
                Sprite markerIcon = textureAtlas.registerIconForResource(new ResourceLocation("voxelmap", "images/waypoints/marker.png"), Minecraft.func_71410_x().func_110442_L());
                Sprite markerIconSmall = textureAtlas.registerIconForResource(new ResourceLocation("voxelmap", "images/waypoints/markersmall.png"), Minecraft.func_71410_x().func_110442_L());
                for (ResourceLocation resourceLocation : images) {
                    Sprite icon = textureAtlas.registerIconForResource(resourceLocation, Minecraft.func_71410_x().func_110442_L());
                    String name = resourceLocation.toString();
                    if (name.toLowerCase().contains("waypoints/waypoint") && !name.toLowerCase().contains("small")) {
                        textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker"), markerIcon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker").replace(".png", "Small.png"), markerIconSmall);
                        continue;
                    }
                    if (!name.toLowerCase().contains("waypoints/marker") || name.toLowerCase().contains("small")) continue;
                    textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                }
            }

            void addImagesFromFilePack(FileResourcePack filePack, List<ResourceLocation> images2) {
                ZipFile zipFile;
                ZipEntry waypointsFolder;
                Object zipFileObj = ReflectionUtils.getPrivateFieldValueByType(filePack, FileResourcePack.class, ZipFile.class);
                if (zipFileObj != null && (waypointsFolder = (zipFile = (ZipFile)zipFileObj).getEntry("assets/voxelmap/images/waypoints")) != null) {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        String name = zipEntry.getName();
                        if (!name.startsWith("assets/voxelmap/images/waypoints") || !name.toLowerCase().endsWith(".png")) continue;
                        name = name.replaceFirst("assets/voxelmap/", "");
                        images2.add(new ResourceLocation("voxelmap", name));
                    }
                }
            }

            void addImagesFromFolderPack(FolderResourcePack folderPack, List<ResourceLocation> images2) {
                File rootFolder;
                File assetsDir;
                Object rootFolderObj = ReflectionUtils.getPrivateFieldValueByType(folderPack, AbstractResourcePack.class, File.class);
                if (rootFolderObj != null && (assetsDir = new File(rootFolder = (File)rootFolderObj, "assets/voxelmap/images/waypoints")).isDirectory()) {
                    for (File file : assetsDir.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith(".png")) continue;
                        String name = "images/waypoints/" + file.getName();
                        images2.add(new ResourceLocation("voxelmap", name));
                    }
                }
            }
        };
        this.textureAtlas.loadTextureAtlas(iconCreator);
        this.textureAtlasChooser.reset();
        int expectedSize = 32;
        for (ResourceLocation resourceLocation : images) {
            String name = resourceLocation.toString();
            if (!name.toLowerCase().contains("waypoints/waypoint") || name.toLowerCase().contains("small")) continue;
            try {
                IResource imageResource = resourceManager.func_110536_a(resourceLocation);
                BufferedImage bufferedImage = ImageIO.read(imageResource.func_110527_b());
                imageResource.close();
                float scale = (float)expectedSize / (float)bufferedImage.getWidth();
                bufferedImage = ImageUtils.scaleImage(bufferedImage, scale);
                this.textureAtlasChooser.registerIconForBufferedImage(name, bufferedImage);
            }
            catch (IOException e) {
                this.textureAtlasChooser.registerIconForResource(resourceLocation, Minecraft.func_71410_x().func_110442_L());
            }
        }
        this.textureAtlasChooser.stitch();
    }

    @Override
    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    @Override
    public TextureAtlas getTextureAtlasChooser() {
        return this.textureAtlasChooser;
    }

    @Override
    public ArrayList<Waypoint> getWaypoints() {
        return this.wayPts;
    }

    @Override
    public void newWorld(World world) {
        if (world == null) {
            this.currentDimension = 0.5f;
        } else {
            String mapName;
            this.game = Minecraft.func_71410_x();
            if (this.game.func_71387_A()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.equals("")) {
                this.currentDimension = 0.5f;
                this.worldName = mapName;
                this.loadWaypoints();
                this.master.getDimensionManager().populateDimensions();
            }
            int dimensionID = DimensionManager.getDimensionIDfromProvider(world.field_73011_w);
            this.enteredDimension(dimensionID);
            this.master.getDimensionManager().enteredDimension(dimensionID);
        }
    }

    public String getMapName() {
        return this.game.func_71401_C().func_71221_J();
    }

    public String getServerName() {
        String serverName = "";
        try {
            ServerData serverData = this.game.func_147104_D();
            if (serverData != null) {
                boolean isOnLAN = false;
                isOnLAN = serverData.func_181041_d();
                if (isOnLAN) {
                    System.out.println("LAN server detected!");
                    serverName = serverData.field_78847_a;
                } else {
                    serverName = serverData.field_78845_b;
                }
            } else if (!this.latestRealmsID.equals("")) {
                System.out.println("REALMS server detected!");
                serverName = this.latestRealmsID;
            } else {
                NetHandlerPlayClient netHandler = this.game.func_147114_u();
                NetworkManager networkManager = netHandler.func_147298_b();
                InetSocketAddress socketAddress = (InetSocketAddress)networkManager.func_74430_c();
                serverName = socketAddress.getHostString() + ":" + socketAddress.getPort();
            }
        }
        catch (Exception e) {
            System.err.println("error getting ServerData");
            e.printStackTrace();
        }
        return serverName;
    }

    @Override
    public void setConnectedRealm(String id) {
        this.latestRealmsID = id;
    }

    @Override
    public String getCurrentWorldName() {
        return this.worldName;
    }

    @Override
    public void handleDeath() {
        HashSet<Waypoint> toDel = new HashSet<Waypoint>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            int n = this.options.deathpoints;
            this.options.getClass();
            if (n == 2) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.parseInt(pt.name.substring(15));
                    }
                }
                catch (Exception e) {
                    num = 0;
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(pt);
        }
        int n = this.options.deathpoints;
        this.options.getClass();
        if (n != 2 && toDel.size() > 0) {
            for (Waypoint pt : toDel) {
                this.deleteWaypoint(pt);
            }
        }
        int n2 = this.options.deathpoints;
        this.options.getClass();
        if (n2 != 0) {
            EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            dimensions.add(Minecraft.func_71410_x().field_71439_g.field_71093_bK);
            this.addWaypoint(new Waypoint("Latest Death", thePlayer.field_71093_bK != -1 ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, thePlayer.field_71093_bK != -1 ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "Skull", this.getCurrentSubworldDescriptor(false), dimensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enteredDimension(int dimension) {
        this.highlightedWaypoint = null;
        if ((float)dimension == this.currentDimension) {
            this.multiworld = true;
        }
        this.currentDimension = dimension;
        Object object = this.waypointLock;
        synchronized (object) {
            this.waypointContainer = new WaypointContainer(this.options);
            for (Waypoint pt : this.wayPts) {
                pt.inDimension = pt.dimensions.size() == 0 || pt.dimensions.contains(dimension);
                this.waypointContainer.addWaypoint(pt);
            }
            this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
        }
        this.loadBackgroundMapImage();
    }

    @Override
    public void setOldNorth(boolean oldNorth) {
        String oldNorthWorldName = "";
        oldNorthWorldName = this.knownSubworldNames.size() == 0 ? "all" : this.getCurrentSubworldDescriptor(false);
        if (oldNorth) {
            this.oldNorthWorldNames.add(oldNorthWorldName);
        } else {
            this.oldNorthWorldNames.remove(oldNorthWorldName);
        }
        this.saveWaypoints();
    }

    @Override
    public TreeSet<String> getKnownSubworldNames() {
        return this.knownSubworldNames;
    }

    @Override
    public boolean receivedAutoSubworldName() {
        return this.gotAutoSubworldName;
    }

    @Override
    public boolean isMultiworld() {
        return this.multiworld;
    }

    @Override
    public synchronized void setSubworldName(String name, boolean fromServer) {
        boolean notNull;
        boolean bl = notNull = !name.equals("");
        if (notNull || System.currentTimeMillis() - this.lastNewWorldNameTime > 2000L) {
            if (notNull) {
                if (fromServer) {
                    this.gotAutoSubworldName = true;
                }
                if (!name.equals(this.currentSubWorldName)) {
                    System.out.println("New world name: " + TextUtils.scrubCodes(name));
                }
                this.lastNewWorldNameTime = System.currentTimeMillis();
            }
            this.currentSubWorldName = name;
            this.setSubWorldDescriptor(this.currentSubWorldName);
        }
    }

    @Override
    public synchronized void setSubworldHash(String hash) {
        this.currentSubWorldHash = hash;
        if (this.currentSubWorldName.equals("")) {
            this.setSubWorldDescriptor(this.currentSubWorldHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubWorldDescriptor(String descriptor) {
        boolean serverSaysOldNorth = false;
        if (descriptor.endsWith("\u00a7o\u00a7n")) {
            descriptor = descriptor.substring(0, descriptor.length() - 4);
            serverSaysOldNorth = true;
        }
        this.currentSubworldDescriptor = descriptor;
        this.currentSubworldDescriptorNoCodes = TextUtils.scrubCodes(this.currentSubworldDescriptor);
        this.newSubworldName(this.currentSubworldDescriptorNoCodes);
        String currentSubWorldDescriptorScrubbed = TextUtils.scrubName(this.currentSubworldDescriptorNoCodes);
        Object object = this.waypointLock;
        synchronized (object) {
            for (Waypoint pt : this.wayPts) {
                if (currentSubWorldDescriptorScrubbed == "" || pt.world == "" || currentSubWorldDescriptorScrubbed.equals(pt.world)) {
                    pt.inWorld = true;
                    continue;
                }
                pt.inWorld = false;
            }
        }
        if (serverSaysOldNorth) {
            if (this.currentSubworldDescriptorNoCodes.equals("")) {
                this.oldNorthWorldNames.add("all");
            } else {
                this.oldNorthWorldNames.add(this.currentSubworldDescriptorNoCodes);
            }
        }
        this.master.getMapOptions().oldNorth = this.oldNorthWorldNames.contains(this.currentSubworldDescriptorNoCodes);
    }

    private void newSubworldName(String name) {
        if (name != null && !name.equals("")) {
            this.multiworld = true;
            if (this.knownSubworldNames.add(name)) {
                if (this.loaded) {
                    this.saveWaypoints();
                } else {
                    this.needSave = true;
                }
            }
        }
        this.loadBackgroundMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSubworldName(String oldName, String newName) {
        if (!newName.equals(oldName) && this.knownSubworldNames.remove(oldName)) {
            this.knownSubworldNames.add(newName);
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(oldName)) continue;
                    pt.world = newName;
                }
            }
            this.master.getPersistentMap().renameSubworld(oldName, newName);
            String worldName = this.getCurrentWorldName();
            String worldNamePathPart = TextUtils.scrubNameFile(worldName);
            String subWorldNamePathPart = TextUtils.scrubNameFile(oldName) + "/";
            File oldCachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/VoxelMods/voxelMap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
            if (oldCachedRegionFileDir.exists() && oldCachedRegionFileDir.isDirectory()) {
                subWorldNamePathPart = TextUtils.scrubNameFile(newName) + "/";
                File newCachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/VoxelMods/voxelMap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
                boolean success = oldCachedRegionFileDir.renameTo(newCachedRegionFileDir);
                if (!success) {
                    System.out.println("Failed renaming " + oldCachedRegionFileDir.getPath() + " to " + newCachedRegionFileDir.getPath());
                }
            }
            if (oldName.equals(this.getCurrentSubworldDescriptor(false))) {
                this.setSubworldName(newName, false);
            }
            this.saveWaypoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubworld(String name) {
        if (this.knownSubworldNames.remove(name)) {
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(name)) continue;
                    pt.world = "";
                    pt.inWorld = true;
                }
            }
            this.saveWaypoints();
            this.lastNewWorldNameTime = 0L;
            this.setSubworldName("", false);
        }
    }

    @Override
    public String getCurrentSubworldDescriptor(boolean withCodes) {
        return withCodes ? this.currentSubworldDescriptor : this.currentSubworldDescriptorNoCodes;
    }

    @Override
    public String getWorldSeed() {
        String seed;
        String key = "all";
        if (this.knownSubworldNames.size() > 0) {
            key = this.getCurrentSubworldDescriptor(false);
        }
        if ((seed = this.worldSeeds.get(key)) == null) {
            seed = "";
        }
        return seed;
    }

    @Override
    public void setWorldSeed(String newSeed) {
        System.out.println("waypoint manager gets new world seed: " + newSeed);
        String worldName = "all";
        if (this.knownSubworldNames.size() > 0) {
            worldName = this.getCurrentSubworldDescriptor(false);
        }
        this.worldSeeds.put(worldName, newSeed);
        this.saveWaypoints();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveWaypoints() {
        int portSepLoc;
        String worldNameSave = this.getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(":")) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = TextUtils.scrubNameFile(worldNameSave);
        File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        this.settingsFile = new File(saveDir, worldNameSave + ".points");
        try {
            void var6_11;
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), StandardCharsets.UTF_8));
            String knownSubworldsString = "";
            for (String string : this.knownSubworldNames) {
                knownSubworldsString = knownSubworldsString + TextUtils.scrubName(string) + ",";
            }
            out.println("subworlds:" + knownSubworldsString);
            String oldNorthWorldsString = "";
            for (String oldNorthWorldName : this.oldNorthWorldNames) {
                oldNorthWorldsString = oldNorthWorldsString + TextUtils.scrubName(oldNorthWorldName) + ",";
            }
            out.println("oldNorthWorlds:" + oldNorthWorldsString);
            String string = "";
            for (Map.Entry<String, String> entry : this.worldSeeds.entrySet()) {
                String string2 = (String)var6_11 + TextUtils.scrubName(entry.getKey()) + "#" + entry.getValue() + ",";
            }
            out.println("seeds:" + (String)var6_11);
            for (Waypoint pt : this.wayPts) {
                if (pt.name.startsWith("^")) continue;
                String dimensionsString = "";
                for (Integer dimension : pt.dimensions) {
                    dimensionsString = dimensionsString + "" + dimension + "#";
                }
                if (dimensionsString.equals("")) {
                    dimensionsString = "-1#0#";
                }
                out.println("name:" + TextUtils.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + Boolean.toString(pt.enabled) + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + TextUtils.scrubName(pt.world) + ",dimensions:" + dimensionsString);
            }
            out.close();
        }
        catch (Exception local) {
            MessageUtils.chatInfo("\u00a7EError Saving Waypoints");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWaypoints() {
        this.loaded = false;
        this.multiworld = false;
        this.gotAutoSubworldName = false;
        this.currentDimension = 0.5f;
        this.knownSubworldNames.clear();
        this.oldNorthWorldNames.clear();
        this.worldSeeds.clear();
        Object object = this.waypointLock;
        synchronized (object) {
            int portSepLoc;
            boolean loaded = false;
            this.wayPts = new ArrayList();
            String worldNameStandard = this.getCurrentWorldName();
            if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(":")) != -1) {
                worldNameStandard = worldNameStandard.substring(0, portSepLoc);
            }
            worldNameStandard = TextUtils.scrubNameFile(worldNameStandard);
            String worldNameWithPort = TextUtils.scrubNameFile(this.getCurrentWorldName());
            String worldNameWithoutPort = this.getCurrentWorldName();
            int portSepLoc2 = worldNameWithoutPort.lastIndexOf(":");
            if (portSepLoc2 != -1) {
                worldNameWithoutPort = worldNameWithoutPort.substring(0, portSepLoc2);
            }
            worldNameWithoutPort = TextUtils.scrubNameFile(worldNameWithoutPort);
            String worldNameWithDefaultPort = TextUtils.scrubNameFile(worldNameWithoutPort + "~colon~25565");
            loaded = this.loadWaypointsExtensible(worldNameStandard);
            if (!loaded) {
                loaded = this.loadOldWaypoints(worldNameWithoutPort, worldNameWithDefaultPort, worldNameWithPort);
            }
            if (!loaded) {
                loaded = this.findReiWaypoints(worldNameWithoutPort);
            }
            if (!loaded) {
                MessageUtils.chatInfo("\u00a7ENo waypoints exist for this world/server.");
            } else {
                this.populateOld2dWaypoints();
            }
        }
        this.setSubWorldDescriptor(this.getCurrentSubworldDescriptor(true));
        this.loaded = true;
        if (this.needSave) {
            this.needSave = false;
            this.saveWaypoints();
        }
        this.multiworld = this.multiworld || this.knownSubworldNames.size() > 0;
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File settingsFileNew = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/" + worldNameStandard + ".points");
        File settingsFileOld = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/" + worldNameStandard + ".points");
        if (!settingsFileOld.exists() && !settingsFileNew.exists()) {
            return false;
        }
        this.settingsFile = !settingsFileOld.exists() ? settingsFileNew : (!settingsFileNew.exists() ? settingsFileOld : settingsFileNew);
        if (this.settingsFile.exists()) {
            try {
                Properties properties = new Properties();
                FileReader fr = new FileReader(this.settingsFile);
                properties.load(fr);
                String subWorldsS = properties.getProperty("subworlds", "");
                String[] subWorlds = subWorldsS.split(",");
                for (int t = 0; t < subWorlds.length; ++t) {
                    if (subWorlds[t].equals("")) continue;
                    this.knownSubworldNames.add(TextUtils.descrubName(subWorlds[t]));
                }
                String oldNorthWorldsS = properties.getProperty("oldNorthWorlds", "");
                String[] oldNorthWorlds = oldNorthWorldsS.split(",");
                for (int t = 0; t < oldNorthWorlds.length; ++t) {
                    if (oldNorthWorlds[t].equals("")) continue;
                    this.oldNorthWorldNames.add(TextUtils.descrubName(oldNorthWorlds[t]));
                }
                String worldSeedsS = properties.getProperty("seeds", "");
                String[] worldSeedPairs = worldSeedsS.split(",");
                for (int t = 0; t < worldSeedPairs.length; ++t) {
                    String pair = worldSeedPairs[t];
                    String[] worldSeedPair = pair.split("#");
                    if (worldSeedPair.length != 2) continue;
                    this.worldSeeds.put(worldSeedPair[0], worldSeedPair[1]);
                }
                fr.close();
            }
            catch (IOException properties) {
                // empty catch block
            }
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), StandardCharsets.UTF_8));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] pairs = sCurrentLine.split(",");
                    if (pairs.length <= 1) continue;
                    String name = "";
                    int x = 0;
                    int z = 0;
                    int y = -1;
                    boolean enabled = false;
                    float red = 0.5f;
                    float green = 0.0f;
                    float blue = 0.0f;
                    String suffix = "";
                    String world = "";
                    TreeSet<Integer> dimensions = new TreeSet<Integer>();
                    for (int t = 0; t < pairs.length; ++t) {
                        int splitIndex = pairs[t].indexOf(":");
                        if (splitIndex == -1) continue;
                        String key = pairs[t].substring(0, splitIndex).toLowerCase().trim();
                        String value = pairs[t].substring(splitIndex + 1).trim();
                        if (key.equals("name")) {
                            name = TextUtils.descrubName(value);
                            continue;
                        }
                        if (key.equals("x")) {
                            x = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("z")) {
                            z = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("y")) {
                            y = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("enabled")) {
                            enabled = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals("red")) {
                            red = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("green")) {
                            green = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("blue")) {
                            blue = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("suffix")) {
                            suffix = value;
                            continue;
                        }
                        if (key.equals("world")) {
                            world = TextUtils.descrubName(value);
                            continue;
                        }
                        if (!key.equals("dimensions")) continue;
                        String[] dimensionStrings = value.split("#");
                        for (int s = 0; s < dimensionStrings.length; ++s) {
                            dimensions.add(Integer.parseInt(dimensionStrings[s]));
                        }
                        if (dimensions.size() != 0) continue;
                        dimensions.add(0);
                        dimensions.add(-1);
                    }
                    if (name.equals("")) continue;
                    this.loadWaypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
                    if (world.equals("")) continue;
                    this.knownSubworldNames.add(TextUtils.descrubName(world));
                }
                in.close();
            }
            catch (Exception local) {
                MessageUtils.chatInfo("\u00a7EError Loading Waypoints");
                System.err.println("waypoint load error: " + local.getLocalizedMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean loadOldWaypoints(String worldNameWithoutPort, String worldNameWithDefaultPort, String worldNameWithPort) {
        try {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithPort + ".points");
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithDefaultPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithoutPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft", false), worldNameWithoutPort + ".points");
            }
            if (this.settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(-1);
                dimensions.add(0);
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length == 4) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), 0.0f, 1.0f, 0.0f, "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 7) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 8) {
                        if (curLine[3].contains("true") || curLine[3].contains("false")) {
                            this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), curLine[7], "", dimensions);
                            continue;
                        }
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length != 9) continue;
                    this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), curLine[8], "", dimensions);
                }
                in.close();
                return true;
            }
            return false;
        }
        catch (Exception local) {
            MessageUtils.chatInfo("\u00a7EError Loading Waypoints");
            System.err.println("waypoint load error: " + local.getLocalizedMessage());
            return false;
        }
    }

    private boolean findReiWaypoints(String worldNameWithoutPort) {
        boolean foundSome = false;
        this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap", false), worldNameWithoutPort + ".points");
        if (!this.settingsFile.exists()) {
            this.settingsFile = new File(Minecraft.func_71410_x().field_71412_D, "/mods/rei_minimap/" + worldNameWithoutPort + ".points");
        }
        if (this.settingsFile.exists()) {
            this.loadReiWaypoints(this.settingsFile, 0);
            foundSome = true;
        } else {
            for (int t = -25; t < 25; ++t) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap", false), worldNameWithoutPort + ".DIM" + t + ".points");
                if (!this.settingsFile.exists()) {
                    this.settingsFile = new File(Minecraft.func_71410_x().field_71412_D, "/mods/rei_minimap/" + worldNameWithoutPort + ".DIM" + t + ".points");
                }
                if (!this.settingsFile.exists()) continue;
                foundSome = true;
                this.loadReiWaypoints(this.settingsFile, t);
            }
        }
        return foundSome;
    }

    private void loadReiWaypoints(File settingsFile, int dimension) {
        try {
            if (settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(dimension);
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length != 6) continue;
                    int color = Integer.parseInt(curLine[5], 16);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color >> 0 & 0xFF) / 255.0f;
                    int x = Integer.parseInt(curLine[1]);
                    int z = Integer.parseInt(curLine[3]);
                    if (dimension == -1) {
                        x *= 8;
                        z *= 8;
                    }
                    this.loadWaypoint(curLine[0], x, z, Integer.parseInt(curLine[2]), Boolean.parseBoolean(curLine[4]), red, green, blue, "", "", dimensions);
                }
                in.close();
            }
        }
        catch (Exception e) {
            MessageUtils.chatInfo("\u00a7EError Loading Old Rei Waypoints");
            System.err.println("waypoint load error: " + e.getLocalizedMessage());
        }
    }

    private void loadWaypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<Integer> dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
        if (!this.wayPts.contains(newWaypoint)) {
            this.wayPts.add(newWaypoint);
        }
    }

    private void populateOld2dWaypoints() {
        this.old2dWayPts = new ArrayList();
        for (Waypoint wpt : this.wayPts) {
            if (wpt.getY() > 0) continue;
            this.old2dWayPts.add(wpt);
        }
    }

    @Override
    public void check2dWaypoints() {
        if (Minecraft.func_71410_x().field_71439_g.field_71093_bK == 0 && this.old2dWayPts.size() > 0) {
            this.updatedPts = new ArrayList();
            for (Waypoint pt : this.old2dWayPts) {
                BlockPos blockPos = new BlockPos(pt.getX(), 0, pt.getZ());
                Chunk chunk = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175726_f(blockPos);
                if (Math.abs(pt.getX() - GameVariableAccessShim.xCoord()) >= 400 || Math.abs(pt.getZ() - GameVariableAccessShim.zCoord()) >= 400 || !chunk.func_177410_o()) continue;
                pt.setY(chunk.func_177433_f(blockPos));
                this.updatedPts.add(pt);
                this.saveWaypoints();
            }
            this.old2dWayPts.removeAll(this.updatedPts);
            System.out.println("remaining old 2d waypoints: " + this.old2dWayPts.size());
        }
    }

    @Override
    public void deleteWaypoint(Waypoint point) {
        this.old2dWayPts.remove(point);
        this.waypointContainer.removeWaypoint(point);
        this.wayPts.remove(point);
        this.saveWaypoints();
        if (point == this.highlightedWaypoint) {
            this.setHighlightedWaypoint(null, false);
        }
    }

    @Override
    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.waypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
        if (this.highlightedWaypoint != null && this.highlightedWaypoint.getX() == newWaypoint.getX() && this.highlightedWaypoint.getZ() == newWaypoint.getZ()) {
            this.setHighlightedWaypoint(newWaypoint, false);
        }
    }

    @Override
    public void setHighlightedWaypoint(Waypoint waypoint, boolean toggle) {
        if (toggle && waypoint == this.highlightedWaypoint) {
            this.highlightedWaypoint = null;
        } else {
            if (waypoint != null && !this.wayPts.contains(waypoint)) {
                waypoint.red = 2.0f;
                waypoint.blue = 0.0f;
                waypoint.green = 0.0f;
            }
            this.highlightedWaypoint = waypoint;
        }
        this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
    }

    @Override
    public Waypoint getHighlightedWaypoint() {
        return this.highlightedWaypoint;
    }

    @Override
    public void renderWaypoints(float partialTicks) {
        if (this.waypointContainer != null) {
            this.waypointContainer.renderWaypoints(partialTicks);
        }
    }

    private void loadBackgroundMapImage() {
        if (this.backgroundImageInfo != null) {
            GLUtils.glah(this.backgroundImageInfo.glid);
            this.backgroundImageInfo = null;
        }
        try {
            String path = this.getCurrentWorldName();
            String subworldDescriptor = this.getCurrentSubworldDescriptor(false);
            if (subworldDescriptor != null && !subworldDescriptor.equals("")) {
                path = path + "/" + subworldDescriptor;
            }
            path = path + "/" + (int)this.currentDimension;
            InputStream is = this.game.func_110442_L().func_110536_a(new ResourceLocation("voxelmap", "images/backgroundmaps/" + path + "/map.png")).func_110527_b();
            BufferedImage image = ImageIO.read(is);
            is.close();
            BufferedImage mapImage = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)image, 0, 0, null);
            gfx.dispose();
            is = this.game.func_110442_L().func_110536_a(new ResourceLocation("voxelmap", "images/backgroundmaps/" + path + "/map.txt")).func_110527_b();
            InputStreamReader isr = new InputStreamReader(is);
            Properties mapProperties = new Properties();
            mapProperties.load(isr);
            String left = mapProperties.getProperty("left");
            String right = mapProperties.getProperty("right");
            String top = mapProperties.getProperty("top");
            String bottom = mapProperties.getProperty("bottom");
            String width = mapProperties.getProperty("width");
            String height = mapProperties.getProperty("height");
            String scale = mapProperties.getProperty("scale");
            if (left != null && top != null && width != null && height != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Integer.parseInt(width), Integer.parseInt(height));
            } else if (left != null && top != null && scale != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Float.parseFloat(scale));
            } else if (left != null && top != null && right != null && bottom != null) {
                int widthInt = Integer.parseInt(right) - Integer.parseInt(left);
                int heightInt = Integer.parseInt(right) - Integer.parseInt(left);
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), widthInt, heightInt);
            }
            isr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public BackgroundImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }
}

