/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.textures.FontRendererWithAtlas;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBat;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBlaze;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.model.ModelGuardian;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelIllager;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelPig;
import net.minecraft.client.model.ModelPolarBear;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRabbit;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.model.ModelSilverfish;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.src.VoxelMapProtectedFieldsHelper;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class Radar
implements IRadar {
    private Minecraft game;
    private IVoxelMap master = null;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    private FontRendererWithAtlas fontRenderer;
    private TextureAtlas textureAtlas;
    private boolean newMobs = false;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    public HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    public HashMap<String, Integer> contactsSkinGetTries = new HashMap();
    private BufferedImage[][] mobImages = new BufferedImage[EnumMobs.values().length - 3][2];
    private boolean[] builtInCustom = new boolean[EnumMobs.values().length];
    private Sprite[] clothIcons = new Sprite[]{null, null};
    public static final int CLOTH = 0;
    public static final int CHAIN = 4;
    public static final int IRON = 5;
    public static final int GOLD = 6;
    public static final int DIAMOND = 7;
    public static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    public static final int CUSTOM = EnumMobs.CUSTOM.ordinal();
    private BufferedImage[][] armorImages = new BufferedImage[8][2];
    private String[] armorNames = new String[]{"cloth", "clothOverlay", "clothOuter", "clothOverlayOuter", "chain", "iron", "gold", "diamond"};
    private boolean randomobsOptifine = false;
    private Class<?> randomMobsClass = null;
    private Class<?> randomMobsPropertiesClass = null;
    private Method getRandomobPropertiesMethod = null;
    private Method getMobTextureMethod = null;
    private boolean randomobsOptifineNew = false;
    private Class<?> randomEntitiesClass = null;
    private Field mapPropertiesField = null;
    private Map<String, ?> mapProperties = null;
    private Field randomEntityField = null;
    private Object randomEntity = null;
    private Class<?> iRandomEntityClass = null;
    private Class<?> randomEntityClass = null;
    private Method setEntityMethod = null;
    private Class<?> randomEntitiesPropertiesClass = null;
    private Method getEntityTextureMethod = null;
    private boolean hasCustomNPCs = false;
    private Class<?> entityCustomNpcClass = null;
    private Class<?> modelDataClass = null;
    private Class<?> entityNPCInterfaceClass = null;
    private Field modelDataField = null;
    private Method getEntityMethod = null;
    private Class<?> modelScaleRendererClass = null;
    private boolean lastOutlines = true;
    UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");

    public Radar(IVoxelMap master) {
        Class[] argClasses2;
        Class[] argClasses1;
        this.master = master;
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = Minecraft.func_71410_x();
        this.fontRenderer = new FontRendererWithAtlas(this.game.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.game.func_110434_K(), false);
        this.textureAtlas = new TextureAtlas("mobs");
        this.textureAtlas.func_174937_a(false, false);
        try {
            this.randomMobsClass = Class.forName("RandomMobs");
            this.randomMobsPropertiesClass = Class.forName("RandomMobsProperties");
            argClasses1 = new Class[]{ResourceLocation.class};
            this.getRandomobPropertiesMethod = this.randomMobsClass.getDeclaredMethod("getProperties", argClasses1);
            this.getRandomobPropertiesMethod.setAccessible(true);
            argClasses2 = new Class[]{ResourceLocation.class, EntityLiving.class};
            this.getMobTextureMethod = this.randomMobsPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
            this.randomobsOptifine = true;
        }
        catch (ClassNotFoundException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchMethodException e) {
            this.randomobsOptifine = false;
        }
        if (!this.randomobsOptifine) {
            try {
                this.randomMobsClass = Class.forName("optifine.RandomMobs");
                this.randomMobsPropertiesClass = Class.forName("optifine.RandomMobsProperties");
                argClasses1 = new Class[]{ResourceLocation.class};
                this.getRandomobPropertiesMethod = this.randomMobsClass.getDeclaredMethod("getProperties", argClasses1);
                this.getRandomobPropertiesMethod.setAccessible(true);
                argClasses2 = new Class[]{ResourceLocation.class, EntityLiving.class};
                this.getMobTextureMethod = this.randomMobsPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
                this.randomobsOptifine = true;
            }
            catch (ClassNotFoundException e) {
                this.randomobsOptifine = false;
            }
            catch (NoSuchMethodException e) {
                this.randomobsOptifine = false;
            }
        }
        if (!this.randomobsOptifine) {
            try {
                this.randomEntitiesClass = Class.forName("RandomEntities");
                this.mapPropertiesField = this.randomEntitiesClass.getDeclaredField("mapProperties");
                this.mapPropertiesField.setAccessible(true);
                this.mapProperties = (Map)this.mapPropertiesField.get(null);
                this.randomEntityField = this.randomEntitiesClass.getDeclaredField("randomEntity");
                this.randomEntityField.setAccessible(true);
                this.randomEntity = this.randomEntityField.get(null);
                this.iRandomEntityClass = Class.forName("IRandomEntity");
                this.randomEntityClass = Class.forName("RandomEntity");
                argClasses1 = new Class[]{Entity.class};
                this.setEntityMethod = this.randomEntityClass.getDeclaredMethod("setEntity", argClasses1);
                this.randomEntitiesPropertiesClass = Class.forName("RandomEntityProperties");
                argClasses2 = new Class[]{ResourceLocation.class, this.iRandomEntityClass};
                this.getEntityTextureMethod = this.randomEntitiesPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
                this.randomobsOptifineNew = true;
            }
            catch (ClassNotFoundException e) {
                this.randomobsOptifineNew = false;
            }
            catch (NoSuchMethodException e) {
                this.randomobsOptifineNew = false;
            }
            catch (NoSuchFieldException e) {
                this.randomobsOptifineNew = false;
            }
            catch (SecurityException e) {
                this.randomobsOptifineNew = false;
            }
            catch (IllegalArgumentException e) {
                this.randomobsOptifineNew = false;
            }
            catch (IllegalAccessException e) {
                this.randomobsOptifineNew = false;
            }
        }
        try {
            this.entityCustomNpcClass = Class.forName("noppes.npcs.entity.EntityCustomNpc");
            this.modelDataClass = Class.forName("noppes.npcs.ModelData");
            this.modelDataField = this.entityCustomNpcClass.getField("modelData");
            this.entityNPCInterfaceClass = Class.forName("noppes.npcs.entity.EntityNPCInterface");
            this.getEntityMethod = this.modelDataClass.getMethod("getEntity", this.entityNPCInterfaceClass);
            this.modelScaleRendererClass = Class.forName("noppes.npcs.client.model.ModelScaleRenderer");
            this.hasCustomNPCs = true;
        }
        catch (ClassNotFoundException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchFieldException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchMethodException e) {
            this.hasCustomNPCs = false;
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.loadTexturePackIcons();
        this.fontRenderer.func_110549_a(resourceManager);
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            int t;
            this.mpContactsSkinGetTries.clear();
            this.contactsSkinGetTries.clear();
            this.textureAtlas.reset();
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png") : new ResourceLocation("textures/blocks/mushroom_red.png");
            Arrays.fill(this.builtInCustom, false);
            for (t = 0; t < this.mobImages.length; ++t) {
                try {
                    int intendedSize = 8;
                    String fullPath = "";
                    InputStream is = null;
                    if (is == null) {
                        fullPath = "textures/icons/" + EnumMobs.values()[t].classPath + ".png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + EnumMobs.values()[t].classPath + "8.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 16;
                        fullPath = "textures/icons/" + EnumMobs.values()[t].classPath + "16.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 32;
                        fullPath = "textures/icons/" + EnumMobs.values()[t].classPath + "32.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is != null) {
                        BufferedImage mobSkin = ImageIO.read(is);
                        is.close();
                        mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                        float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                        this.mobImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 1.0f / scale)), this.options.outlines);
                        this.mobImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 2.0f / scale)), this.options.outlines);
                        this.builtInCustom[t] = true;
                    }
                }
                catch (Exception intendedSize) {
                    // empty catch block
                }
                if (this.mobImages[t][0] == null || this.mobImages[t][1] == null) {
                    BufferedImage image = null;
                    image = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation);
                    if (image == null) {
                        System.err.println("Failed getting mob " + t);
                        image = new BufferedImage(2, 2, 6);
                    }
                    float scale = (float)image.getWidth() / (float)EnumMobs.values()[t].expectedWidth;
                    this.mobImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
                    this.mobImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
                }
                String nameWithoutSize = EnumMobs.values()[t].id + EnumMobs.values()[t].resourceLocation.toString();
                nameWithoutSize = nameWithoutSize + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "");
                this.textureAtlas.registerIconForBufferedImage(nameWithoutSize + "1", this.mobImages[t][1]);
                this.textureAtlas.registerIconForBufferedImage(nameWithoutSize + "0", this.mobImages[t][0]);
            }
            this.armorImages[0][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8);
            this.armorImages[1][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8);
            this.armorImages[2][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8);
            this.armorImages[3][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8);
            this.armorImages[4][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[5][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[6][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[7][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            for (t = 0; t < this.armorImages.length; ++t) {
                float scale = (float)this.armorImages[t][0].getWidth() / 8.0f;
                this.armorImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(this.armorImages[t][0], 2.0f / scale)), this.options.outlines, true, 16, t);
                this.armorImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(this.armorImages[t][0], 1.0f / scale)), this.options.outlines, true, 8, t);
                Sprite icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t] + " 1", this.armorImages[t][1]);
                Sprite icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t] + " 0", this.armorImages[t][0]);
                if (t != 0) continue;
                this.clothIcons = new Sprite[]{icon0, icon1};
            }
            BufferedImage sheepFur = ImageUtils.loadImage(new ResourceLocation("textures/entity/sheep/sheep_fur.png"), 6, 6, 6, 6);
            float scale = (float)sheepFur.getWidth() / 6.0f;
            BufferedImage sheepFur1 = ImageUtils.scaleImage(sheepFur, 4.0f / scale * 1.0625f);
            sheepFur1 = ImageUtils.eraseArea(sheepFur1, 2, 2, sheepFur1.getWidth() - 4, sheepFur1.getHeight() - 4, sheepFur1.getWidth(), sheepFur1.getHeight());
            sheepFur1 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur1), this.options.outlines, true, 25, -10);
            sheepFur1 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur1), this.options.outlines, true, 27, -10);
            BufferedImage sheepFur0 = ImageUtils.scaleImage(sheepFur, 2.0f / scale * 1.0625f);
            sheepFur0 = ImageUtils.eraseArea(sheepFur0, 1, 1, sheepFur0.getWidth() - 2, sheepFur0.getHeight() - 2, sheepFur0.getWidth(), sheepFur0.getHeight());
            sheepFur0 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur0), this.options.outlines, true, 13, -10);
            sheepFur0 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur0), this.options.outlines, true, 11, -10);
            this.textureAtlas.registerIconForBufferedImage("sheepfur1", sheepFur1);
            this.textureAtlas.registerIconForBufferedImage("sheepfur0", sheepFur0);
            BufferedImage crown = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/crown.png"), 0, 0, 16, 16, 16, 16);
            BufferedImage crown1 = ImageUtils.fillOutline(crown, this.options.outlines, true, 16, -10);
            BufferedImage crown0 = ImageUtils.fillOutline(ImageUtils.scaleImage(crown, 0.5f), this.options.outlines, true, 8, -10);
            this.textureAtlas.registerIconForBufferedImage("crown1", crown1);
            this.textureAtlas.registerIconForBufferedImage("crown0", crown0);
            BufferedImage glow = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/glow.png"), 0, 0, 16, 16, 16, 16);
            glow = ImageUtils.fillOutline(glow, this.options.outlines, true, 16, -10);
            this.textureAtlas.registerIconForBufferedImage("glow", glow);
            ResourceLocation fontResourceLocation = new ResourceLocation("textures/font/ascii.png");
            BufferedImage fontImage = ImageUtils.loadImage(fontResourceLocation, 0, 0, 128, 128, 128, 128);
            if (fontImage.getWidth() > 1024 || fontImage.getHeight() > 1024) {
                int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
                float scaleBy = 1024.0f / (float)maxDim;
                fontImage = ImageUtils.scaleImage(fontImage, scaleBy);
            }
            fontImage = ImageUtils.addImages(new BufferedImage(fontImage.getWidth() + 2, fontImage.getHeight() + 2, fontImage.getType()), fontImage, 1.0f, 1.0f, fontImage.getWidth() + 2, fontImage.getHeight() + 2);
            Sprite fontSprite = this.textureAtlas.registerIconForBufferedImage(fontResourceLocation.toString(), fontImage);
            this.fontRenderer.setFontSprite(fontSprite);
            this.fontRenderer.setFontRef(this.textureAtlas.func_110552_b());
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary) {
        BufferedImage mobImage = null;
        BufferedImage mobImageSecondary = null;
        try {
            mobImage = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
            if (resourceLocationSecondary != null) {
                mobImageSecondary = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
            }
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary) {
        BufferedImage image = null;
        switch (type) {
            case BLANK: {
                image = ImageUtils.blankImage(mobImage, 2, 2);
                break;
            }
            case GENERICHOSTILE: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/hostile.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICNEUTRAL: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/neutral.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICTAME: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/tame.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0.0f, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0.0f, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3.0f, 8, 12);
                break;
            }
            case BLAZE: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case CAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0.0f, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0.0f, 5, 5);
                break;
            }
            case CAVESPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2.0f, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4.0f, 6, 6);
                break;
            }
            case COW: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 1.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 0.0f, 0.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 9.0f, 0.0f, 10, 10);
                break;
            }
            case CREEPER: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16.0f, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0.0f, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0.0f, 16, 16);
                break;
            }
            case ENDERMAN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 8, 24, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 12, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case ENDERMITE: {
                image = ImageUtils.loadImage(mobImage, 2, 2, 4, 3);
                break;
            }
            case EVOKER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case GHAST: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GUARDIAN: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case GUARDIANELDER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 128, 128), ImageUtils.loadImage(mobImage, 58, 4, 4, 15, 128, 128), 0.0f, 5.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 8, 13, 128, 128), 3.0f, 9.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 7, 7, 5, 128, 128), 3.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 24, 24, 6, 3, 128, 128), 10.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 24, 32, 5, 2, 128, 128), 10.0f, 10.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 1, 1, 3, 128, 128), 4.0f, 4.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 128, 128), 4.0f, 0.0f, 16, 24);
                break;
            }
            case ILLUSIONER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8.0f, 8, 12);
                break;
            }
            case LLAMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3.0f, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15.0f, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                image = ImageUtils.addImages(image, mushroomImage, 12.0f, 0.0f, 40, 40);
                break;
            }
            case OCELOT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0.0f, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0.0f, 5, 5);
                break;
            }
            case PARROT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8, 32, 32), ImageUtils.loadImage(mobImage, 2, 22, 3, 5, 32, 32), 1.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 10, 4, 4, 1, 32, 32), 2.0f, 4.0f, 8, 8), ImageUtils.loadImage(mobImage, 2, 4, 2, 3, 32, 32), 2.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 11, 8, 1, 2, 32, 32), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 16, 8, 1, 2, 32, 32), 5.0f, 5.0f, 8, 8);
                break;
            }
            case PIG: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 16, 17, 6, 3), 1.0f, 4.0f, 8, 8);
                break;
            }
            case PIGZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case PLAYER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case POLARBEAR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 9, 8, 128, 64), ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64), 0.0f, 0.0f, 9, 8), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64)), 7.0f, 0.0f, 9, 8), ImageUtils.loadImage(mobImage, 7, 7, 7, 7, 128, 64), 1.0f, 1.0f, 9, 8), ImageUtils.loadImage(mobImage, 3, 47, 5, 3, 128, 64), 2.0f, 5.0f, 9, 8);
                break;
            }
            case RABBIT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 10), ImageUtils.loadImage(mobImage, 37, 5, 5, 4), 0.0f, 5.0f, 5, 10), ImageUtils.loadImage(mobImage, 33, 10, 1, 1), 2.0f, 7.5f, 5, 10), ImageUtils.loadImage(mobImage, 53, 1, 2, 5), 0.0f, 0.0f, 5, 10), ImageUtils.loadImage(mobImage, 59, 1, 2, 5), 3.0f, 0.0f, 5, 10);
                break;
            }
            case SHEEP: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 6, 6);
                break;
            }
            case SHULKER: {
                image = ImageUtils.loadImage(mobImage, 6, 58, 6, 6);
                break;
            }
            case SILVERFISH: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 22, 20, 6, 6), ImageUtils.loadImage(mobImage, 2, 2, 3, 2), 2.0f, 2.0f, 6, 6);
                break;
            }
            case SKELETON: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SKELETONWITHER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SNOWGOLEM: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case SPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SQUID: {
                image = ImageUtils.scaleImage(ImageUtils.loadImage(mobImage, 12, 12, 12, 16), 0.5f);
                break;
            }
            case VEX: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VEXCHARGING: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case VINDICATOR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case WITCH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 16, 64, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 128), 1.0f, 5.0f, 10, 16), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 128), 4.0f, 12.0f, 10, 16), ImageUtils.loadImage(mobImage, 10, 74, 10, 3, 64, 128), 0.0f, 4.0f, 10, 16), ImageUtils.loadImage(mobImage, 7, 83, 7, 4, 64, 128), 1.5f, 0.0f, 10, 16), ImageUtils.loadImage(mobImage, 1, 1, 1, 1, 64, 128), 5.0f, 14.0f, 10, 16);
                break;
            }
            case WITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WOLF: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case WOLFANGRY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case WOLFTAME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case ZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ZOMBIEVILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            default: {
                throw new IllegalArgumentException("New mob type: " + type.id + ". Need to construct icon for it!");
            }
        }
        return image;
    }

    @Override
    public void OnTickInGame(Minecraft mc, LayoutVariables layoutVariables) {
        int guiScale;
        if (!(this.options.radarAllowed.booleanValue() || this.options.radarMobsAllowed.booleanValue() || this.options.radarPlayersAllowed.booleanValue())) {
            return;
        }
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.options.isChanged()) {
            this.timer = 500;
            if (this.options.outlines != this.lastOutlines) {
                this.lastOutlines = this.options.outlines;
                this.loadTexturePackIcons();
            }
        }
        guiScale = (guiScale = layoutVariables.scScale) >= 4 ? 1 : 0;
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled && this.options.showRadar) {
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY, guiScale);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.func_78256_a(paramStr);
    }

    private void write(String paramStr, float x, float y, int color) {
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
        this.fontRenderer.func_175063_a(paramStr, x, y, color);
    }

    private boolean isEntityShown(Entity entity) {
        return entity != null && !entity.func_98034_c((EntityPlayer)this.game.field_71439_g) && (this.options.showHostiles && (this.options.radarAllowed != false || this.options.radarMobsAllowed != false) && this.isHostile(entity) || this.options.showPlayers && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false) && this.isPlayer(entity) || this.options.showNeutrals && this.options.radarMobsAllowed != false && this.isNeutral(entity));
    }

    public void calculateMobs() {
        this.contacts.clear();
        List entities = this.game.field_71441_e.func_72910_y();
        for (int j = 0; j < entities.size(); ++j) {
            try {
                String scrubbedName;
                Entity entity = (Entity)entities.get(j);
                if (!this.isEntityShown(entity)) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.field_70165_t;
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.field_70161_v;
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.field_70163_u;
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                if (this.hasCustomNPCs) {
                    try {
                        Object modelData;
                        EntityLivingBase wrappedEntity;
                        if (this.entityCustomNpcClass.isInstance(entity) && (wrappedEntity = (EntityLivingBase)this.getEntityMethod.invoke(modelData = this.modelDataField.get(entity), entity)) != null) {
                            entity = wrappedEntity;
                        }
                    }
                    catch (Exception modelData) {
                        // empty catch block
                    }
                }
                Contact contact = new Contact(entity, this.getContactTypeStrict(entity));
                String unscrubbedName = contact.entity.func_145748_c_().func_150254_d();
                contact.setName(unscrubbedName);
                if (contact.entity.func_184187_bx() != null && this.isEntityShown(contact.entity.func_184187_bx())) {
                    contact.yFudge = 1;
                }
                contact.updateLocation();
                if (contact.type != EnumMobs.UNKNOWN) {
                    contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(contact.type.id + contact.type.resourceLocation.toString() + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "") + "0"), this.textureAtlas.getAtlasSprite(contact.type.id + contact.type.resourceLocation.toString() + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "") + "1")};
                }
                if (contact.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryCustomIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryAutoIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryFallbackType(contact);
                }
                if (!this.builtInCustom[contact.type.ordinal()] && contact.type != EnumMobs.CUSTOM && contact.type != EnumMobs.UNKNOWN && contact.type != EnumMobs.BLANK && contact.type != EnumMobs.GENERICHOSTILE && contact.type != EnumMobs.GENERICNEUTRAL && contact.type != EnumMobs.GENERICTAME && this.options.randomobs) {
                    contact.icons = this.getIconsForRandomob(contact);
                }
                if (contact.type == EnumMobs.HORSE) {
                    contact.setRotationFactor(45);
                }
                if ((scrubbedName = TextFormatting.func_110646_a((String)contact.entity.func_70005_c_())) != null && (scrubbedName.equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact.entity instanceof EntityPlayer) || ((EntityPlayer)contact.entity).func_175148_a(EnumPlayerModelParts.CAPE))) {
                    contact.setRotationFactor(contact.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) {
                    this.getArmor(contact, entity);
                }
                if (contact.type == EnumMobs.UNKNOWN || contact.type == EnumMobs.CUSTOM || contact.type == EnumMobs.AUTO) {
                    String type = EntityList.func_75621_b((Entity)entity);
                    CustomMob customMob = CustomMobsManager.getCustomMobByType(type);
                    if (customMob != null && !customMob.enabled) continue;
                    this.contacts.add(contact);
                    continue;
                }
                if (!contact.type.enabled) continue;
                this.contacts.add(contact);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.newMobs) {
            try {
                this.textureAtlas.stitchNew();
            }
            catch (StitcherException e) {
                System.err.println("Stitcher exception!  Resetting mobs texture atlas.");
                this.loadTexturePackIcons();
            }
        }
        this.newMobs = false;
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private void tryCustomIcon(Contact contact) {
        block30: {
            Sprite icon = this.textureAtlas.getAtlasSprite(contact.entity.getClass().getName() + "custom0");
            if (icon == this.textureAtlas.getMissingImage()) {
                boolean isHostile = this.isHostile(contact.entity);
                CustomMobsManager.add(EntityList.func_75621_b((Entity)contact.entity), isHostile, !isHostile);
                try {
                    int intendedSize = 8;
                    String fullPath = "textures/icons/" + contact.entity.getClass().getName() + ".png";
                    InputStream is = null;
                    try {
                        is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + ".png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "8.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "8.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 16;
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "16.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "16.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 32;
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "32.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "32.png";
                        try {
                            is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is != null) {
                        BufferedImage mobSkin = ImageIO.read(is);
                        is.close();
                        mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                        float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                        BufferedImage mobSkin0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 1.0f / scale)), this.options.outlines);
                        BufferedImage mobSkin1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 2.0f / scale)), this.options.outlines);
                        Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(contact.entity.getClass().getName() + "custom0", mobSkin0);
                        Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(contact.entity.getClass().getName() + "custom1", mobSkin1);
                        this.newMobs = true;
                        contact.icons = new Sprite[]{icon0, icon1};
                        contact.type = EnumMobs.CUSTOM;
                        break block30;
                    }
                    contact.type = EnumMobs.UNKNOWN;
                    this.textureAtlas.registerFailedIcon(contact.entity.getClass().getName() + "custom0");
                }
                catch (IOException e) {
                    contact.type = EnumMobs.UNKNOWN;
                    this.textureAtlas.registerFailedIcon(contact.entity.getClass().getName() + "custom0");
                }
            } else if (icon != this.textureAtlas.getFailedImage()) {
                contact.type = EnumMobs.CUSTOM;
                contact.icons = new Sprite[]{icon, this.textureAtlas.getAtlasSprite(contact.entity.getClass().getName() + "custom1")};
            } else {
                contact.type = EnumMobs.UNKNOWN;
            }
        }
    }

    private void tryAutoIcon(Contact contact) {
        Render render = this.game.func_175598_ae().func_78713_a(contact.entity);
        ResourceLocation resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, contact.entity);
        String entityName = contact.entity.getClass().getName();
        String resourceLocationString = resourceLocation != null ? resourceLocation.toString() : "";
        String nameMinusSize = entityName + resourceLocationString;
        Sprite icon = this.textureAtlas.getAtlasSprite(nameMinusSize + 0);
        if (icon == this.textureAtlas.getMissingImage()) {
            BufferedImage mobImage;
            Integer checkCount = this.contactsSkinGetTries.get(nameMinusSize);
            if (checkCount == null) {
                checkCount = 0;
            }
            if ((mobImage = this.createAutoIconImageFromResourceLocation(contact, (Render<? extends Entity>)render, resourceLocation)) != null) {
                try {
                    contact.type = EnumMobs.AUTO;
                    BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, mobImage);
                    Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "0", trimmedImages[0]);
                    Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "1", trimmedImages[1]);
                    contact.icons = new Sprite[]{icon0, icon1};
                    this.newMobs = true;
                    this.contactsSkinGetTries.remove(nameMinusSize);
                }
                catch (Exception e) {
                    contact.type = EnumMobs.UNKNOWN;
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    if (checkCount > 4) {
                        this.textureAtlas.registerFailedIcon(nameMinusSize + "0");
                    }
                }
            } else {
                contact.type = EnumMobs.UNKNOWN;
                Integer n = checkCount;
                Integer n3 = checkCount = Integer.valueOf(checkCount + 1);
                if (checkCount > 4) {
                    this.textureAtlas.registerFailedIcon(nameMinusSize + "0");
                }
            }
        } else if (icon != this.textureAtlas.getFailedImage()) {
            contact.type = EnumMobs.AUTO;
            contact.icons = new Sprite[]{icon, this.textureAtlas.getAtlasSprite(nameMinusSize + 1)};
        } else {
            contact.type = EnumMobs.UNKNOWN;
        }
    }

    private BufferedImage createAutoIconImageFromResourceLocation(Contact contact, Render<? extends Entity> render, ResourceLocation resourceLocation) {
        BufferedImage headImage = null;
        if (GLUtils.fboEnabled && render instanceof RenderLivingBase) {
            try {
                ModelBase model = ((RenderLivingBase)render).func_177087_b();
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, ModelBase.class, ModelRenderer.class);
                ArrayList<Field> submodelArrays = ReflectionUtils.getFieldsByType(model, ModelBase.class, ModelRenderer[].class);
                ModelRenderer[] headBits = null;
                Properties properties = new Properties();
                String fullPath = "textures/icons/" + contact.entity.getClass().getName() + ".properties";
                InputStream is = null;
                try {
                    is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is == null) {
                    fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + ".properties";
                    try {
                        is = this.game.func_110442_L().func_110536_a(new ResourceLocation(fullPath)).func_110527_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
                if (is != null) {
                    String name;
                    properties.load(is);
                    is.close();
                    String subModelNames = properties.getProperty("models", "").toLowerCase();
                    String[] submodelNamesArray = subModelNames.split(",");
                    Iterator<Field> subModelNamesList = Arrays.asList(submodelNamesArray);
                    HashSet<String> subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll((Collection<String>)((Object)subModelNamesList));
                    ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                    ArrayList purge = new ArrayList();
                    for (Field submodelArray : submodelArrays) {
                        ModelRenderer[] submodelArrayValue;
                        name = submodelArray.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null) continue;
                        for (int t = 0; t < submodelArrayValue.length; ++t) {
                            headPartsArrayList.add(submodelArrayValue[t]);
                        }
                    }
                    for (Field submodel : submodels) {
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                        headPartsArrayList.add((ModelRenderer)submodel.get(model));
                    }
                    for (ModelRenderer bit : headPartsArrayList) {
                        if (bit.field_78805_m == null) continue;
                        purge.addAll(bit.field_78805_m);
                    }
                    headPartsArrayList.removeAll(purge);
                    if (headPartsArrayList.size() > 0) {
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                if (headBits == null) {
                    if (model instanceof ModelBat) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelBat.class, ModelRenderer.class)};
                    } else if (model instanceof ModelBiped) {
                        headBits = new ModelRenderer[]{((ModelBiped)model).field_78116_c, ((ModelBiped)model).field_178720_f};
                    } else if (model instanceof ModelBlaze) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelBlaze.class, ModelRenderer.class)};
                    } else if (model instanceof ModelChicken) {
                        headBits = new ModelRenderer[]{((ModelChicken)model).field_78142_a};
                    } else if (model instanceof ModelCow) {
                        headBits = new ModelRenderer[]{((ModelCow)model).field_78150_a};
                    } else if (model instanceof ModelCreeper) {
                        headBits = new ModelRenderer[]{((ModelCreeper)model).field_78135_a};
                    } else if (model instanceof ModelDragon) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelDragon.class, ModelRenderer.class)};
                    } else if (model instanceof ModelGhast) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelGhast.class, ModelRenderer.class)};
                    } else if (model instanceof ModelGuardian) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelGuardian.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelGuardian.class, ModelRenderer.class, 1)};
                    } else if (model instanceof ModelHorse) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelHorse.class, ModelRenderer.class)};
                    } else if (model instanceof ModelIllager) {
                        headBits = new ModelRenderer[]{((ModelIllager)model).field_191217_a};
                    } else if (model instanceof ModelIronGolem) {
                        headBits = new ModelRenderer[]{((ModelIronGolem)model).field_78178_a};
                    } else if (model instanceof ModelOcelot) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelOcelot.class, ModelRenderer.class, 6)};
                    } else if (model instanceof ModelPig) {
                        headBits = new ModelRenderer[]{((ModelPig)model).field_78150_a};
                    } else if (model instanceof ModelPolarBear) {
                        headBits = new ModelRenderer[]{((ModelPolarBear)model).field_78150_a};
                    } else if (model instanceof ModelRabbit) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelRabbit.class, ModelRenderer.class, 7), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelRabbit.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelRabbit.class, ModelRenderer.class, 9), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelRabbit.class, ModelRenderer.class, 10)};
                    } else if (model instanceof ModelShulker) {
                        headBits = new ModelRenderer[]{((ModelShulker)model).field_187066_a};
                    } else if (model instanceof ModelSilverfish) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, ModelSilverfish.class, ModelRenderer[].class))[0], (ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, ModelSilverfish.class, ModelRenderer[].class))[1]};
                    } else if (model instanceof ModelSlime) {
                        ModelSlime modelOuter = new ModelSlime(0);
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelSlime.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelSlime.class, ModelRenderer.class, 1), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelSlime.class, ModelRenderer.class, 2), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelSlime.class, ModelRenderer.class, 3), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(modelOuter, ModelSlime.class, ModelRenderer.class, 0)};
                    } else if (model instanceof ModelSnowMan) {
                        headBits = new ModelRenderer[]{((ModelSnowMan)model).field_78195_c};
                    } else if (model instanceof ModelSpider) {
                        headBits = new ModelRenderer[]{((ModelSpider)model).field_78209_a};
                    } else if (model instanceof ModelSquid) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ModelSquid.class, ModelRenderer.class)};
                    } else if (model instanceof ModelVillager) {
                        headBits = new ModelRenderer[]{((ModelVillager)model).field_78191_a};
                    } else if (model instanceof ModelWolf) {
                        headBits = new ModelRenderer[]{((ModelWolf)model).field_78185_a};
                    } else if (model instanceof ModelQuadruped) {
                        headBits = new ModelRenderer[]{((ModelQuadruped)model).field_78150_a};
                    } else {
                        String name;
                        ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                        ArrayList purge = new ArrayList();
                        for (Field submodelArray : submodelArrays) {
                            ModelRenderer[] submodelArrayValue;
                            name = submodelArray.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                        for (Field submodel : submodels) {
                            name = submodel.getName().toLowerCase();
                            String nameS = submodel.getName();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(!nameS.equals("LeftSmallEar") & !nameS.equals("RightSmallEar") & !nameS.equals("BHead") & !nameS.equals("BSnout") & !nameS.equals("BMouth") & !nameS.equals("BMouthOpen") & !nameS.equals("BLEar") & !nameS.equals("BREar") & !nameS.equals("CHead") & !nameS.equals("CSnout") & !nameS.equals("CMouth") & !nameS.equals("CMouthOpen") & !nameS.equals("CLEar") & !nameS.equals("CREar")) || submodel.get(model) == null) continue;
                            headPartsArrayList.add((ModelRenderer)submodel.get(model));
                        }
                        if (headPartsArrayList.size() == 0) {
                            ModelRenderer[] submodelArrayValue;
                            if (submodels.size() > 0) {
                                headPartsArrayList.add((ModelRenderer)submodels.get(0).get(model));
                            } else if (submodelArrays.size() > 0 && (submodelArrayValue = (ModelRenderer[])submodelArrays.get(0).get(model)).length > 0) {
                                headPartsArrayList.add(submodelArrayValue[0]);
                            }
                        }
                        for (ModelRenderer bit : headPartsArrayList) {
                            if (bit.field_78805_m == null) continue;
                            purge.addAll(bit.field_78805_m);
                        }
                        headPartsArrayList.removeAll(purge);
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                for (int t = 0; t < headBits.length; ++t) {
                    void bit = headBits[t];
                    if (!this.hasCustomNPCs || !this.modelScaleRendererClass.isInstance(bit)) continue;
                    bit.field_78807_k = false;
                }
                if (contact.entity != null && model != null && headBits.length > 0 && resourceLocation != null) {
                    String scaleString = properties.getProperty("scale", "1");
                    float scale = Float.parseFloat(scaleString);
                    EnumFacing facing = EnumFacing.NORTH;
                    String facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = EnumFacing.UP;
                    } else if (facingString.equals("side")) {
                        facing = EnumFacing.EAST;
                    }
                    boolean success = this.drawModel(scale, 1000, (EntityLivingBase)contact.entity, facing, model, resourceLocation, headBits);
                    if (success) {
                        headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    }
                }
            }
            catch (Exception e) {
                headImage = null;
            }
        }
        return headImage;
    }

    private boolean drawModel(float scale, int captureDepth, EntityLivingBase par5EntityLivingBase, EnumFacing facing, ModelBase model, ResourceLocation resourceLocation, ModelRenderer ... headBits) {
        boolean failed = false;
        float size = 32.0f * scale;
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f + (float)captureDepth);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef(width / 2, height / 2, 0.0f);
        GLShim.glScalef(size, size, size);
        GLShim.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GLUtils.img(resourceLocation);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        if (facing == EnumFacing.EAST) {
            GLShim.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (facing == EnumFacing.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        try {
            int t;
            GLShim.glTranslatef(500.0f, 500.0f, 0.0f);
            model.func_78088_a((Entity)par5EntityLivingBase, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f, 0.0625f);
            GLShim.glTranslatef(-500.0f, -500.0f, 0.0f);
            float offsetByY = 0.0f;
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].field_78797_d < minY) {
                    minY = headBits[t].field_78797_d;
                }
                if (!(headBits[t].field_78797_d > maxY)) continue;
                maxY = headBits[t].field_78797_d;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            if (captureDepth == 2) {
                offsetByY = 4.0f;
            }
            for (t = 0; t < headBits.length; ++t) {
                float y = headBits[t].field_78797_d;
                headBits[t].field_78797_d += offsetByY;
                headBits[t].func_78785_a(0.0625f);
                headBits[t].field_78797_d = y;
            }
        }
        catch (Exception e) {
            failed = true;
        }
        GLShim.glPopMatrix();
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.field_71443_c, this.game.field_71440_d);
        return !failed;
    }

    private void tryFallbackType(Contact contact) {
        contact.type = this.getContactType(contact.entity);
        if (contact.type == EnumMobs.UNKNOWN) {
            contact.type = this.getUnknownMobNeutrality(contact.entity);
        }
        String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
        resourceLocationString = resourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "");
        String nameWithoutSize = contact.type.id + resourceLocationString;
        contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(nameWithoutSize + "0"), this.textureAtlas.getAtlasSprite(nameWithoutSize + "1")};
    }

    private Sprite[] getIconsForRandomob(Contact contact) {
        String entityName;
        String nameMinusSize;
        Sprite icon;
        if (contact.type == EnumMobs.PLAYER && !contact.icons[0].getIconName().equals(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "0")) {
            return contact.icons;
        }
        ResourceLocation resourceLocation = null;
        Render render = this.game.func_175598_ae().func_78713_a(contact.entity);
        resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, contact.entity);
        String originalResourceLocationString = resourceLocation != null ? resourceLocation.toString() : "";
        resourceLocation = this.getResourceLocationForEntity(resourceLocation, contact.entity);
        ResourceLocation resourceLocationSecondary = null;
        if (contact.type.secondaryResourceLocation != null) {
            if (contact.type == EnumMobs.MOOSHROOM) {
                resourceLocationSecondary = !((EntityMooshroom)contact.entity).func_70631_g_() ? EnumMobs.MOOSHROOM.secondaryResourceLocation : null;
            }
            originalResourceLocationString = originalResourceLocationString + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
            if (contact.type == EnumMobs.MOOSHROOM) {
                resourceLocationSecondary = this.getResourceLocationForEntity(resourceLocationSecondary, (Entity)((EntityLivingBase)contact.entity));
            }
        }
        String resourceLocationString = (resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
        if (contact.type != EnumMobs.AUTO) {
            String defaultResourceLocationString = contact.type.resourceLocation.toString();
            if (resourceLocationString.equals(defaultResourceLocationString = defaultResourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : ""))) {
                return contact.icons;
            }
        } else if (resourceLocationString.equals(originalResourceLocationString)) {
            return contact.icons;
        }
        if ((icon = this.textureAtlas.getAtlasSprite((nameMinusSize = (entityName = contact.type != EnumMobs.AUTO ? contact.type.id : contact.entity.getClass().getName()) + resourceLocationString) + "0")) == this.textureAtlas.getMissingImage()) {
            BufferedImage mobImage = null;
            if (contact.type == EnumMobs.HORSE) {
                ITextureObject textureObject = GLUtils.textureManager.func_110581_b(resourceLocation);
                if (textureObject != null) {
                    mobImage = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b());
                    mobImage = this.createImageFromTypeAndImages(contact.type, mobImage, null);
                }
            } else if (contact.type != EnumMobs.AUTO) {
                mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, resourceLocationSecondary);
            } else if (contact.type == EnumMobs.AUTO) {
                mobImage = this.createAutoIconImageFromResourceLocation(contact, (Render<? extends Entity>)render, resourceLocation);
            }
            if (mobImage == null) {
                return contact.icons;
            }
            BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, mobImage);
            Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "0", trimmedImages[0]);
            Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "1", trimmedImages[1]);
            this.newMobs = true;
            return new Sprite[]{icon0, icon1};
        }
        return new Sprite[]{icon, this.textureAtlas.getAtlasSprite(nameMinusSize + "1")};
    }

    private ResourceLocation getResourceLocationForEntity(ResourceLocation resourceLocation, Entity entity) {
        try {
            Object randomEntitiesProperties;
            if (this.randomobsOptifine) {
                Object randomMobsProperties = this.getRandomobPropertiesMethod.invoke(this.randomMobsClass, resourceLocation);
                if (randomMobsProperties != null) {
                    resourceLocation = (ResourceLocation)this.getMobTextureMethod.invoke(this.randomMobsPropertiesClass.cast(randomMobsProperties), resourceLocation, entity);
                }
            } else if (this.randomobsOptifineNew && (randomEntitiesProperties = this.mapProperties.get(resourceLocation.func_110623_a())) != null) {
                this.setEntityMethod.invoke(this.randomEntityClass.cast(this.randomEntity), entity);
                resourceLocation = (ResourceLocation)this.getEntityTextureMethod.invoke(this.randomEntitiesPropertiesClass.cast(randomEntitiesProperties), resourceLocation, this.randomEntityClass.cast(this.randomEntity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceLocation;
    }

    private BufferedImage[] trimAndOutlineImages(EnumMobs type, BufferedImage image) {
        if (type == EnumMobs.AUTO) {
            image = ImageUtils.trim(image);
            double acceptableMax = 32.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 64.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)(1.0 / Math.ceil((double)maxDimension / acceptableMax));
            BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, scale / 2.0f)), this.options.outlines);
            BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, scale)), this.options.outlines);
            return new BufferedImage[]{image0, image1};
        }
        float scale = (float)image.getWidth() / (float)type.expectedWidth;
        BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
        BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
        return new BufferedImage[]{image0, image1};
    }

    private void handleMPplayer(Contact contact) {
        AbstractClientPlayer player = (AbstractClientPlayer)contact.entity;
        GameProfile gameProfile = player.func_146103_bH();
        UUID uuid = gameProfile.getId();
        contact.setUUID(uuid);
        String playerName = this.scrubCodes(gameProfile.getName());
        Sprite icon0 = this.textureAtlas.getAtlasSprite(playerName + " 0");
        Sprite icon1 = null;
        Integer checkCount = 0;
        if (icon0 == this.textureAtlas.getMissingImage()) {
            checkCount = this.mpContactsSkinGetTries.get(playerName);
            if (checkCount == null) {
                checkCount = 0;
            }
            if (checkCount < 5) {
                ThreadDownloadImageData imageData = null;
                try {
                    if (player.func_110306_p() == DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au())) {
                        throw new Exception("failed to get skin: skin is default");
                    }
                    imageData = AbstractClientPlayer.func_110304_a((ResourceLocation)player.func_110306_p(), (String)player.func_70005_c_());
                    if (imageData == null) {
                        throw new Exception("failed to get skin: image data was null");
                    }
                    BufferedImage skinImage = ImageUtils.createBufferedImageFromGLID(imageData.func_110552_b());
                    boolean showHat = player.func_175148_a(EnumPlayerModelParts.HAT);
                    skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
                    float scale = (float)skinImage.getWidth() / 8.0f;
                    BufferedImage skinImageSmall = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 1.0f / scale)), this.options.outlines);
                    BufferedImage skinImageLarge = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), this.options.outlines);
                    icon0 = this.textureAtlas.registerIconForBufferedImage(playerName + " 0", skinImageSmall);
                    icon1 = this.textureAtlas.registerIconForBufferedImage(playerName + " 1", skinImageLarge);
                    this.newMobs = true;
                    this.mpContactsSkinGetTries.remove(playerName);
                }
                catch (Exception e) {
                    icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "0");
                    icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "1");
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    this.mpContactsSkinGetTries.put(playerName, checkCount);
                }
                contact.icons = new Sprite[]{icon0, icon1};
            }
        } else {
            contact.icons = new Sprite[]{icon0, this.textureAtlas.getAtlasSprite(playerName + " 1")};
        }
    }

    private void getArmor(Contact contact, Entity entity) {
        Sprite icon0 = null;
        Sprite icon1 = null;
        ItemStack stack = ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.HEAD);
        Item helmet = null;
        if (stack != null) {
            helmet = stack.func_77973_b();
        }
        if (contact.type == EnumMobs.SHEEP) {
            EntitySheep sheepEntity = (EntitySheep)contact.entity;
            if (!sheepEntity.func_70892_o()) {
                icon0 = this.textureAtlas.getAtlasSprite("sheepfur0");
                icon1 = this.textureAtlas.getAtlasSprite("sheepfur1");
                float[] sheepColors = EntitySheep.func_175513_a((EnumDyeColor)sheepEntity.func_175509_cj());
                contact.setArmorColor((int)(sheepColors[0] * 255.0f) << 16 | (int)(sheepColors[1] * 255.0f) << 8 | (int)(sheepColors[2] * 255.0f));
            }
        } else if (helmet != null) {
            if (helmet instanceof ItemArmor) {
                ItemArmor helmetArmor = (ItemArmor)helmet;
                int armorType = this.getArmorType(helmetArmor);
                if (armorType == UNKNOWN) {
                    icon0 = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a() + " 0");
                    icon1 = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a() + " 1");
                    if (icon0 == this.textureAtlas.getMissingImage()) {
                        Sprite[] newIcons = this.createUnknownArmorIcons(contact, stack, helmet);
                        icon0 = newIcons[0];
                        icon1 = newIcons[1];
                    } else if (icon0 == this.textureAtlas.getFailedImage()) {
                        icon0 = null;
                        icon1 = null;
                    }
                } else {
                    icon0 = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType] + " 0");
                    icon1 = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType] + " 1");
                }
                if (armorType == 0) {
                    contact.setArmorColor(helmetArmor.func_82814_b(stack));
                }
            } else {
                int id = Item.func_150891_b((Item)helmet);
                int metadata = stack.func_77960_j();
                if (helmet instanceof ItemBlock) {
                    BufferedImage blockImage;
                    Block block = ((ItemBlock)helmet).func_179223_d();
                    IBlockState blockState = block.func_176203_a(metadata);
                    int stateID = id + metadata << 12;
                    icon0 = this.textureAtlas.getAtlasSprite("blockArmor " + stateID + " 0");
                    icon1 = this.textureAtlas.getAtlasSprite("blockArmor " + stateID + " 1");
                    if (icon0 == this.textureAtlas.getMissingImage() && (blockImage = this.master.getColorManager().getBlockImage(blockState, stack, entity.field_70170_p)) != null) {
                        BufferedImage largeImage = ImageUtils.fillOutline(ImageUtils.pad(blockImage), this.options.outlines, true, 16, 0);
                        BufferedImage smallImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(blockImage, 0.5f)), this.options.outlines, true, 8, 0);
                        icon0 = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID + " 0", smallImage);
                        icon1 = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID + " 1", largeImage);
                        this.newMobs = true;
                    }
                } else if (helmet == Items.field_151144_bL) {
                    switch (metadata) {
                        case 0: {
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + 1);
                            break;
                        }
                        case 1: {
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + 1);
                            break;
                        }
                        case 2: {
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + 1);
                            break;
                        }
                        case 3: {
                            GameProfile gameProfile = null;
                            if (stack.func_77942_o()) {
                                String s;
                                NBTTagCompound nbttagcompound = stack.func_77978_p();
                                if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                                    gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                                } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && (s = nbttagcompound.func_74779_i("SkullOwner")) != null && !s.equals("")) {
                                    gameProfile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile((UUID)null, s));
                                    nbttagcompound.func_74782_a("SkullOwner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
                                }
                            }
                            if (gameProfile != null) {
                                ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
                                Minecraft minecraft = Minecraft.func_71410_x();
                                Map map = minecraft.func_152342_ad().func_152788_a(gameProfile);
                                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                                }
                                if (resourcelocation != null) {
                                    BufferedImage image;
                                    ITextureObject textureObject;
                                    icon0 = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(EnumMobs.PLAYER.id + resourcelocation.toString() + "0");
                                    icon1 = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(EnumMobs.PLAYER.id + resourcelocation.toString() + "1");
                                    if (icon0 == this.textureAtlas.getMissingImage() && (textureObject = GLUtils.textureManager.func_110581_b(resourcelocation)) != null && (image = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b())) != null) {
                                        image = this.createImageFromTypeAndImages(contact.type, image, null);
                                        BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, image);
                                        icon0 = this.textureAtlas.registerIconForBufferedImage(EnumMobs.PLAYER.id + resourcelocation.toString() + "0", trimmedImages[0]);
                                        icon1 = this.textureAtlas.registerIconForBufferedImage(EnumMobs.PLAYER.id + resourcelocation.toString() + "1", trimmedImages[1]);
                                        this.newMobs = true;
                                    }
                                }
                            }
                            if (icon0 != null && icon1 != null) break;
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + 1);
                            break;
                        }
                        case 4: {
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + 1);
                            break;
                        }
                        case 5: {
                            icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + 0);
                            icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + 1);
                        }
                    }
                    if (icon0 != null && icon1 != null) {
                        contact.icons = new Sprite[]{icon0, icon1};
                    }
                    icon0 = null;
                    icon1 = null;
                }
            }
        }
        contact.armorIcons = new Sprite[]{icon0, icon1};
    }

    private Sprite[] createUnknownArmorIcons(Contact contact, ItemStack stack, Item helmet) {
        BufferedImage armorTexture;
        Sprite icon0 = null;
        Sprite icon1 = null;
        Method m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorTexture", Entity.class, ItemStack.class, String.class, EntityEquipmentSlot.class, String.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getResourceLocation = m;
        ResourceLocation resourceLocation = null;
        try {
            if (getResourceLocation != null) {
                String texture = ((ItemArmor)helmet).func_82812_d().func_179242_c();
                String domain = "minecraft";
                int sep = texture.indexOf(58);
                if (sep != -1) {
                    domain = texture.substring(0, sep);
                    texture = texture.substring(sep + 1);
                }
                String resourcePath = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, "");
                resourcePath = (String)getResourceLocation.invoke(null, contact.entity, stack, resourcePath, EntityEquipmentSlot.HEAD, null);
                resourceLocation = new ResourceLocation(resourcePath);
            }
        }
        catch (Exception texture) {
            // empty catch block
        }
        m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorModel", EntityLivingBase.class, ItemStack.class, EntityEquipmentSlot.class, ModelBiped.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getModel = m;
        ModelBiped modelBiped = null;
        try {
            if (getModel != null) {
                modelBiped = (ModelBiped)getModel.invoke(null, contact.entity, stack, EntityEquipmentSlot.HEAD, null);
            }
        }
        catch (Exception sep) {
            // empty catch block
        }
        if (modelBiped != null && resourceLocation != null && GLUtils.fboEnabled) {
            ModelRenderer[] headBits = new ModelRenderer[]{modelBiped.field_78116_c, modelBiped.field_178720_f};
            this.drawModel(0.888888f, 2, (EntityLivingBase)contact.entity, EnumFacing.NORTH, (ModelBase)modelBiped, resourceLocation, headBits);
            BufferedImage armorTexture2 = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            armorTexture2 = armorTexture2.getSubimage(GLUtils.fboRad - 28, GLUtils.fboRad - 28, 56, 56);
            float scale = 2.0f;
            BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture2, 1.0f / scale)), this.options.outlines, true, 8, 0);
            BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture2, 2.0f / scale)), this.options.outlines, true, 16, 0);
            icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 0", armorImage0);
            icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 1", armorImage1);
            this.newMobs = true;
        } else if (resourceLocation != null && (armorTexture = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation)) != null) {
            armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            float scale = (float)armorTexture.getWidth() / 8.0f;
            BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 1.0f / scale)), this.options.outlines, true, 8, 0);
            BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 2.0f / scale)), this.options.outlines, true, 16, 0);
            icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 0", armorImage0);
            icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 1", armorImage1);
            this.newMobs = true;
        }
        if (icon0 == null || icon1 == null) {
            System.out.println("can't get texture for custom armor type: " + helmet.getClass());
            this.textureAtlas.registerFailedIcon("armor " + helmet.func_77658_a() + " 0");
        }
        return new Sprite[]{icon0, icon1};
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    private EnumMobs getContactTypeStrict(Entity entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.equals(EntityBat.class)) {
            return EnumMobs.BAT;
        }
        if (entityClass.equals(EntityBlaze.class)) {
            return EnumMobs.BLAZE;
        }
        if (entityClass.equals(EntityCaveSpider.class)) {
            return EnumMobs.CAVESPIDER;
        }
        if (entityClass.equals(EntityChicken.class)) {
            return EnumMobs.CHICKEN;
        }
        if (entityClass.equals(EntityMooshroom.class)) {
            return EnumMobs.MOOSHROOM;
        }
        if (entityClass.equals(EntityCow.class)) {
            return EnumMobs.COW;
        }
        if (entityClass.equals(EntityCreeper.class)) {
            return EnumMobs.CREEPER;
        }
        if (entityClass.equals(EntityDragon.class)) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entityClass.equals(EntityEnderman.class)) {
            return EnumMobs.ENDERMAN;
        }
        if (entityClass.equals(EntityEndermite.class)) {
            return EnumMobs.ENDERMITE;
        }
        if (entityClass.equals(EntityEvoker.class)) {
            return EnumMobs.EVOKER;
        }
        if (entityClass.equals(EntityGhast.class)) {
            return EnumMobs.GHAST;
        }
        if (entityClass.equals(EntityGuardian.class)) {
            return EnumMobs.GUARDIAN;
        }
        if (entityClass.equals(EntityElderGuardian.class)) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entityClass.equals(EntityHorse.class) || entityClass.equals(EntityDonkey.class) || entityClass.equals(EntityMule.class) || entityClass.equals(EntitySkeletonHorse.class) || entityClass.equals(EntityZombieHorse.class)) {
            return EnumMobs.HORSE;
        }
        if (entityClass.equals(EntityLlama.class)) {
            return EnumMobs.LLAMA;
        }
        if (entityClass.equals(EntityIronGolem.class)) {
            return EnumMobs.IRONGOLEM;
        }
        if (entityClass.equals(EntityMagmaCube.class)) {
            return EnumMobs.MAGMA;
        }
        if (entityClass.equals(EntityOcelot.class)) {
            Render render = this.game.func_175598_ae().func_78713_a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, entity).func_110623_a();
            return path.endsWith("ocelot.png") ? EnumMobs.OCELOT : EnumMobs.CAT;
        }
        if (entityClass.equals(EntityParrot.class)) {
            return EnumMobs.PARROT;
        }
        if (entityClass.equals(EntityPig.class)) {
            return EnumMobs.PIG;
        }
        if (entityClass.equals(EntityPigZombie.class)) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof EntityOtherPlayerMP) {
            return EnumMobs.PLAYER;
        }
        if (entityClass.equals(EntityPolarBear.class)) {
            return EnumMobs.POLARBEAR;
        }
        if (entityClass.equals(EntityRabbit.class)) {
            return EnumMobs.RABBIT;
        }
        if (entityClass.equals(EntitySheep.class)) {
            return EnumMobs.SHEEP;
        }
        if (entityClass.equals(EntityShulker.class)) {
            return EnumMobs.SHULKER;
        }
        if (entityClass.equals(EntitySilverfish.class)) {
            return EnumMobs.SILVERFISH;
        }
        if (entityClass.equals(EntitySkeleton.class) || entityClass.equals(EntityWitherSkeleton.class) || entityClass.equals(EntityStray.class)) {
            Render render = this.game.func_175598_ae().func_78713_a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, entity).func_110623_a();
            return path.endsWith("wither_skeleton.png") ? EnumMobs.SKELETONWITHER : EnumMobs.SKELETON;
        }
        if (entityClass.equals(EntitySlime.class)) {
            return EnumMobs.SLIME;
        }
        if (entityClass.equals(EntitySnowman.class)) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entityClass.equals(EntitySpider.class)) {
            return EnumMobs.SPIDER;
        }
        if (entityClass.equals(EntitySquid.class)) {
            return EnumMobs.SQUID;
        }
        if (entityClass.equals(EntityVex.class)) {
            return EnumMobs.VEX;
        }
        if (entityClass.equals(EntityVillager.class)) {
            return EnumMobs.VILLAGER;
        }
        if (entityClass.equals(EntityVindicator.class)) {
            return EnumMobs.VINDICATOR;
        }
        if (entityClass.equals(EntityWitch.class)) {
            return EnumMobs.WITCH;
        }
        if (entityClass.equals(EntityWither.class)) {
            return EnumMobs.WITHER;
        }
        if (entityClass.equals(EntityWolf.class)) {
            Render render = this.game.func_175598_ae().func_78713_a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, entity).func_110623_a();
            return path.endsWith("wolf_tame.png") ? EnumMobs.WOLFTAME : (path.endsWith("wolf_angry.png") ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entityClass.equals(EntityZombie.class) || entityClass.equals(EntityHusk.class)) {
            return EnumMobs.ZOMBIE;
        }
        if (entityClass.equals(EntityZombieVillager.class)) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getContactType(Entity entity) {
        if (entity instanceof EntityBat) {
            return EnumMobs.BAT;
        }
        if (entity instanceof EntityBlaze) {
            return EnumMobs.BLAZE;
        }
        if (entity instanceof EntityCaveSpider) {
            return EnumMobs.CAVESPIDER;
        }
        if (entity instanceof EntityChicken) {
            return EnumMobs.CHICKEN;
        }
        if (entity instanceof EntityMooshroom) {
            return EnumMobs.MOOSHROOM;
        }
        if (entity instanceof EntityCow) {
            return EnumMobs.COW;
        }
        if (entity instanceof EntityCreeper) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof EntityDragon) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entity instanceof EntityEnderman) {
            return EnumMobs.ENDERMAN;
        }
        if (entity instanceof EntityEndermite) {
            return EnumMobs.ENDERMITE;
        }
        if (entity instanceof EntityEvoker) {
            return EnumMobs.EVOKER;
        }
        if (entity instanceof EntityGhast) {
            return EnumMobs.GHAST;
        }
        if (entity instanceof EntityElderGuardian) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entity instanceof EntityGuardian) {
            return EnumMobs.GUARDIAN;
        }
        if (entity instanceof EntityLlama) {
            return EnumMobs.LLAMA;
        }
        if (entity instanceof AbstractHorse) {
            return EnumMobs.HORSE;
        }
        if (entity instanceof EntityIronGolem) {
            return EnumMobs.IRONGOLEM;
        }
        if (entity instanceof EntityMagmaCube) {
            return EnumMobs.MAGMA;
        }
        if (entity instanceof EntityOcelot) {
            Render render = this.game.func_175598_ae().func_78713_a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, entity).func_110623_a();
            return path.endsWith("ocelot.png") ? EnumMobs.OCELOT : EnumMobs.CAT;
        }
        if (entity instanceof EntityParrot) {
            return EnumMobs.PARROT;
        }
        if (entity instanceof EntityPig) {
            return EnumMobs.PIG;
        }
        if (entity instanceof EntityPigZombie) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof EntityOtherPlayerMP) {
            return EnumMobs.PLAYER;
        }
        if (entity instanceof EntityPolarBear) {
            return EnumMobs.POLARBEAR;
        }
        if (entity instanceof EntityRabbit) {
            return EnumMobs.RABBIT;
        }
        if (entity instanceof EntitySheep) {
            return EnumMobs.SHEEP;
        }
        if (entity instanceof EntityShulker) {
            return EnumMobs.SHULKER;
        }
        if (entity instanceof EntitySilverfish) {
            return EnumMobs.SILVERFISH;
        }
        if (entity instanceof AbstractSkeleton) {
            return EnumMobs.SKELETON;
        }
        if (entity instanceof EntitySlime) {
            return EnumMobs.SLIME;
        }
        if (entity instanceof EntitySnowman) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entity instanceof EntitySpider) {
            return EnumMobs.SPIDER;
        }
        if (entity instanceof EntitySquid) {
            return EnumMobs.SQUID;
        }
        if (entity instanceof EntityVex) {
            return EnumMobs.VEX;
        }
        if (entity instanceof EntityVillager) {
            return EnumMobs.VILLAGER;
        }
        if (entity instanceof EntityVindicator) {
            return EnumMobs.VINDICATOR;
        }
        if (entity instanceof EntityWitch) {
            return EnumMobs.WITCH;
        }
        if (entity instanceof EntityWither) {
            return EnumMobs.WITHER;
        }
        if (entity instanceof EntityWolf) {
            Render render = this.game.func_175598_ae().func_78713_a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, entity).func_110623_a();
            return path.endsWith("wolf_tame.png") ? EnumMobs.WOLFTAME : (path.endsWith("wolf_angry.png") ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entity instanceof EntityZombieVillager) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        if (entity instanceof EntityZombie) {
            return EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getUnknownMobNeutrality(Entity entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n() && (this.game.func_71356_B() || ((EntityTameable)entity).func_70902_q().equals((Object)this.game.field_71439_g))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private int getArmorType(ItemArmor helmet) {
        if (helmet.func_77658_a().equals("item.helmetCloth")) {
            return 0;
        }
        if (helmet.func_77658_a().equals("item.helmetChain")) {
            return 4;
        }
        if (helmet.func_77658_a().equals("item.helmetIron")) {
            return 5;
        }
        if (helmet.func_77658_a().equals("item.helmetGold")) {
            return 6;
        }
        if (helmet.func_77658_a().equals("item.helmetDiamond")) {
            return 7;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y, int guiScale) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp(this.textureAtlas.func_110552_b());
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 771);
        for (Contact contact : this.contacts) {
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            }
            boolean inRange = false;
            if (this.minimapOptions.squareMap) {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            } else {
                boolean bl = inRange = contact.distance < 31.0;
            }
            if (!inRange) continue;
            try {
                int northRotate;
                GLShim.glPushMatrix();
                int n = northRotate = this.minimapOptions.oldNorth && !this.minimapOptions.rotates ? 90 : 0;
                if (this.options.filtering) {
                    GLShim.glTranslatef(x, y, 0.0f);
                    GLShim.glRotatef(-contact.angle + (float)northRotate, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslated(0.0, -contact.distance, 0.0);
                    GLShim.glRotatef(contact.angle - (float)northRotate + (float)contact.rotationFactor, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    wayX = Math.sin(Math.toRadians(contact.angle - (float)northRotate)) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(contact.angle - (float)northRotate)) * contact.distance;
                    if (this.options.filtering) {
                        GLShim.glTranslated(-wayX, -wayZ, 0.0);
                    } else {
                        GLShim.glTranslated((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, (double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, 0.0);
                    }
                }
                float yOffset = 0.0f;
                if (contact.entity.func_184187_bx() != null && this.isEntityShown(contact.entity.func_184187_bx())) {
                    yOffset = -4.0f;
                }
                if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    Sprite icon = this.textureAtlas.getAtlasSprite("glow");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / 2.0f));
                    GLUtils.drawPost();
                }
                if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING || contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE || contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING) {
                    if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING) {
                        Render render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                    } else if (contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                        Render render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                    } else if (contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING) {
                        Render render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation((Render<? extends Entity>)render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("vex_charging.png") ? EnumMobs.VEXCHARGING : EnumMobs.VEX;
                    }
                    String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
                    String nameWithoutSize = contact.type.id + resourceLocationString;
                    contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(nameWithoutSize + "0"), this.textureAtlas.getAtlasSprite(nameWithoutSize + "1")};
                    if (!this.builtInCustom[contact.type.ordinal()] && this.options.randomobs) {
                        contact.icons = this.getIconsForRandomob(contact);
                        if (this.newMobs) {
                            this.textureAtlas.stitchNew();
                        }
                        this.newMobs = false;
                    }
                }
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(contact.icons[guiScale], x, (float)y + yOffset, (int)((float)contact.icons[guiScale].getIconWidth() / (float)(guiScale + 1)));
                GLUtils.drawPost();
                if ((this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) && contact.armorIcons[guiScale] != null) {
                    Sprite icon = contact.armorIcons[guiScale];
                    float armorOffset = 0.0f;
                    if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                        armorOffset = -0.5f;
                    }
                    float armorScale = 1.25f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    if (contact.armorColor != -1) {
                        red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                        green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                        blue = (float)(contact.armorColor >> 0 & 0xFF) / 255.0f;
                        if (contact.type == EnumMobs.SHEEP) {
                            armorScale = 0.525f;
                            EntitySheep sheepEntity = (EntitySheep)contact.entity;
                            if (sheepEntity.func_145818_k_() && "jeb_".equals(sheepEntity.func_95999_t())) {
                                int semiRandom = sheepEntity.field_70173_aa / 25 + sheepEntity.func_145782_y();
                                int numDyeColors = EnumDyeColor.values().length;
                                int colorID1 = semiRandom % numDyeColors;
                                int colorID2 = (semiRandom + 1) % numDyeColors;
                                float lerpVal = ((float)(sheepEntity.field_70173_aa % 25) + this.game.func_184121_ak()) / 25.0f;
                                float[] sheepColors1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)colorID1));
                                float[] sheepColors2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)colorID2));
                                red = sheepColors1[0] * (1.0f - lerpVal) + sheepColors2[0] * lerpVal;
                                green = sheepColors1[1] * (1.0f - lerpVal) + sheepColors2[1] * lerpVal;
                                blue = sheepColors1[2] * (1.0f - lerpVal) + sheepColors2[2] * lerpVal;
                            }
                        }
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                    }
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale);
                    GLUtils.drawPost();
                    if (icon == this.clothIcons[guiScale]) {
                        if (wayY < 0) {
                            GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
                        } else {
                            GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[2] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[1] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[3] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                    }
                } else if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    Sprite icon = this.textureAtlas.getAtlasSprite("crown" + guiScale);
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1)));
                    GLUtils.drawPost();
                }
                if (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                GLShim.glScalef(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
                int m = this.chkLen(contact.name) / 2;
                this.write(contact.name, (float)x * scaleFactor - (float)m, (float)(y + 3) * scaleFactor, 0xFFFFFF);
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }

    private boolean isHostile(Entity entity) {
        if (entity instanceof EntityPigZombie) {
            return ((EntityPigZombie)entity).func_175457_ck();
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity instanceof EntityPolarBear) {
            for (EntityPolarBear entitypolarbear : ((EntityPolarBear)entity).field_70170_p.func_72872_a(EntityPolarBear.class, ((EntityPolarBear)entity).func_174813_aQ().func_72321_a(8.0, 4.0, 8.0))) {
                if (!entitypolarbear.func_70631_g_()) continue;
                return true;
            }
        }
        if (entity instanceof EntityRabbit) {
            return ((EntityRabbit)entity).func_175531_cl() == 99;
        }
        if (entity instanceof EntityWolf) {
            return ((EntityWolf)entity).func_70919_bu();
        }
        return false;
    }

    private boolean isPlayer(Entity entity) {
        return entity instanceof EntityOtherPlayerMP;
    }

    private boolean isNeutral(Entity entity) {
        if (entity instanceof EntityLiving) {
            return !(entity instanceof EntityPlayer) && !this.isHostile(entity);
        }
        return false;
    }
}

