/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.pocket;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.inventory.ContainerBase;
import pl.asie.charset.lib.inventory.GuiContainerCharset;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.crafting.pocket.CharsetCraftingPocket;
import pl.asie.charset.module.crafting.pocket.ContainerPocketTable;
import pl.asie.charset.module.crafting.pocket.PacketPTAction;

public class GuiPocketTable
extends GuiContainerCharset<ContainerPocketTable> {
    private static final ResourceLocation POCKET_GUI = new ResourceLocation("charset:textures/gui/pocketgui.png");
    private final int buttonGridX;
    private final int buttonGridY;
    private final int buttonGridCount;
    private int open_time = 0;
    private int button_pressed = -1;

    public GuiPocketTable(ContainerPocketTable container) {
        super((ContainerBase)container, 235, 90);
        this.buttonGridX = 196;
        this.buttonGridY = 51;
        this.buttonGridCount = 3;
    }

    protected boolean showPlayerInventoryName() {
        return false;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        for (int i = 0; i < this.buttonGridCount; ++i) {
            int x = this.xBase + this.buttonGridX + i * 11;
            int y = this.yBase + this.buttonGridY;
            if (!this.insideRect(mouseX, mouseY, x, y, 11, 11) || this.button_pressed >= 0) continue;
            this.drawHoveringText(Collections.singletonList(this.getActionDescription(i)), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < this.buttonGridCount; ++i) {
                int x = this.xBase + this.buttonGridX + i * 11;
                int y = this.yBase + this.buttonGridY;
                if (!this.insideRect(mouseX, mouseY, x, y, 11, 11) || this.button_pressed >= 0) continue;
                this.button_pressed = i;
                break;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.button_pressed >= 0) {
            switch (this.button_pressed) {
                case 0: {
                    CharsetCraftingPocket.packet.sendToServer((Packet)new PacketPTAction(2, 0));
                    break;
                }
                case 1: {
                    CharsetCraftingPocket.packet.sendToServer((Packet)new PacketPTAction(1, 0));
                    break;
                }
                case 2: {
                    CharsetCraftingPocket.packet.sendToServer((Packet)new PacketPTAction(0, 0));
                }
            }
            this.button_pressed = -1;
        }
    }

    protected void func_146976_a(float partial, int mouseX, int mouseY) {
        super.func_146976_a(partial, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(POCKET_GUI);
        this.func_73729_b(this.xBase, this.yBase, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < this.buttonGridCount; ++i) {
            int x = this.xBase + this.buttonGridX + i * 11;
            int y = this.yBase + this.buttonGridY;
            int state = 0;
            if (this.button_pressed == i) {
                state = 2;
            } else if (this.insideRect(mouseX, mouseY, x, y, 11, 11)) {
                state = 1;
            }
            this.func_73729_b(x, y, i * 11, this.field_147000_g + state * 11, 11, 11);
        }
        ++this.open_time;
    }

    private String getActionDescription(int i) {
        String msg = null;
        switch (i) {
            case 0: {
                msg = "Empty grid";
                break;
            }
            case 1: {
                msg = "Swirl items \u21b7";
                break;
            }
            case 2: {
                msg = "Balance items";
                break;
            }
            case 3: {
                msg = "Fill grid with item";
            }
        }
        return "[" + Character.toUpperCase(CharsetCraftingPocket.pocketActions.charAt(i)) + "] " + msg;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.charset.crafting.name", (Object[])new Object[0]), 184, 11, 0x404040);
    }

    protected void func_73869_a(char key, int par2) throws IOException {
        if (this.open_time < 4) {
            super.func_73869_a(key, par2);
            return;
        }
        char my_key = ("" + key).toLowerCase(Locale.ROOT).charAt(0);
        int action = -1;
        int arg = 0;
        if (my_key == CharsetCraftingPocket.pocketActions.charAt(0)) {
            action = 2;
        } else if (my_key == CharsetCraftingPocket.pocketActions.charAt(1)) {
            action = 1;
        } else if (my_key == CharsetCraftingPocket.pocketActions.charAt(2)) {
            action = 0;
        }
        if (action != -1) {
            CharsetCraftingPocket.packet.sendToServer((Packet)new PacketPTAction(action, arg));
        } else {
            super.func_73869_a(key, par2);
        }
    }
}

