/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.pocket;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.inventory.ContainerBase;
import pl.asie.charset.lib.inventory.SlotBlocked;
import pl.asie.charset.lib.material.FastRecipeLookup;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.module.crafting.pocket.CharsetCraftingPocket;

public class ContainerPocketTable
extends ContainerBase {
    private static final int[] slotCycleOrder = new int[]{15, 16, 17, 26, 35, 34, 33, 24};
    private static final int[] slotPlayerOrder = new int[]{15, 16, 17, 24, 25, 26, 33, 34, 35};
    private final EntityPlayer player;
    private final InventoryPlayer playerInv;
    private final int heldPos;
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private IInventory craftResult = new InventoryCraftResult();
    private ArrayList<Slot> nonCraftingInventorySlots = new ArrayList();
    private ArrayList<Slot> craftingSlots = new ArrayList();
    private ArrayList<Slot> mainInvSlots = new ArrayList();
    private ArrayList<Slot> hotbarSlots = new ArrayList();
    private RedirectedSlotCrafting craftResultSlot;
    private boolean isCrafting = false;
    private boolean dirty = false;
    boolean isWorking = false;

    protected ItemStack getHeld() {
        return this.playerInv.func_70301_a(this.heldPos);
    }

    public List<Slot> getCraftingSlots() {
        return this.craftingSlots;
    }

    public List<Slot> getNonCraftingSlots() {
        return this.nonCraftingInventorySlots;
    }

    public ContainerPocketTable(EntityPlayer player) {
        super(player.field_71071_by);
        this.player = player;
        this.playerInv = player.field_71071_by;
        this.heldPos = this.playerInv.field_70461_c;
        this.craftResultSlot = (RedirectedSlotCrafting)this.func_75146_a((Slot)new RedirectedSlotCrafting(player, this.craftMatrix, this.craftResult, 207, 28));
        this.bindPlayerInventory(player.field_71071_by, 8, 8);
        this.updateCraft();
    }

    void movePlayerToMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.craftMatrix.func_70299_a(i, this.playerInv.func_70301_a(slotPlayerOrder[i]));
            this.playerInv.func_70299_a(slotPlayerOrder[i], ItemStack.field_190927_a);
        }
    }

    void copyMatrixToPlayer() {
        for (int i = 0; i < 9; ++i) {
            this.playerInv.func_70299_a(slotPlayerOrder[i], this.craftMatrix.func_70301_a(i).func_77946_l());
        }
    }

    public void updateCraft() {
        if (this.isWorking) {
            this.dirty = true;
            return;
        }
        this.movePlayerToMatrix();
        ItemStack result = ItemStack.field_190927_a;
        IRecipe match = FastRecipeLookup.findMatchingRecipe((InventoryCrafting)this.craftMatrix, (World)this.player.func_130014_f_());
        if (match != null) {
            result = match.func_77572_b(this.craftMatrix);
        }
        this.craftResult.func_70299_a(0, result);
        this.copyMatrixToPlayer();
        this.dirty = false;
        this.func_75142_b();
    }

    protected Slot func_75146_a(Slot slot) {
        if (slot.field_75224_c instanceof InventoryPlayer) {
            if (slot.func_75217_a(slot.field_75224_c, this.heldPos)) {
                slot = new SlotBlocked(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
            }
            if (slot.getSlotIndex() >= 9 && slot.getSlotIndex() % 9 >= 6) {
                slot = new Slot(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f){

                    public void func_75218_e() {
                        super.func_75218_e();
                        ContainerPocketTable.this.updateCraft();
                    }
                };
                this.craftingSlots.add(slot);
            } else {
                this.nonCraftingInventorySlots.add(slot);
                if (slot.getSlotIndex() < 9) {
                    this.hotbarSlots.add(slot);
                } else {
                    this.mainInvSlots.add(slot);
                }
                if (slot.getSlotIndex() < 9 && slot.func_75216_d() && slot.func_75211_c().func_77973_b() == CharsetCraftingPocket.pocketTable) {
                    slot = new Slot(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f){

                        public boolean func_82869_a(EntityPlayer playerIn) {
                            return false;
                        }
                    };
                }
            }
        }
        return super.func_75146_a(slot);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.isWorking = true;
        super.func_190896_a(p_190896_1_);
        this.isWorking = false;
    }

    public void func_75130_a(IInventory inv) {
        super.func_75130_a(inv);
    }

    public void func_75142_b() {
        if (!this.isCrafting) {
            super.func_75142_b();
        }
    }

    public void onAction(int action, int arg) {
        switch (action) {
            case 0: {
                this.craftBalance();
                break;
            }
            case 3: {
                this.craftFill(arg);
                break;
            }
            case 2: {
                this.craftClear();
                break;
            }
            case 1: {
                this.craftSwirl();
                break;
            }
            default: {
                return;
            }
        }
        this.updateCraft();
    }

    public boolean isOwnerPresent() {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        ItemStack slotStack = slot.func_75211_c();
        if (slot.func_75216_d()) {
            slotStack = slotStack.func_77946_l();
        }
        if (slot == this.craftResultSlot) {
            this.updateCraft();
            ItemStack res = slotStack;
            if (res.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int count = this.getMaxCraftingAttempts(res);
            if (count <= 0) {
                return ItemStack.field_190927_a;
            }
            while (count > 0) {
                ItemStack craftedStack = this.craftResultSlot.func_75211_c().func_77946_l();
                this.tryTransferStackInSlot(player, (Slot)this.craftResultSlot, this.nonCraftingInventorySlots);
                this.craftResultSlot.func_190901_a(player, craftedStack);
                this.updateCraft();
                ItemStack newRes = this.craftResultSlot.func_75211_c();
                if (!newRes.func_190926_b() && ItemUtils.canMerge((ItemStack)res, (ItemStack)newRes) && this.getMaxCraftingAttempts(newRes, newRes.func_190916_E()) > 0) {
                    --count;
                    continue;
                }
                break;
            }
        } else if (this.nonCraftingInventorySlots.contains(slot)) {
            this.tryTransferStackInSlot(player, slot, this.craftingSlots);
        } else if (this.craftingSlots.contains(slot)) {
            this.tryTransferStackInSlot(player, slot, this.nonCraftingInventorySlots);
        }
        return slotStack;
    }

    int getMaxCraftingAttempts(ItemStack res) {
        return this.getMaxCraftingAttempts(res, res.func_77976_d());
    }

    int getMaxCraftingAttempts(ItemStack res, int maxSize) {
        int maxCraftingAttempts;
        boolean hasEmpty = false;
        int nonEmptyAmount = 0;
        for (Slot slot : this.nonCraftingInventorySlots) {
            ItemStack is = slot.func_75211_c();
            if (is.func_190926_b()) {
                hasEmpty = true;
                continue;
            }
            if (!ItemUtils.canMerge((ItemStack)res, (ItemStack)is) || (nonEmptyAmount += is.func_77976_d() - is.func_190916_E()) < maxSize) continue;
            break;
        }
        if (nonEmptyAmount > maxSize) {
            nonEmptyAmount = maxSize;
        }
        if ((maxCraftingAttempts = nonEmptyAmount / res.func_190916_E()) == 0 && hasEmpty) {
            return maxSize / res.func_190916_E();
        }
        return maxCraftingAttempts;
    }

    void craftClear() {
        for (Slot slot : this.craftingSlots) {
            this.tryTransferStackInSlot(this.player, slot, this.mainInvSlots);
            if (!slot.func_75216_d()) continue;
            this.tryTransferStackInSlot(this.player, slot, this.hotbarSlots);
        }
    }

    void craftSwirl() {
        boolean anyAction = false;
        for (int n = 0; n < 8; ++n) {
            boolean any = false;
            block1: for (int slotIndexIndex = 0; slotIndexIndex < slotCycleOrder.length; ++slotIndexIndex) {
                ItemStack is = this.playerInv.func_70301_a(slotCycleOrder[slotIndexIndex]);
                if (is.func_190926_b() || is.func_190916_E() <= 1) continue;
                for (int probidex = slotIndexIndex; probidex < slotIndexIndex + slotCycleOrder.length; ++probidex) {
                    ItemStack empty = this.playerInv.func_70301_a(slotCycleOrder[probidex % slotCycleOrder.length]);
                    if (!empty.func_190926_b()) continue;
                    this.playerInv.func_70299_a(slotCycleOrder[probidex % slotCycleOrder.length], is.func_77979_a(1));
                    any = true;
                    continue block1;
                }
            }
            if (!any) break;
            anyAction = true;
        }
        if (!anyAction) {
            ItemStack swapeh = this.playerInv.func_70301_a(slotCycleOrder[slotCycleOrder.length - 1]);
            for (int i = 0; i < slotCycleOrder.length; ++i) {
                ItemStack here = this.playerInv.func_70301_a(slotCycleOrder[i]);
                this.playerInv.func_70299_a(slotCycleOrder[i], swapeh);
                swapeh = here;
            }
            this.playerInv.func_70299_a(slotCycleOrder[0], swapeh);
        }
    }

    void craftBalance() {
        class Accumulator {
            ItemStack toMatch;
            int stackCount = 0;
            ArrayList<Integer> matchingSlots = new ArrayList(9);

            public Accumulator(ItemStack toMatch, int slot) {
                this.toMatch = toMatch.func_77946_l();
                this.stackCount = toMatch.func_190916_E();
                this.toMatch.func_190920_e(1);
                toMatch.func_190920_e(0);
                this.matchingSlots.add(slot);
            }

            boolean add(ItemStack ta, int slot) {
                if (ItemUtils.canMerge((ItemStack)this.toMatch, (ItemStack)ta)) {
                    this.stackCount += ta.func_190916_E();
                    ta.func_190920_e(0);
                    this.matchingSlots.add(slot);
                    return true;
                }
                return false;
            }
        }
        ArrayList<Accumulator> list = new ArrayList<Accumulator>(9);
        for (Slot s : this.craftingSlots) {
            int slot = s.getSlotIndex();
            ItemStack here = this.playerInv.func_70301_a(slot);
            if (here.func_190926_b()) continue;
            boolean found = false;
            for (Accumulator acc : list) {
                if (!acc.add(here, slot)) continue;
                found = true;
            }
            if (found) continue;
            list.add(new Accumulator(here, slot));
        }
        for (Accumulator acc : list) {
            int delta = acc.stackCount / acc.matchingSlots.size();
            delta = Math.min(delta, 1);
            for (int slot : acc.matchingSlots) {
                if (acc.stackCount <= 0) break;
                this.playerInv.func_70301_a(slot).func_190920_e(delta);
                acc.stackCount -= delta;
            }
            block4: while (acc.stackCount > 0) {
                for (int slot : acc.matchingSlots) {
                    if (acc.stackCount <= 0) continue block4;
                    this.playerInv.func_70301_a(slot).func_190917_f(1);
                    --acc.stackCount;
                }
            }
        }
    }

    void craftFill(int slot) {
        ItemStack toMove = this.playerInv.func_70301_a(slot);
        for (Slot matrixSlot : this.craftingSlots) {
            if (toMove.func_190926_b()) break;
            if (!matrixSlot.func_75211_c().func_190926_b()) continue;
            matrixSlot.func_75215_d(toMove.func_77979_a(1));
        }
        this.playerInv.func_70299_a(slot, toMove.func_190926_b() ? ItemStack.field_190927_a : toMove);
    }

    class RedirectedSlotCrafting
    extends SlotCrafting {
        public RedirectedSlotCrafting(EntityPlayer player, InventoryCrafting craftMatrix, IInventory craftResult, int posX, int posY) {
            super(player, craftMatrix, craftResult, 0, posX, posY);
        }

        public void func_75208_c(ItemStack stack) {
            if (!ContainerPocketTable.this.isCrafting) {
                ContainerPocketTable.this.isCrafting = true;
                ContainerPocketTable.this.movePlayerToMatrix();
                super.func_75208_c(stack);
                ContainerPocketTable.this.copyMatrixToPlayer();
                ContainerPocketTable.this.isCrafting = false;
                ContainerPocketTable.this.func_75142_b();
            } else {
                super.func_75208_c(stack);
            }
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            ContainerPocketTable.this.isCrafting = true;
            ContainerPocketTable.this.movePlayerToMatrix();
            ItemStack stackOut = super.func_190901_a(thePlayer, stack);
            ContainerPocketTable.this.copyMatrixToPlayer();
            ContainerPocketTable.this.updateCraft();
            ContainerPocketTable.this.isCrafting = false;
            ContainerPocketTable.this.func_75142_b();
            return stackOut;
        }
    }
}

