/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.recipe;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldronRecipe;

public class RecipeDyeWater
implements ICauldronRecipe {
    @Override
    public Optional<CauldronContents> apply(ICauldron cauldron, CauldronContents contents) {
        if (!contents.hasFluidStack()) {
            return Optional.empty();
        }
        EnumDyeColor color = ColorUtils.getDyeColor((ItemStack)contents.getHeldItem());
        if (color != null) {
            FluidStack stack = contents.getFluidStack();
            if (Loader.isModLoaded((String)"skyresources") && contents.getSource() != CauldronContents.Source.HAND && stack.getFluid() == FluidRegistry.WATER && contents.getHeldItem().func_77973_b() == Items.field_151100_aR && contents.getHeldItem().func_77952_i() == 4) {
                return Optional.empty();
            }
            if (stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == CharsetCraftingCauldron.dyedWater) {
                FluidStack newStack = CharsetCraftingCauldron.dyedWater.appendDye(stack, color);
                if (newStack == null) {
                    return Optional.of(new CauldronContents((ITextComponent)new TextComponentTranslation("notice.charset.cauldron.no_dye", new Object[0])));
                }
                return Optional.of(new CauldronContents(newStack, ItemStack.field_190927_a));
            }
        }
        return Optional.empty();
    }
}

