/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.recipe;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import pl.asie.charset.lib.material.FastRecipeLookup;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RecipeUtils;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldronRecipe;

public class RecipeDyeItemPure
implements ICauldronRecipe {
    @Override
    public Optional<CauldronContents> apply(ICauldron cauldron, CauldronContents contents) {
        if (!contents.hasFluidStack() || !contents.hasHeldItem()) {
            return Optional.empty();
        }
        FluidStack stack = contents.getFluidStack();
        ItemStack heldItem = contents.getHeldItem();
        if (stack.getFluid() == CharsetCraftingCauldron.dyedWater && stack.tag != null && stack.amount >= 125 && stack.tag.func_150297_b("dyes", 9)) {
            NBTTagList dyes = (NBTTagList)stack.tag.func_74781_a("dyes");
            boolean isImpure = dyes.func_74745_c() > 1;
            ItemStack[] stacks = new ItemStack[9];
            stacks[0] = heldItem.func_77946_l();
            stacks[0].func_190920_e(1);
            for (int i = 1; i <= 8; ++i) {
                if (i == 4) continue;
                stacks[i] = stacks[0];
            }
            stacks[4] = new ItemStack(Items.field_151100_aR, 1, 15 - ((NBTPrimitive)dyes.func_179238_g(0)).func_150290_f());
            ItemStack result = FastRecipeLookup.getCraftingResult((InventoryCrafting)RecipeUtils.getCraftingInventory((int)3, (int)3, (ItemStack[])stacks), (World)cauldron.getCauldronWorld());
            int expectedCount = 8;
            if (result.func_190926_b()) {
                stacks = new ItemStack[2];
                stacks[0] = heldItem.func_77946_l();
                stacks[0].func_190920_e(1);
                stacks[1] = new ItemStack(Items.field_151100_aR, 1, 15 - ((NBTPrimitive)dyes.func_179238_g(0)).func_150290_f());
                result = FastRecipeLookup.getCraftingResult((InventoryCrafting)RecipeUtils.getCraftingInventory((int)2, (int)1, (ItemStack[])stacks), (World)cauldron.getCauldronWorld());
                expectedCount = 1;
            }
            if (!result.func_190926_b() && result.func_190916_E() == expectedCount && !ItemUtils.canMerge((ItemStack)stacks[0], (ItemStack)result)) {
                if (isImpure) {
                    return Optional.empty();
                }
                ItemStack result1 = result.func_77946_l();
                result1.func_190920_e(1);
                return Optional.of(new CauldronContents(new FluidStack(stack, stack.amount - 125), result1));
            }
        }
        return Optional.empty();
    }
}

