/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.fluid;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.lib.IFluidExtraInformation;
import pl.asie.charset.lib.misc.FluidBase;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;

public class FluidPotion
extends FluidBase
implements IFluidExtraInformation {
    public static final ResourceLocation TEXTURE_STILL = new ResourceLocation("charset:blocks/dyed_water_still");
    public static final ResourceLocation TEXTURE_FLOWING = new ResourceLocation("charset:blocks/dyed_water_flow");
    private final String unlName;

    public FluidPotion(String fluidName, String unlName) {
        super(fluidName, TEXTURE_STILL, TEXTURE_FLOWING);
        this.unlName = unlName;
    }

    public String getUnlocalizedName() {
        return this.unlName;
    }

    public static List<PotionEffect> getEffectsFromStack(FluidStack stack) {
        return stack.tag != null ? PotionUtils.func_185185_a((NBTTagCompound)stack.tag) : Collections.emptyList();
    }

    public static PotionType getPotion(FluidStack stack) {
        return PotionUtils.func_185187_c((NBTTagCompound)stack.tag);
    }

    public static void copyFromPotionItem(FluidStack stack, ItemStack itemStack) {
        FluidPotion.setPotion(stack, PotionUtils.func_185187_c((NBTTagCompound)itemStack.func_77978_p()));
        if (stack.tag != null && itemStack.func_77942_o()) {
            if (itemStack.func_77978_p().func_150297_b("CustomPotionColor", 99)) {
                stack.tag.func_74782_a("CustomPotionColor", itemStack.func_77978_p().func_74781_a("CustomPotionColor"));
            }
            if (itemStack.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
                stack.tag.func_74782_a("CustomPotionEffects", itemStack.func_77978_p().func_74781_a("CustomPotionEffects"));
            }
        }
    }

    public static Item getPotionItem(Fluid fluid) {
        if (fluid == CharsetCraftingCauldron.liquidPotion) {
            return Items.field_151068_bn;
        }
        if (fluid == CharsetCraftingCauldron.liquidSplashPotion) {
            return Items.field_185155_bH;
        }
        if (fluid == CharsetCraftingCauldron.liquidLingeringPotion) {
            return Items.field_185156_bI;
        }
        return Items.field_151068_bn;
    }

    public static void copyToPotionItem(ItemStack itemStack, FluidStack stack) {
        if (stack.tag != null) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            if (stack.tag.func_150297_b("Potion", 8)) {
                itemStack.func_77978_p().func_74782_a("Potion", stack.tag.func_74781_a("Potion"));
            }
            if (stack.tag.func_150297_b("CustomPotionColor", 99)) {
                itemStack.func_77978_p().func_74782_a("CustomPotionColor", stack.tag.func_74781_a("CustomPotionColor"));
            }
            if (stack.tag.func_150297_b("CustomPotionEffects", 9)) {
                itemStack.func_77978_p().func_74782_a("CustomPotionEffects", stack.tag.func_74781_a("CustomPotionEffects"));
            }
        }
    }

    public static FluidStack setPotion(FluidStack stack, PotionType potionType) {
        ResourceLocation loc = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)potionType);
        if (potionType == PotionTypes.field_185229_a && stack.tag != null) {
            stack.tag = null;
        } else {
            if (stack.tag == null) {
                stack.tag = new NBTTagCompound();
            }
            stack.tag.func_74778_a("Potion", loc.toString());
        }
        return stack;
    }

    public int getColor(FluidStack stack) {
        if (stack.tag != null && stack.tag.func_150297_b("CustomPotionColor", 99)) {
            return 0xFF000000 | stack.tag.func_74762_e("CustomPotionColor");
        }
        return FluidPotion.getPotion(stack) == PotionTypes.field_185229_a ? -524040 : 0xFF000000 | PotionUtils.func_185181_a(FluidPotion.getEffectsFromStack(stack));
    }

    public void addInformation(FluidStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        itemStack.func_77982_d(stack.tag);
        PotionUtils.func_185182_a((ItemStack)itemStack, tooltip, (float)1.0f);
    }
}

