/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.charset.lib.utils.ProxiedBlockAccess;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.crafting.cauldron.TileCauldronCharset;

public class TileRendererCauldronCharset
extends FastTESR<TileCauldronCharset> {
    private static final BlockModelRenderer renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();

    private static IBlockState getFluidState(FluidStack stack, IBlockState default_state) {
        return stack.getFluid().getBlock() != null ? stack.getFluid().getBlock().func_176223_P() : default_state;
    }

    public void renderTileEntityFast(TileCauldronCharset te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        SimpleBakedModel model;
        BlockPos pos = te.func_174877_v();
        FluidStack contents = te.getContents();
        if (contents == null) {
            return;
        }
        buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        IBlockState state = TileRendererCauldronCharset.getFluidState(contents, Blocks.field_150350_a.func_176223_P());
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = map.getTextureExtry(contents.getFluid().getStill().toString());
        if (sprite == null && (sprite = map.getTextureExtry(TextureMap.field_174945_f.toString())) == null) {
            return;
        }
        float height = te.getFluidHeight();
        SimpleBakedModel smodel = new SimpleBakedModel();
        int color = contents.getFluid().getColor(contents);
        Vector3f from = new Vector3f(2.0f, height, 2.0f);
        Vector3f to = new Vector3f(14.0f, height, 14.0f);
        smodel.addQuad(null, RenderUtils.createQuad((Vector3f)from, (Vector3f)to, (EnumFacing)EnumFacing.UP, (TextureAtlasSprite)sprite, (int)-1));
        if (color == -1) {
            model = smodel;
        } else {
            try {
                model = ModelTransformer.transform((IBakedModel)smodel, (IBlockState)state, (long)0L, (ModelTransformer.IVertexTransformer)new FluidColorTransformer(color));
            }
            catch (ModelTransformer.TransformationFailedException e) {
                model = smodel;
            }
        }
        int light = contents.getFluid().getLuminosity();
        TankBlockAccess tankAccess = new TankBlockAccess((IBlockAccess)te.func_145831_w(), light);
        renderer.func_187493_a((IBlockAccess)tankAccess, (IBakedModel)model, state, pos, buffer, false, 0L);
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private static final class TankBlockAccess
    extends ProxiedBlockAccess {
        private final int fluidLight;

        public TankBlockAccess(IBlockAccess access, int fluidLight) {
            super(access);
            this.fluidLight = fluidLight;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return this.access.func_175626_b(pos, Math.max(this.fluidLight, lightValue));
        }
    }

    private static final class FluidColorTransformer
    implements ModelTransformer.IVertexTransformer {
        private final int color;

        public FluidColorTransformer(int color) {
            this.color = color;
        }

        public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
            if (element.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                for (int i = 0; i < Math.min(data.length, 4); ++i) {
                    data[i] = data[i] * (float)(this.color >> (i < 3 ? 2 - i : i) * 8 & 0xFF) / 255.0f;
                }
            }
            return data;
        }
    }
}

