/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.render.ArrowHighlightHandler;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.barrels.BarrelModel;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.BlockBarrel;
import pl.asie.charset.module.storage.barrels.EntityMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.FixCharsetEmptyUpgradeTagBarrels;
import pl.asie.charset.module.storage.barrels.ItemDayBarrel;
import pl.asie.charset.module.storage.barrels.ItemMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.PacketBarrelCountUpdate;
import pl.asie.charset.module.storage.barrels.RenderMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrelRenderer;

@CharsetModule(name="storage.barrels", description="Simple barrels", profile=ModuleProfile.FORCED)
public class CharsetStorageBarrels {
    public static final List<ItemStack> CREATIVE_BARRELS = Lists.newArrayList();
    public static List<ItemStack> BARRELS = Lists.newArrayList();
    public static List<ItemStack> BARRELS_NORMAL = Lists.newArrayList();
    public static TObjectIntMap<Item> stackDivisorMultiplierMap = new TObjectIntHashMap();
    public static TObjectIntMap<Item> stackSizeMultiplierMap = new TObjectIntHashMap();
    @CharsetModule.Instance
    public static CharsetStorageBarrels instance;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    @CharsetModule.Configuration
    public static Configuration config;
    public static BlockBarrel barrelBlock;
    public static ItemDayBarrel barrelItem;
    public static ItemMinecartDayBarrel barrelCartItem;
    public static boolean renderBarrelText;
    public static boolean renderBarrelItem;
    public static boolean renderBarrelItem3D;
    public static boolean enableSilkyBarrels;
    public static boolean enableStickyBarrels;
    public static boolean enableHoppingBarrels;
    public static int maxDroppedStacks;

    public static boolean isEnabled(BarrelUpgrade upgrade) {
        switch (upgrade) {
            case SILKY: {
                return enableSilkyBarrels;
            }
            case HOPPING: {
                return enableHoppingBarrels;
            }
            case STICKY: {
                return enableStickyBarrels;
            }
        }
        return true;
    }

    @Mod.EventHandler
    public void reloadReentrantConfig(CharsetLoadConfigEvent event) {
        enableSilkyBarrels = ConfigUtils.getBoolean((Configuration)config, (String)"features", (String)"enableSilkyBarrels", (!ModCharset.isModuleLoaded((String)"tweak.blockCarrying") ? 1 : 0) != 0, (String)"Enable silky barrels. On by default unless tweak.blockCarrying is also present.", (boolean)true);
        enableHoppingBarrels = ConfigUtils.getBoolean((Configuration)config, (String)"features", (String)"enableHoppingBarrels", (boolean)true, (String)"Enable hopping barrels. On by default.", (boolean)true);
        enableStickyBarrels = ConfigUtils.getBoolean((Configuration)config, (String)"features", (String)"enableStickyBarrels", (boolean)true, (String)"Enable sticky barrels. On by default.", (boolean)true);
        maxDroppedStacks = ConfigUtils.getInt((Configuration)config, (String)"general", (String)"maxDroppedStacks", (int)1024, (int)0, (int)0x1FFFFFF, (String)"The maximum amount of stacks to be dropped when a barrel is broken.", (boolean)true);
        renderBarrelItem3D = ConfigUtils.getBoolean((Configuration)config, (String)"render", (String)"renderItem3D", (boolean)false, (String)"Should items use fancy 3D rendering?", (boolean)false);
        renderBarrelItem = ConfigUtils.getBoolean((Configuration)config, (String)"render", (String)"renderItem", (boolean)true, (String)"Should items be rendered on barrels?", (boolean)false);
        renderBarrelText = ConfigUtils.getBoolean((Configuration)config, (String)"render", (String)"renderText", (boolean)true, (String)"Should text be rendered on barrels?", (boolean)false);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        barrelBlock = new BlockBarrel();
        barrelItem = new ItemDayBarrel(barrelBlock);
        barrelCartItem = new ItemMinecartDayBarrel();
        barrelBlock.setHarvestLevel("axe", 0);
        ModCharset.dataFixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FixCharsetEmptyUpgradeTagBarrels());
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)barrelItem, (int)0, (String)"charset:barrel");
        RegistryUtils.registerModel((Item)barrelCartItem, (int)0, (String)"charset:barrelCart");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)barrelBlock, (String)"barrel");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)barrelItem, (String)"barrel");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)barrelCartItem, (String)"barrelCart");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityDayBarrel.class, (String)"charset:barrel");
        RegistryUtils.register(EntityMinecartDayBarrel.class, (String)"barrelCart", (int)80, (int)3, (boolean)true);
        packet.registerPacket(1, PacketBarrelCountUpdate.class);
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)barrelBlock.getRegistryName());
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        CREATIVE_BARRELS.add(TileEntityDayBarrel.makeBarrel(EnumSet.of(BarrelUpgrade.HOPPING, BarrelUpgrade.INFINITE), ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(new ItemStack(Blocks.field_150357_h)), ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(new ItemStack(Blocks.field_150484_ah))));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.populateBarrelStackLists();
    }

    private void populateBarrelStackLists() {
        BARRELS_NORMAL.clear();
        BARRELS = barrelBlock.getSubItemProvider().getAllItems();
        for (ItemStack is : BARRELS) {
            EnumSet<BarrelUpgrade> upgradeSet = EnumSet.noneOf(BarrelUpgrade.class);
            TileEntityDayBarrel.populateUpgrades(upgradeSet, is.func_77978_p());
            if (!upgradeSet.isEmpty()) continue;
            BARRELS_NORMAL.add(is);
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartDayBarrel.class, RenderMinecartDayBarrel::new);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDayBarrel.class, (TileEntitySpecialRenderer)new TileEntityDayBarrelRenderer());
        ArrowHighlightHandler.register((Item[])new Item[]{barrelItem});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerColorBlock(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(BarrelModel.INSTANCE.colorizer, new Block[]{barrelBlock});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerColorItem(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a(BarrelModel.INSTANCE.colorizer, new Item[]{barrelItem});
        event.getItemColors().func_186730_a((IItemColor)new ItemMinecartDayBarrel.Color(), new Item[]{barrelCartItem});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureMap(TextureStitchEvent.Pre event) {
        BarrelModel.INSTANCE.onTextureLoad(event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:barrel", "normal"), (Object)BarrelModel.INSTANCE);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:barrel", "inventory"), (Object)BarrelModel.INSTANCE);
        BarrelModel.INSTANCE.template = RenderUtils.getModel((ResourceLocation)new ResourceLocation("charset:block/barrel"));
    }
}

