/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.items.weapons.ItemMusket;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;

public class ItemMusketWithBayonet
extends ItemMusket {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemMusketWithBayonet(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemMusketWithBayonet(Item.ToolMaterial material, boolean unbreakable) {
        this.unbreakable = unbreakable;
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77655_b(this.materialDefinition.getPrefixedName("musket"));
    }

    @Override
    public float getHitDamage() {
        return super.getHitDamage() + this.getKnife().getHitDamage();
    }

    public ItemExtension getKnife() {
        switch (this.materialDefinition.getPrefix()) {
            case "wooden": {
                return (ItemExtension)ReforgedAdditions.WOODEN_KNIFE;
            }
            case "stone": {
                return (ItemExtension)ReforgedAdditions.STONE_KNIFE;
            }
            case "golden": {
                return (ItemExtension)ReforgedAdditions.GOLDEN_KNIFE;
            }
            case "iron": {
                return (ItemExtension)ReforgedAdditions.IRON_KNIFE;
            }
            case "diamond": {
                return (ItemExtension)ReforgedAdditions.DIAMOND_KNIFE;
            }
        }
        if (MaterialManager.isFullyAdded(this.materialDefinition.getMaterial())) {
            return (ItemExtension)MaterialManager.getItems(this.materialDefinition.getMaterial())[0];
        }
        throw new IllegalArgumentException("The ToolMaterial called " + this.materialDefinition.getPrefix() + " couldn't be found");
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }
}

