/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.IZombieEquippable;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;

public class ItemKatana
extends ItemSword
implements ItemExtension,
IZombieEquippable {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemKatana(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemKatana(Item.ToolMaterial material, boolean unbreakable) {
        super(material);
        this.unbreakable = unbreakable;
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77655_b(this.materialDefinition.getPrefixedName("katana"));
        this.func_77656_e(this.materialDefinition.getMaxUses());
        this.func_77625_d(1);
        this.func_77637_a(ReforgedMod.tabReforged);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    @Override
    public float getHitDamage() {
        return this.materialDefinition.getDamageVsEntity() + 4.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public Item.ToolMaterial getMaterial() {
        return this.materialDefinition.getMaterial();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        int armorvalue = 0;
        for (int i = 3; i < 6; ++i) {
            ItemStack armorStack = target.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (armorStack.func_190926_b() || !(armorStack.func_77973_b() instanceof ItemArmor)) continue;
            armorvalue += ((ItemArmor)armorStack.func_77973_b()).field_77879_b;
        }
        if (armorvalue < 12) {
            target.field_70172_ad = 0;
            target.func_70097_a(this.getDamage(attacker), this.getHitDamage() / 2.0f);
        }
        if (armorvalue > 6 && stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(2, target);
        }
        if (stack.func_190916_E() >= 1 && stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (stack.func_77973_b().func_77645_m() && (double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    @Override
    public float zombieSpawnChance() {
        switch (this.materialDefinition.getMaterial()) {
            case GOLD: {
                return 1.0f;
            }
            case IRON: {
                return 2.0f;
            }
            case STONE: {
                return 3.0f;
            }
            case WOOD: {
                return 4.0f;
            }
        }
        return 0.0f;
    }
}

