/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.silvercatcher.reforged.api.AReloadable;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.entities.EntityCrossbowBolt;

public class ItemCrossbow
extends AReloadable {
    public ItemCrossbow() {
        super("crossbow", "crossbow_shoot", "crossbow_reload");
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                int reloadTime = CompoundTags.giveCompound(stack).func_74762_e("time");
                if (reloadTime <= 0) {
                    return 0.0f;
                }
                int reloadTimeLeft = ItemCrossbow.this.getReloadTotal() - reloadTime;
                if (reloadTimeLeft > 14) {
                    return 1.0f;
                }
                if (reloadTimeLeft > 9) {
                    return 2.0f;
                }
                if (reloadTimeLeft > 4) {
                    return 4.0f;
                }
                if (reloadTimeLeft > 0) {
                    return 5.0f;
                }
                return 3.0f;
            }
        });
    }

    @Override
    public float getHitDamage() {
        return 2.0f;
    }

    @Override
    public int getReloadTotal() {
        return 20;
    }

    @Override
    public Item getAmmo() {
        return ReforgedAdditions.CROSSBOW_BOLT;
    }

    @Override
    public void shoot(World worldIn, EntityLivingBase playerIn, ItemStack stack) {
        EntityCrossbowBolt a = new EntityCrossbowBolt(worldIn, playerIn);
        a.setAim((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, ItemBow.func_185059_b((int)40) * 3.0f, 1.0f);
        a.pickupStatus = EntityArrow.PickupStatus.func_188795_a((int)new Random().nextInt(2));
        a.setDamage(8.0);
        worldIn.func_72838_d((Entity)a);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !slotChanged;
    }
}

