/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.api.AReforgedThrowable;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.items.weapons.ItemJavelin;
import org.silvercatcher.reforged.util.Helpers;

public class EntityJavelin
extends AReforgedThrowable {
    public static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityJavelin.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntityJavelin.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityJavelin(World worldIn) {
        super(worldIn, "javelin");
    }

    public EntityJavelin(World worldIn, EntityLivingBase throwerIn, ItemStack stack, int durationLoaded) {
        super(worldIn, throwerIn, "javelin");
        this.setItemStack(stack);
        this.setDurLoaded(durationLoaded);
        if (durationLoaded < 20) {
            durationLoaded = 20;
        } else if (durationLoaded > 40) {
            durationLoaded = 40;
        }
        this.field_70159_w *= (double)durationLoaded / 20.0;
        this.field_70181_x *= (double)durationLoaded / 20.0;
        this.field_70179_y *= (double)durationLoaded / 20.0;
        this.setInited();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)new ItemStack(ReforgedAdditions.JAVELIN));
        this.field_70180_af.func_187214_a(DURATION, (Object)1);
    }

    public int getDurLoaded() {
        return (Integer)this.field_70180_af.func_187225_a(DURATION);
    }

    @Override
    protected float func_70185_h() {
        return 0.03f;
    }

    @Override
    protected float getImpactDamage(Entity target) {
        return 5.0f + (float)this.getDurLoaded() / 10.0f;
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    @Override
    protected boolean onBlockHit(BlockPos blockPos) {
        ItemStack stack = this.getItemStack();
        if (!stack.func_96631_a(1, this.field_70146_Z, null)) {
            this.setItemStack(stack);
        }
        if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() > 0) {
            if (!this.creativeUse()) {
                this.func_70099_a(this.getItemStack(), 0.5f);
            }
        } else {
            Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(Entity entity) {
        entity.func_70097_a(this.causeImpactDamage(entity, this.func_85052_h()), this.getImpactDamage(entity));
        ItemStack stack = this.getItemStack();
        if (!stack.func_96631_a(1, this.field_70146_Z, null)) {
            this.setItemStack(stack);
        }
        if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() > 0) {
            if (!this.creativeUse()) {
                this.func_70099_a(this.getItemStack(), 0.5f);
            }
        } else {
            Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70128_L) {
            super.func_70071_h_();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setDurLoaded(tagCompund.func_74762_e("durloaded"));
        this.setItemStack(new ItemStack(tagCompund.func_74775_l("item")));
    }

    public void setDurLoaded(int durloaded) {
        this.field_70180_af.func_187227_b(DURATION, (Object)durloaded);
    }

    public void setItemStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemJavelin)) {
            throw new IllegalArgumentException("Invalid Itemstack!");
        }
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("durloaded", this.getDurLoaded());
        if (this.getItemStack() != null && !this.getItemStack().func_190926_b()) {
            tagCompound.func_74782_a("item", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }
}

