/*
 * Decompiled with CFR 0.152.
 */
package xjon.jexclusives.util;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import xjon.jexclusives.util.BlockCoord;
import xjon.jexclusives.util.JEConfiguration;

public class Firework {
    private static final Random rand = new Random();

    public static void Fireworks(boolean enabled, BlockCoord pos, int dimId) {
        if (enabled && !JEConfiguration.specialLoginsFireworksDisabled) {
            Firework.spawnFirework(pos, dimId);
        }
    }

    public static EntityFireworkRocket getRandomFirework(World world) {
        return Firework.getRandomFirework(world, new BlockCoord(0, 0, 0));
    }

    public static EntityFireworkRocket getRandomFirework(World world, BlockCoord pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(new NBTTagCompound());
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77978_p().func_74782_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, firework);
        return e;
    }

    public static void spawnFirework(BlockCoord block, int dimID) {
        Firework.spawnFirework(block, dimID, 0);
    }

    public static void spawnFirework(BlockCoord block, int dimID, int range) {
        WorldServer world = DimensionManager.getWorld((int)dimID);
        BlockPos pos = new BlockPos(block.x, block.y, block.z);
        IBlockState bs = world.func_180495_p(pos);
        if (range > 0) {
            pos = new BlockPos(Firework.moveRandomly(block.x, range), (double)block.y, Firework.moveRandomly(block.z, range));
            int tries = -1;
            while (!world.func_175623_d(new BlockPos((Vec3i)pos)) && !bs.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_72838_d((Entity)Firework.getRandomFirework((World)world, new BlockCoord(pos)));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }
}

