/*
 * Decompiled with CFR 0.152.
 */
package xjon.jexclusives.event;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xjon.jexclusives.util.BlockCoord;
import xjon.jexclusives.util.Firework;
import xjon.jexclusives.util.JEConfiguration;
import xjon.jexclusives.util.Log;
import xjon.jexclusives.util.UrlValidator;

public class PlayerEvents {
    private static int mode = -1;
    private static int downloadsMilestone = -1;
    private static int upToDownloads = -1;
    private static int currentDownloadAmount = -1;
    private static boolean fireworksEnabled = false;
    private static String message = "";

    private static String formatNumber(int number) {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        return formatter.format(number);
    }

    public static void fetchData() {
        Thread thread = new Thread(() -> {
            try {
                if (!JEConfiguration.specialLoginsDisabled) {
                    String remoteConfigUrl = JEConfiguration.urlForRemoteConfigs;
                    String technicApiUrl = "http://api.technicpack.net/launcher/version/stable4";
                    if (remoteConfigUrl != null && !remoteConfigUrl.isEmpty()) {
                        if (UrlValidator.isUrlValid(remoteConfigUrl)) {
                            PackJson remoteConfigs = (PackJson)new Gson().fromJson(Resources.toString((URL)new URL(remoteConfigUrl), (Charset)Charsets.UTF_8), PackJson.class);
                            if (remoteConfigs.enabled) {
                                message = remoteConfigs.message;
                                fireworksEnabled = remoteConfigs.fireworks;
                                mode = remoteConfigs.mode;
                                if (remoteConfigs.mode == 1 || remoteConfigs.mode == 3) {
                                    if (!JEConfiguration.customModpackSlug.isEmpty() && UrlValidator.isUrlValid(technicApiUrl)) {
                                        TechnicApiData technicApiData = (TechnicApiData)new Gson().fromJson(Resources.toString((URL)new URL(technicApiUrl), (Charset)Charsets.UTF_8), TechnicApiData.class);
                                        TechnicModpackApiData packData = (TechnicModpackApiData)new Gson().fromJson(Resources.toString((URL)new URL("http://api.technicpack.net/modpack/" + JEConfiguration.customModpackSlug + "?build=" + technicApiData.build), (Charset)Charsets.UTF_8), TechnicModpackApiData.class);
                                        currentDownloadAmount = packData.installs;
                                        downloadsMilestone = remoteConfigs.x;
                                        upToDownloads = remoteConfigs.y;
                                    } else {
                                        Log.error("Either Technic's API is down, or Jon's Exclusives' remote config's mode is set to 1 (for Technic packs only) while local configs are set to non-Technic packs");
                                    }
                                }
                            }
                        } else {
                            Log.error("Login events were not activated as the remote config URL is invalid");
                        }
                    } else {
                        Log.warn("Login events were not activated as the remote config URL is missing");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        switch (mode) {
            case 0: {
                event.player.func_145747_a((ITextComponent)new TextComponentString(message));
                Firework.Fireworks(fireworksEnabled, new BlockCoord((Entity)event.player), event.player.field_71093_bK);
                break;
            }
            case 1: {
                if (currentDownloadAmount <= downloadsMilestone || currentDownloadAmount >= upToDownloads) break;
                event.player.func_145747_a((ITextComponent)new TextComponentString(message + "Thank you for " + PlayerEvents.formatNumber(downloadsMilestone) + " downloads!"));
                Firework.Fireworks(fireworksEnabled, new BlockCoord((Entity)event.player), event.player.field_71093_bK);
                break;
            }
            case 2: {
                event.player.func_145747_a((ITextComponent)new TextComponentString(message + event.player.func_70005_c_() + ", have fun playing!"));
                Firework.Fireworks(fireworksEnabled, new BlockCoord((Entity)event.player), event.player.field_71093_bK);
                break;
            }
            case 3: {
                if (currentDownloadAmount % downloadsMilestone <= upToDownloads) {
                    int roundedDownloadsMilestone = currentDownloadAmount / downloadsMilestone * downloadsMilestone;
                    event.player.func_145747_a((ITextComponent)new TextComponentString(message + "Thank you for " + PlayerEvents.formatNumber(roundedDownloadsMilestone) + " downloads!"));
                    Firework.Fireworks(fireworksEnabled, new BlockCoord((Entity)event.player), event.player.field_71093_bK);
                    break;
                }
                event.player.func_145747_a((ITextComponent)new TextComponentString(message + event.player.func_70005_c_() + ", have fun playing!"));
                break;
            }
        }
    }

    static class TechnicModpackApiData {
        int installs;

        TechnicModpackApiData() {
        }
    }

    static class TechnicApiData {
        int build;

        TechnicApiData() {
        }
    }

    public static class PackJson {
        public String capeurl;
        boolean enabled;
        String message;
        boolean fireworks;
        int mode;
        int x;
        int y;
    }
}

