/*
 * Decompiled with CFR 0.152.
 */
package xjon.developercapes.user;

import java.util.Collection;
import java.util.HashMap;
import xjon.developercapes.DevCapes;
import xjon.developercapes.cape.CapeManager;
import xjon.developercapes.cape.ICape;
import xjon.developercapes.user.User;

public class UserManager {
    protected static UserManager instance;
    protected HashMap<String, User> users = new HashMap();

    public static UserManager getInstance() {
        if (instance == null) {
            instance = new UserManager();
        }
        return instance;
    }

    public User getUser(String userUUID) {
        return this.users.get(userUUID);
    }

    public void addUser(User user) throws NullPointerException {
        if (user == null || user.userUUID == null || user.userUUID.isEmpty()) {
            throw new NullPointerException("Cannot add a null user!");
        }
        this.users.put(user.userUUID, user);
        CapeManager.getInstance().addCapes(user.capes);
    }

    public void addUsers(Collection<User> users) throws NullPointerException {
        for (User u : users) {
            this.addUser(u);
        }
    }

    public User newUser(String username) {
        User user = null;
        if (this.users.containsKey(username)) {
            user = this.getUser(username);
        } else {
            user = new User(username);
            this.users.put(username, user);
        }
        return user;
    }

    public User parse(String user, Object cape) {
        ICape capeInstance;
        User userInstance = new User(user);
        ICape iCape = capeInstance = cape instanceof ICape ? (ICape)cape : CapeManager.getInstance().parse(user, (Object)cape.toString());
        if (capeInstance != null) {
            userInstance.capes.add(capeInstance);
        } else {
            DevCapes.logger.error(String.format("Error parsing cape, %s", cape.toString()));
        }
        return userInstance;
    }
}

