/*
 * Decompiled with CFR 0.152.
 */
package zzzank.mod.jei_area_fixer.debug;

import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import zzzank.mod.jei_area_fixer.JEIAreaFixerConfig;
import zzzank.mod.jei_area_fixer.debug.JEIAreaFixerDebug;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="jei_area_fixer")
public class JEIAreaFixerDebugAction {
    private static final Map<Class<? extends GuiContainer>, List<Rectangle>> lastBounds = new IdentityHashMap<Class<? extends GuiContainer>, List<Rectangle>>();

    public static void print() {
        if (!JEIAreaFixerConfig.debug$print || JEIAreaFixerDebug.boundsMap.isEmpty()) {
            return;
        }
        StringJoiner joiner = new StringJoiner("\n");
        for (Map.Entry<Class<? extends GuiContainer>, List<Rectangle>> e : JEIAreaFixerDebug.boundsMap.entrySet()) {
            Class<? extends GuiContainer> key = e.getKey();
            List<Rectangle> value = e.getValue();
            if (value.equals(lastBounds.get(key))) continue;
            lastBounds.put(key, value);
            joiner.add(String.format("class '%s' with new bounds: %s", e.getKey(), e.getValue().stream().map(bound -> new StringBuilder(40).append("[x: ").append(bound.x).append(", y: ").append(bound.y).append(", width: ").append(bound.width).append(", height: ").append(bound.height).append("]").toString()).collect(Collectors.joining(", "))));
        }
        if (joiner.length() == 0) {
            return;
        }
        System.out.println("debug output from JEI Area Fixer\n" + joiner);
    }

    @SubscribeEvent
    public static void drawing(GuiContainerEvent.DrawForeground event) {
        if (!JEIAreaFixerConfig.debug$drawing) {
            return;
        }
        GuiContainer guiContainer = event.getGuiContainer();
        Class<?> guiClass = guiContainer.getClass();
        for (Map.Entry<Class<? extends GuiContainer>, List<Rectangle>> e : JEIAreaFixerDebug.boundsMap.entrySet()) {
            if (!e.getKey().isAssignableFrom(guiClass)) continue;
            List<Rectangle> bounds = e.getValue();
            for (Rectangle bound : bounds) {
                Gui.func_73734_a((int)(bound.x - guiContainer.getGuiLeft()), (int)(bound.y - guiContainer.getGuiTop()), (int)(bound.x + bound.width - guiContainer.getGuiLeft()), (int)(bound.y + bound.height - guiContainer.getGuiTop()), (int)2134993377);
            }
        }
    }
}

