/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.smoothscrollingeverywhere.mixin;

import me.shedaniel.smoothscrollingeverywhere.SmoothScrollingEverywhere;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiScrollingList.class})
public abstract class MixinGuiScrollingList {
    @Shadow(remap=false)
    @Final
    protected int bottom;
    @Shadow(remap=false)
    @Final
    protected int top;
    @Unique
    protected float target;
    @Unique
    protected long start;
    @Unique
    protected long duration;
    @Shadow(remap=false)
    @Final
    protected int left;
    @Shadow(remap=false)
    @Final
    protected int listWidth;
    @Shadow(remap=false)
    private float scrollDistance;
    @Unique
    protected int lastContentHeight = -1;
    @Shadow
    @Final
    private Minecraft client;

    @Shadow(remap=false)
    protected abstract int getContentHeight();

    @Shadow(remap=false)
    protected abstract void drawScreen(int var1, int var2);

    @Unique
    private int func_148135_f() {
        int max = this.getContentHeight() - (this.bottom - this.top) + 4;
        if (max < 0) {
            max /= 2;
        }
        return max;
    }

    @Redirect(method={"handleMouseInput(II)V"}, at=@At(value="INVOKE", target="Lorg/lwjgl/input/Mouse;getEventDWheel()I", ordinal=0, remap=false), remap=false)
    public int getEventDWheel(int mouseX, int mouseY) {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            if (wheel > 0) {
                wheel = -1;
            } else if (wheel < 0) {
                wheel = 1;
            }
            this.offset(SmoothScrollingEverywhere.getScrollStep() * (float)wheel, true);
        }
        return 0;
    }

    @Unique
    public void offset(float value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    @Unique
    public void scrollTo(float value, boolean animated) {
        this.scrollTo(value, animated, SmoothScrollingEverywhere.getScrollDuration());
    }

    @Unique
    public void scrollTo(float value, boolean animated, long duration) {
        this.target = SmoothScrollingEverywhere.clamp(value, this.func_148135_f());
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scrollDistance = this.target;
        }
    }

    @Redirect(method={"drawScreen(IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/client/GuiScrollingList;applyScrollLimits()V", remap=false), remap=false)
    public void bindScrollDistance(GuiScrollingList guiSlot) {
        if (Mouse.isButtonDown((int)0)) {
            this.target = this.scrollDistance = SmoothScrollingEverywhere.clamp(this.scrollDistance, this.func_148135_f(), 0.0f);
        }
    }

    @Inject(method={"drawScreen(IIF)V"}, at={@At(value="HEAD")}, remap=false)
    public void render(int int_1, int int_2, float delta, CallbackInfo callbackInfo) {
        float[] target = new float[]{this.target};
        this.scrollDistance = SmoothScrollingEverywhere.handleScrollingPosition(target, this.scrollDistance, this.func_148135_f(), 20.0f / (float)Minecraft.func_175610_ah(), this.start, this.duration);
        this.target = target[0];
        if (this.lastContentHeight != this.getContentHeight()) {
            if (this.lastContentHeight != -1) {
                this.scrollDistance = this.target = SmoothScrollingEverywhere.clamp(this.target, this.func_148135_f(), 0.0f);
            }
            this.lastContentHeight = this.getContentHeight();
        }
    }

    @Inject(method={"drawScreen(IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/client/GuiScrollingList;getContentHeight()I", ordinal=2, shift=At.Shift.AFTER, remap=false)}, cancellable=true, remap=false)
    public void renderScrollbar(int int_1, int int_2, float float_1, CallbackInfo callbackInfo) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int scrollbarPositionMaxX = this.left + this.listWidth;
        int scrollbarPositionMinX = scrollbarPositionMaxX - 6;
        int maxScroll = this.func_148135_f();
        if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            height = MathHelper.func_76125_a((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)this.scrollDistance < 0.0 ? (double)((int)(-this.scrollDistance)) : (double)((double)this.scrollDistance > (double)this.func_148135_f() ? (int)this.scrollDistance - this.func_148135_f() : 0), (double)height * 0.75));
            int minY = Math.min(Math.max((int)this.scrollDistance * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            GlStateManager.func_179090_x();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(minY + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)minY, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)minY, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)minY, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.drawScreen(int_1, int_2);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
        callbackInfo.cancel();
    }
}

