/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.config.Config;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ErrorUtil {
    @Nullable
    private static IModIdHelper modIdHelper;

    private ErrorUtil() {
    }

    public static void setModIdHelper(IModIdHelper modIdHelper) {
        ErrorUtil.modIdHelper = modIdHelper;
    }

    public static <T> String getInfoFromRecipe(T recipe, IRecipeWrapper recipeWrapper) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        String recipeName = ErrorUtil.getNameForRecipe(recipe);
        recipeInfoBuilder.append(recipeName);
        Ingredients ingredients = new Ingredients();
        try {
            recipeWrapper.getIngredients(ingredients);
        }
        catch (LinkageError | RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutputs:");
        Set<IIngredientType> outputTypes = ingredients.getOutputIngredients().keySet();
        for (IIngredientType outputType : outputTypes) {
            List<String> ingredientOutputInfo = ErrorUtil.getIngredientOutputInfo(outputType, ingredients);
            recipeInfoBuilder.append('\n').append(outputType.getIngredientClass().getName()).append(": ").append(ingredientOutputInfo);
        }
        recipeInfoBuilder.append("\nInputs:");
        Set<IIngredientType> inputTypes = ingredients.getInputIngredients().keySet();
        for (IIngredientType inputType : inputTypes) {
            List<String> ingredientInputInfo = ErrorUtil.getIngredientInputInfo(inputType, ingredients);
            recipeInfoBuilder.append('\n').append(inputType.getIngredientClass().getName()).append(": ").append(ingredientInputInfo);
        }
        return recipeInfoBuilder.toString();
    }

    private static <T> List<String> getIngredientOutputInfo(IIngredientType<T> ingredientType, IIngredients ingredients) {
        List<List<T>> outputs = ingredients.getOutputs(ingredientType);
        return ErrorUtil.getIngredientInfo(ingredientType, outputs);
    }

    private static <T> List<String> getIngredientInputInfo(IIngredientType<T> ingredientType, IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(ingredientType);
        return ErrorUtil.getIngredientInfo(ingredientType, inputs);
    }

    public static String getNameForRecipe(Object recipe) {
        IForgeRegistryEntry registryEntry;
        ResourceLocation registryName;
        if (recipe instanceof IForgeRegistryEntry && (registryName = (registryEntry = (IForgeRegistryEntry)recipe).getRegistryName()) != null) {
            if (modIdHelper != null) {
                String modId = registryName.func_110624_b();
                String modName = modIdHelper.getModNameForModId(modId);
                return modName + " " + registryName + " " + recipe.getClass();
            }
            return registryName + " " + recipe.getClass();
        }
        try {
            return recipe.toString();
        }
        catch (RuntimeException e) {
            Log.get().error("Failed recipe.toString", (Throwable)e);
            return recipe.getClass().toString();
        }
    }

    public static <T> String getInfoFromBrokenCraftingRecipe(T recipe, List inputs, ItemStack output) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        String recipeName = ErrorUtil.getNameForRecipe(recipe);
        recipeInfoBuilder.append(recipeName);
        recipeInfoBuilder.append("\nOutputs:");
        List<List<ItemStack>> outputs = Collections.singletonList(Collections.singletonList(output));
        List<String> ingredientOutputInfo = ErrorUtil.getIngredientInfo(VanillaTypes.ITEM, outputs);
        recipeInfoBuilder.append('\n').append(ItemStack.class.getName()).append(": ").append(ingredientOutputInfo);
        recipeInfoBuilder.append("\nInputs:");
        List<List<ItemStack>> inputLists = Internal.getStackHelper().expandRecipeItemStackInputs(inputs, false);
        List<String> ingredientInputInfo = ErrorUtil.getIngredientInfo(VanillaTypes.ITEM, inputLists);
        recipeInfoBuilder.append('\n').append(ItemStack.class.getName()).append(": ").append(ingredientInputInfo);
        return recipeInfoBuilder.toString();
    }

    public static <T> String getIngredientInfo(T ingredient) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredient);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static <T> List<String> getIngredientInfo(IIngredientType<T> ingredientType, List<? extends List<T>> ingredients) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredientType);
        ArrayList<String> allInfos = new ArrayList<String>(ingredients.size());
        for (List<T> inputList : ingredients) {
            ArrayList<String> infos = new ArrayList<String>(inputList.size());
            for (T input : inputList) {
                String errorInfo = ingredientHelper.getErrorInfo(input);
                infos.add(errorInfo);
            }
            allInfos.add(((Object)infos).toString());
        }
        return allInfos;
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        String itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof ItemBlock) {
            ResourceLocation blockRegistryName;
            Block block = ((ItemBlock)item).func_179223_d();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "ItemBlock(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(@Nullable String string, String name) {
        if (string == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(@Nullable T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(@Nullable Collection values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> T checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        return object;
    }

    public static <T> void checkIsValidIngredient(@Nullable T ingredient, String name) {
        ErrorUtil.checkNotNull(ingredient, name);
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredient);
        if (!ingredientHelper.isValidIngredient(ingredient)) {
            String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
            throw new IllegalArgumentException("Invalid ingredient found. Parameter Name: " + name + " Ingredient Info: " + ingredientInfo);
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && !minecraft.func_152345_ab()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A HEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> ReportedException createRenderIngredientException(Throwable throwable, T ingredient) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType ingredientType = ingredientRegistry.getIngredientType(ingredient);
        IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory ingredientCategory = crashreport.func_85058_a("Ingredient being rendered");
        if (modIdHelper != null) {
            ingredientCategory.func_189529_a("Mod Name", () -> {
                String modId = ingredientHelper.getDisplayModId(ingredient);
                return modIdHelper.getModNameForModId(modId);
            });
        }
        ingredientCategory.func_189529_a("Registry Name", () -> {
            String modId = ingredientHelper.getModId(ingredient);
            String resourceId = ingredientHelper.getResourceId(ingredient);
            return modId + ":" + resourceId;
        });
        ingredientCategory.func_189529_a("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
        ingredientCategory.func_189529_a("String Name", ingredient::toString);
        CrashReportCategory jeiCategory = crashreport.func_85058_a("HEI render details");
        jeiCategory.func_189529_a("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient));
        jeiCategory.func_189529_a("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
        jeiCategory.func_189529_a("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        jeiCategory.func_189529_a("Filter Text", Config::getFilterText);
        jeiCategory.func_189529_a("Edit Mode Enabled", () -> Boolean.toString(Config.isEditModeEnabled()));
        jeiCategory.func_189529_a("Debug Mode Enabled", () -> Boolean.toString(Config.isDebugModeEnabled()));
        throw new ReportedException(crashreport);
    }
}

