/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.hooklib.minecraft;

import com.zuxelus.hooklib.asm.AsmHook;
import com.zuxelus.hooklib.asm.ClassMetadataReader;
import com.zuxelus.hooklib.asm.HookClassTransformer;
import com.zuxelus.hooklib.minecraft.DeobfuscationMetadataReader;
import com.zuxelus.hooklib.minecraft.HookLibPlugin;
import com.zuxelus.hooklib.minecraft.MinecraftClassTransformer;
import com.zuxelus.hooklib.minecraft.PrimaryClassTransformer;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

public abstract class HookLoader
implements IFMLLoadingPlugin {
    private static Optional<DeobfuscationTransformer> deobfuscationTransformer = Optional.empty();
    private static ClassMetadataReader deobfuscationMetadataReader = new DeobfuscationMetadataReader();

    static Optional<DeobfuscationTransformer> deobfuscationTransformer() {
        if (HookLibPlugin.getObfuscated() && !deobfuscationTransformer.isPresent()) {
            deobfuscationTransformer = Optional.of(new DeobfuscationTransformer());
        }
        return deobfuscationTransformer;
    }

    public static HookClassTransformer getTransformer() {
        return PrimaryClassTransformer.instance.registeredSecondTransformer ? MinecraftClassTransformer.instance : PrimaryClassTransformer.instance;
    }

    public static void registerHook(AsmHook hook) {
        HookLoader.getTransformer().registerHook(hook);
    }

    public static void registerHookContainer(String className) {
        HookLoader.getTransformer().registerHookContainer(className);
    }

    public static ClassMetadataReader getDeobfuscationMetadataReader() {
        return deobfuscationMetadataReader;
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        this.registerHooks();
    }

    protected abstract void registerHooks();
}

