/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import cofh.core.block.TileNameable;
import cofh.core.block.TilePowered;
import cofh.core.fluid.FluidTankCore;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyStorage;
import cofh.thermalexpansion.block.device.TileFluidBuffer;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.machine.TileBrewer;
import cofh.thermalexpansion.block.machine.TileInsolator;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.block.machine.TileSmelter;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.item.ItemAugment;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.hooks.ThermalExpansionHooks;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardThermalExpansion;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.items.kits.ItemKitThermalExpansion;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.IFluidTank;

public class CrossThermalExpansion
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TilePowered) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = ((TilePowered)te).getEnergyStorage();
            if (storage != null) {
                tag.func_74778_a("euType", "RF");
                tag.func_74780_a("energy", (double)storage.getEnergyStored());
                tag.func_74780_a("capacity", (double)storage.getMaxEnergyStored());
                return tag;
            }
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        FluidTankCore tank;
        FluidTankCore tank1;
        FluidTankCore tank0;
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileDynamoCompression) {
            tank0 = ((TileDynamoCompression)te).getTank(0);
            tank1 = ((TileDynamoCompression)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileDynamoMagmatic) {
            tank0 = ((TileDynamoMagmatic)te).getTank(0);
            tank1 = ((TileDynamoMagmatic)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileRefinery) {
            tank0 = ((TileRefinery)te).getTank(0);
            tank1 = ((TileRefinery)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileBrewer) {
            tank0 = ((TileBrewer)te).getTank(0);
            tank1 = ((TileBrewer)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileFluidBuffer) {
            tank0 = ((TileFluidBuffer)te).getTank(0);
            tank1 = ((TileFluidBuffer)te).getTank(1);
            FluidTankCore tank2 = ((TileFluidBuffer)te).getTank(2);
            if (tank0 != null && tank1 != null && tank2 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                result.add(new FluidInfo((IFluidTank)tank2));
                return result;
            }
        }
        if (te instanceof TileNameable && (tank = ((TileNameable)te).getTank()) != null) {
            result.add(new FluidInfo((IFluidTank)tank));
            return result;
        }
        if (te instanceof TileDynamoBase && (tank = ((TileDynamoBase)te).getTank(0)) != null) {
            result.add(new FluidInfo((IFluidTank)tank));
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        IEnergyStorage storage;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCell && (storage = ((TileCell)te).getEnergyStorage()) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("storage", storage.getEnergyStored());
            tag.func_74768_a("maxStorage", storage.getMaxEnergyStored());
            ArrayList values = this.getHookValues(te);
            if (values != null) {
                tag.func_74772_a("diff", ((Long)values.get(0) - (Long)values.get(20)) / 20L);
            }
            return tag;
        }
        try {
            if (te instanceof TileMachineBase) {
                NBTTagCompound tag = new NBTTagCompound();
                TileMachineBase machine = (TileMachineBase)te;
                tag.func_74768_a("type", 1);
                tag.func_74757_a("active", machine.isActive);
                tag.func_74768_a("usage", machine.getInfoEnergyPerTick());
                tag.func_74778_a("rsmode", machine.getControl().name());
                IEnergyStorage storage2 = machine.getEnergyStorage();
                if (storage2 != null) {
                    tag.func_74768_a("storage", storage2.getEnergyStored());
                    tag.func_74768_a("maxStorage", storage2.getMaxEnergyStored());
                }
                Field field = TileMachineBase.class.getDeclaredField("energyConfig");
                field.setAccessible(true);
                EnergyConfig energyConfig = (EnergyConfig)field.get(machine);
                tag.func_74778_a("power", String.format("%s-%s RF/t", energyConfig.minPower, energyConfig.maxPower));
                String augmentation = "";
                if (machine.getAugmentSlots().length == 0) {
                    augmentation = StringHelper.localize((String)"info.cofh.upgradeRequired");
                } else {
                    for (int i = 0; i < machine.getAugmentSlots().length; ++i) {
                        ItemStack stack = machine.getAugmentSlots()[i];
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAugment)) continue;
                        ItemAugment item = (ItemAugment)stack.func_77973_b();
                        augmentation = augmentation.equals("") ? StringHelper.localize((String)String.format("item.thermalexpansion.augment.%s.name", item.getAugmentIdentifier(stack))) : augmentation + "," + StringHelper.localize((String)String.format("item.thermalexpansion.augment.%s.name", item.getAugmentIdentifier(stack)));
                    }
                }
                tag.func_74778_a("augmentation", augmentation);
                if (te instanceof TileSmelter) {
                    tag.func_74768_a("type", 2);
                    if (((TileSmelter)machine).lockPrimary) {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.smelter.modeLocked"));
                    } else {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.smelter.modeUnlocked"));
                    }
                }
                if (te instanceof TileInsolator) {
                    tag.func_74768_a("type", 3);
                    if (((TileInsolator)machine).lockPrimary) {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.insolator.modeLocked"));
                    } else {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.insolator.modeUnlocked"));
                    }
                    FluidTankCore tank = ((TileInsolator)machine).getTank();
                    tag.func_74778_a("water", String.format("%s / %s mB", tank.getFluidAmount(), tank.getCapacity()));
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = ThermalExpansionHooks.map.get(te);
        if (values == null) {
            ThermalExpansionHooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitThermalExpansion::new);
        ItemCardMain.register(ItemCardThermalExpansion::new);
    }
}

