/*
 * Decompiled with CFR 0.152.
 */
package com.unicornora.buildcraftfluxified.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import com.unicornora.buildcraftfluxified.mj.EnergyProviderMJ;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyWrapperMJ
implements IMjConnector,
IMjPassiveProvider,
IMjReadable,
IMjReceiver {
    protected final TileEntity upvalue;
    protected IEnergyStorage container;
    EnumFacing face = EnumFacing.SOUTH;

    public EnergyWrapperMJ(TileEntity upvalue) {
        this.upvalue = upvalue;
    }

    EnergyWrapperMJ face(EnumFacing face) {
        this.face = face;
        return this;
    }

    private boolean updateCapability(IEnergyStorage storage) {
        this.container = storage;
        return storage != null;
    }

    boolean isValid() {
        return this.upvalue.hasCapability(CapabilityEnergy.ENERGY, this.face) ? this.updateCapability((IEnergyStorage)this.upvalue.getCapability(CapabilityEnergy.ENERGY, this.face)) : false;
    }

    public long getPowerRequested() {
        if (this.container == null) {
            return 0L;
        }
        return EnergyProviderMJ.fromRF(this.container.receiveEnergy(Integer.MAX_VALUE, true));
    }

    public long receivePower(long microJoules, boolean simulate) {
        if (this.container == null) {
            return 0L;
        }
        int rf = EnergyProviderMJ.toRF(microJoules);
        if (rf == 0) {
            return 0L;
        }
        int simulated = this.container.receiveEnergy(rf, true);
        if (simulated == 0) {
            return microJoules;
        }
        if (!simulate) {
            this.container.receiveEnergy(simulated, false);
        }
        return microJoules - EnergyProviderMJ.fromRF(simulated);
    }

    public long getStored() {
        if (this.container == null) {
            return 0L;
        }
        return EnergyProviderMJ.fromRF(this.container.getEnergyStored());
    }

    public long getCapacity() {
        if (this.container == null) {
            return 0L;
        }
        return EnergyProviderMJ.fromRF(this.container.getMaxEnergyStored());
    }

    public long extractPower(long min, long max, boolean simulate) {
        int simulated;
        if (this.container == null) {
            return 0L;
        }
        if (!this.container.canExtract()) {
            return 0L;
        }
        int rfMax = EnergyProviderMJ.toRF(max);
        if (rfMax == (simulated = this.container.extractEnergy(rfMax, true))) {
            if (!simulate) {
                this.container.extractEnergy(rfMax, false);
            }
            return max;
        }
        int rfMin = EnergyProviderMJ.toRF(min);
        if (rfMin > simulated) {
            return 0L;
        }
        if (!simulate) {
            this.container.extractEnergy(simulated, false);
        }
        return EnergyProviderMJ.fromRF(simulated);
    }

    public boolean canConnect(IMjConnector other) {
        return this.container != null;
    }
}

