/*
 * Decompiled with CFR 0.152.
 */
package com.unicornora.buildcraftfluxified.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.unicornora.buildcraftfluxified.BCFE;
import com.unicornora.buildcraftfluxified.mj.EnergyProviderMJ;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

class EnergyContainerMJ
implements IEnergyStorage {
    protected final TileEntity upvalue;
    EnumFacing face = EnumFacing.SOUTH;
    private EnumFacing lastFace;
    protected IMjConnector connector;
    protected IMjReadable read;
    protected IMjReceiver receiver;
    protected IMjPassiveProvider passive;

    public EnergyContainerMJ(TileEntity upvalue) {
        this.upvalue = upvalue;
    }

    EnergyContainerMJ face(EnumFacing face) {
        this.face = face;
        return this;
    }

    boolean isValid() {
        return this.upvalue.hasCapability(MjAPI.CAP_RECEIVER, this.face) || this.upvalue.hasCapability(MjAPI.CAP_CONNECTOR, this.face);
    }

    EnergyContainerMJ updateValues() {
        if (this.lastFace == this.face) {
            return this;
        }
        this.lastFace = this.face;
        this.connector = (IMjConnector)this.upvalue.getCapability(MjAPI.CAP_CONNECTOR, this.face);
        this.read = (IMjReadable)this.upvalue.getCapability(MjAPI.CAP_READABLE, this.face);
        this.receiver = (IMjReceiver)this.upvalue.getCapability(MjAPI.CAP_RECEIVER, this.face);
        this.passive = (IMjPassiveProvider)this.upvalue.getCapability(MjAPI.CAP_PASSIVE_PROVIDER, this.face);
        return this;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        maxReceive = Math.min(this.calcMaxReceive(), maxReceive);
        if (maxReceive == 0) {
            return 0;
        }
        long value = EnergyProviderMJ.fromRF(maxReceive);
        long simulated = this.receiver.receivePower(value, true);
        if (simulated == 0L) {
            if (!simulate) {
                this.receiver.receivePower(value, false);
            }
            return maxReceive;
        }
        long ratio = BCFE.conversionRatio();
        if ((value -= simulated) % ratio != 0L) {
            value -= value % ratio;
        }
        if ((simulated = this.receiver.receivePower(value, true)) % ratio != 0L) {
            return 0;
        }
        if (!simulate) {
            return EnergyProviderMJ.toRF(value - this.receiver.receivePower(value, false));
        }
        return EnergyProviderMJ.toRF(value - simulated);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        long value = EnergyProviderMJ.fromRF(maxExtract);
        long simulated = this.passive.extractPower(BCFE.conversionRatio(), value, true);
        if ((simulated -= simulated % BCFE.conversionRatio()) == 0L) {
            return 0;
        }
        if (!simulate) {
            return EnergyProviderMJ.toRF(this.passive.extractPower(BCFE.conversionRatio(), simulated, true));
        }
        return EnergyProviderMJ.toRF(simulated);
    }

    int calcMaxReceive() {
        if (this.read == null) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxEnergyStored() - this.getEnergyStored();
    }

    public int getEnergyStored() {
        return this.read != null ? EnergyProviderMJ.toRF(this.read.getStored()) : 0;
    }

    public int getMaxEnergyStored() {
        return this.read != null ? EnergyProviderMJ.toRF(this.read.getCapacity()) : 0;
    }

    public boolean canExtract() {
        return this.passive != null;
    }

    public boolean canReceive() {
        return this.receiver != null && this.receiver.canReceive();
    }
}

