/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.ic2cuumatter.integration.jei.category;

import ic2.core.platform.lang.storage.Ic2BlockLang;
import java.util.Arrays;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PlasmafierCategory
implements IRecipeCategory<PlasmafierRecipe> {
    public static String UID = "ic2cuumatter.plasmafier";
    public static final ResourceLocation plasmafierTexture = new ResourceLocation("ic2cuumatter", "textures/gui/plasmafier.png");
    IDrawable background;
    IDrawable press1;
    IDrawable press2;
    IDrawable press3;
    IDrawable tank1;
    IDrawable tank2;
    IDrawable tank3;
    IDrawable plasma;
    IDrawable glass;

    public PlasmafierCategory(IGuiHelper helper, ItemStack itemStack, ResourceLocation texture) {
        this.background = helper.createDrawable(texture, 13, 14, 132, 64);
        this.press1 = helper.createDrawable(texture, 176, 41, 12, 1);
        this.press2 = helper.createDrawable(texture, 176, 42, 12, 1);
        this.press3 = helper.createDrawable(texture, 176, 45, 12, 1);
        this.tank1 = helper.drawableBuilder(plasmafierTexture, 201, 0, 12, 41).buildAnimated(250, IDrawableAnimated.StartDirection.TOP, true);
        this.tank2 = helper.drawableBuilder(plasmafierTexture, 213, 0, 12, 41).buildAnimated(250, IDrawableAnimated.StartDirection.TOP, true);
        this.tank3 = helper.drawableBuilder(plasmafierTexture, 225, 0, 12, 41).buildAnimated(250, IDrawableAnimated.StartDirection.TOP, true);
        this.plasma = helper.drawableBuilder(texture, 176, 0, 12, 41).buildAnimated(250, IDrawableAnimated.StartDirection.TOP, true);
        this.glass = helper.createDrawable(texture, 189, 0, 12, 46);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Ic2BlockLang.plasmafire.getLocalized();
    }

    public String getModName() {
        return "ic2cuumatter";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, PlasmafierRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 102, 8);
        guiItemStacks.init(1, true, 30, 20);
        guiItemStacks.init(2, false, 102, 30);
        guiItemStacks.set(ingredients);
    }

    public void drawExtras(Minecraft minecraft) {
        this.press1.draw(minecraft, 69, 45);
        this.press2.draw(minecraft, 69, 46);
        this.press2.draw(minecraft, 69, 47);
        this.press2.draw(minecraft, 69, 48);
        this.press3.draw(minecraft, 69, 49);
        this.tank1.draw(minecraft, 69, 4);
        this.tank2.draw(minecraft, 69, 5);
        this.tank3.draw(minecraft, 69, 8);
        this.plasma.draw(minecraft, 69, 9);
        this.glass.draw(minecraft, 68, 4);
        FontRenderer font = minecraft.field_71466_p;
        String tierHV = I18n.func_135052_a((String)"translation.ic2cuumatter.tier.hv", (Object[])new Object[0]);
        font.func_78276_b(tierHV, 0, 0, 0x404040);
        String ticks = I18n.func_135052_a((String)"translation.ic2cuumatter.ticks", (Object[])new Object[0]);
        font.func_78276_b(ticks, 0, 57, 0x404040);
        font.func_78276_b(new String("512 EU/t"), 89, 57, 0x404040);
    }

    public static final class PlasmafierRecipe
    implements IRecipeWrapper {
        public ItemStack inputEmptyCell;
        public ItemStack inputUU;
        public ItemStack outputItem;

        public PlasmafierRecipe(ItemStack emptyCellInput, ItemStack uuInput, ItemStack itemOutput) {
            this.inputEmptyCell = emptyCellInput;
            this.inputUU = uuInput;
            this.outputItem = itemOutput;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(this.inputEmptyCell, this.inputUU));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.outputItem);
        }
    }
}

