/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.blocks.BlockForestry;
import forestry.core.gui.GuiHandler;
import forestry.core.tiles.TileUtil;
import forestry.sorting.tiles.TileGeneticFilter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGeneticFilter
extends BlockForestry
implements IItemModelRegister {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final AxisAlignedBB BOX_CENTER = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB BOX_DOWN = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75);
    private static final AxisAlignedBB BOX_UP = new AxisAlignedBB(0.25, 0.6875, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB BOX_NORTH = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125);
    private static final AxisAlignedBB BOX_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB BOX_WEST = new AxisAlignedBB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75);
    private static final AxisAlignedBB BOX_EAST = new AxisAlignedBB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB[] BOX_FACES = new AxisAlignedBB[]{BOX_DOWN, BOX_UP, BOX_NORTH, BOX_SOUTH, BOX_WEST, BOX_EAST};

    public BlockGeneticFilter() {
        super(Material.field_151575_d);
        this.func_149647_a(CreativeTabForestry.tabForestry);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
        this.func_149711_c(0.25f);
        this.func_149752_b(3.0f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileGeneticFilter geneticFilter = TileUtil.getTile(worldIn, pos, TileGeneticFilter.class);
        if (geneticFilter == null) {
            return this.func_176223_P();
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(geneticFilter.isConnected(EnumFacing.DOWN)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileGeneticFilter tile = TileUtil.getTile((IBlockAccess)worldIn, pos, TileGeneticFilter.class);
        if (tile != null && TileUtil.isUsableByPlayer(playerIn, tile)) {
            if (!worldIn.field_72995_K) {
                GuiHandler.openGui(playerIn, tile);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult result = this.func_185503_a(pos, start, end, BOX_CENTER);
        if (result != null) {
            result.subHit = 0;
            return result;
        }
        TileGeneticFilter geneticFilter = TileUtil.getTile((IBlockAccess)worldIn, pos, TileGeneticFilter.class);
        if (geneticFilter != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!geneticFilter.isConnected(facing) || (result = this.func_185503_a(pos, start, end, BOX_FACES[facing.ordinal()])) == null) continue;
                result.subHit = 1 + facing.ordinal();
                return result;
            }
        }
        return null;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockGeneticFilter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOX_CENTER);
        TileGeneticFilter geneticFilter = TileUtil.getTile((IBlockAccess)worldIn, pos, TileGeneticFilter.class);
        if (geneticFilter != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!geneticFilter.isConnected(facing)) continue;
                BlockGeneticFilter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOX_FACES[facing.ordinal()]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.subHit < 0 || !pos.equals((Object)trace.func_178782_a())) {
            return field_185505_j.func_186670_a(pos);
        }
        AxisAlignedBB aabb = field_185505_j;
        int sub = trace.subHit;
        if (sub == 0) {
            aabb = BOX_CENTER;
        } else if (sub < 7) {
            aabb = BOX_FACES[sub - 1];
        }
        return aabb.func_186670_a(pos);
    }

    @Override
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGeneticFilter();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

