/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesDisplayHelper;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import net.minecraft.item.ItemStack;

public class SpeciesDisplayHelper
implements ISpeciesDisplayHelper {
    private final Table<ISpeciesType, String, ItemStack> iconStacks = HashBasedTable.create();
    private final ISpeciesRoot root;

    public SpeciesDisplayHelper(ISpeciesRoot root) {
        this.root = root;
        ISpeciesType type = root.getIconType();
        for (IIndividual iIndividual : root.getIndividualTemplates()) {
            ItemStack itemStack = root.getMemberStack(iIndividual, type);
            this.iconStacks.put((Object)type, (Object)iIndividual.getGenome().getPrimary().getUID(), (Object)itemStack);
        }
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species, ISpeciesType type) {
        ItemStack stack = (ItemStack)this.iconStacks.get((Object)type, (Object)species.getUID());
        if (stack == null) {
            stack = this.root.getMemberStack(species, type);
            this.iconStacks.put((Object)type, (Object)species.getUID(), (Object)stack);
        }
        return stack;
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species) {
        return this.getDisplayStack(species, this.root.getIconType());
    }
}

