/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.entity;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.icannt.netherendingores.common.registry.BlockRegistry;
import org.icannt.netherendingores.common.registry.RegistryEvents;
import org.icannt.netherendingores.lib.Config;

public class EntityNetherfish
extends EntitySilverfish {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("netherendingores", "entities/netherfish");
    private AISummonNetherfish summonNetherfish;

    public EntityNetherfish(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.netherfishMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Config.netherfishMovementSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Config.netherfishAttackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(Config.netherfishKnockbackResistance);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.summonNetherfish = new AISummonNetherfish(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.summonNetherfish);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHideInNetherrack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            double flameX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
            double flameY = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double flameZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, flameX, flameY, flameZ, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return RegistryEvents.ENTITY_NETHERFISH_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RegistryEvents.ENTITY_NETHERFISH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RegistryEvents.ENTITY_NETHERFISH_DEATH;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.field_76376_m) && this.summonNetherfish != null) {
            this.summonNetherfish.notifyHurt();
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (Config.netherfishSetFire) {
            entityIn.func_70015_d(3);
        }
        return super.func_70652_k(entityIn);
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    static class AIHideInNetherrack
    extends EntityAIWander {
        private EnumFacing facing;
        private boolean doMerge;

        public AIHideInNetherrack(EntityNetherfish netherfish) {
            super((EntityCreature)netherfish, 1.0, 10);
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            World world = this.field_75457_a.field_70170_p;
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.facing = EnumFacing.func_176741_a((Random)random);
                BlockPos blockPos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState blockState = world.func_180495_p(blockPos);
                if (blockState == Blocks.field_150424_aL.func_176223_P()) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.doMerge && super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.doMerge) {
                super.func_75249_e();
            } else {
                World world = this.field_75457_a.field_70170_p;
                BlockPos blockPos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState blockState = world.func_180495_p(blockPos);
                if (blockState == Blocks.field_150424_aL.func_176223_P()) {
                    world.func_180501_a(blockPos, BlockRegistry.BLOCK_NETHER_NETHERFISH.func_176223_P(), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }

    static class AISummonNetherfish
    extends EntityAIBase {
        private final EntityNetherfish netherfish;
        private int lookForFriends;

        public AISummonNetherfish(EntityNetherfish netherfish) {
            this.netherfish = netherfish;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 40;
            }
        }

        public boolean func_75250_a() {
            return this.lookForFriends > 0;
        }

        public void func_75246_d() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                World world = this.netherfish.field_70170_p;
                Random random = this.netherfish.func_70681_au();
                BlockPos blockpos = new BlockPos((Entity)this.netherfish);
                int y = 0;
                while (y <= 5 && y >= -5) {
                    int x = 0;
                    while (x <= 10 && x >= -10) {
                        int z = 0;
                        while (z <= 10 && z >= -10) {
                            BlockPos friendBlock = blockpos.func_177982_a(x, y, z);
                            IBlockState iblockstate = world.func_180495_p(friendBlock);
                            if (iblockstate.func_177230_c() == BlockRegistry.BLOCK_NETHER_NETHERFISH) {
                                if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)this.netherfish)) {
                                    world.func_175655_b(friendBlock, true);
                                } else {
                                    world.func_180501_a(friendBlock, Blocks.field_150424_aL.func_176223_P(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            z = (z <= 0 ? 1 : 0) - z;
                        }
                        x = (x <= 0 ? 1 : 0) - x;
                    }
                    y = (y <= 0 ? 1 : 0) - y;
                }
            }
        }
    }
}

