/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.internal.variables.IVariable;
import com.zeitheron.hammercore.internal.variables.VariableManager;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

@MainThreaded
public class PacketUpdateDirtyVariables
implements IPacket {
    public NBTTagList nbt;

    public PacketUpdateDirtyVariables(Map<ResourceLocation, IVariable<?>> vars) {
        this.nbt = new NBTTagList();
        for (ResourceLocation key : vars.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Id", key.toString());
            tag.func_74782_a("Data", (NBTBase)vars.get(key).writeToNBT(new NBTTagCompound()));
            this.nbt.func_74742_a((NBTBase)tag);
        }
    }

    public PacketUpdateDirtyVariables() {
    }

    @Override
    public IPacket execute(Side side, PacketContext ctx) {
        NBTTagList list = this.nbt;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            IVariable var = VariableManager.getVariable(new ResourceLocation(nbt.func_74779_i("Id")));
            if (var == null || !var.direction().allowedTo(side)) continue;
            var.readFromNBT(nbt.func_74775_l("Data"));
            var.notifyUpdate(side);
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("List", (NBTBase)this.nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.nbt = nbt.func_150295_c("List", 10);
    }

    static {
        IPacket.handle(PacketUpdateDirtyVariables.class, PacketUpdateDirtyVariables::new);
    }
}

