/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.cfg.file1132.io;

import com.zeitheron.hammercore.cfg.file1132.ConfigEntrySerializer;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import com.zeitheron.hammercore.cfg.file1132.IConfigEntry;
import java.util.Objects;

public class ConfigEntryFloat
implements IConfigEntry {
    final Configuration cfg;
    public float min = Float.MIN_VALUE;
    public float max = Float.MAX_VALUE;
    String description;
    String name;
    Float value;
    Float initialValue;

    public ConfigEntryFloat(Configuration cfg, Float initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryFloat setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryFloat setMinValue(float min) {
        this.min = min;
        if (this.value != null) {
            this.value = Float.valueOf(Math.max(min, Math.min(this.max, this.value.floatValue())));
        }
        return this;
    }

    public ConfigEntryFloat setMaxValue(float max) {
        this.max = max;
        if (this.value != null) {
            this.value = Float.valueOf(Math.max(this.min, Math.min(max, this.value.floatValue())));
        }
        return this;
    }

    public ConfigEntryFloat setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryFloat setValue(Float value) {
        if (value != null) {
            value = Float.valueOf(Math.max(this.min, Math.min(this.max, value.floatValue())));
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Float getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return Configuration.SERIALIZER_FLOAT;
    }
}

