/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.lighting;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingItem;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ColoredLightManager {
    private static final List<Function<Float, Stream<ColoredLight>>> lightGenerators = new ArrayList<Function<Float, Stream<ColoredLight>>>();
    public static final BooleanSupplier COLORED_LIGHTING_ENABLED = () -> false;
    public static final BooleanSupplier SHADER_UNIFORM_SETUP = () -> false;
    public static final BooleanSupplier BIND_TERRAIN = () -> false;
    public static final BooleanSupplier BIND_ENTITY = () -> false;
    public static final BooleanSupplier UNBIND_TERRAIN = () -> false;
    public static final BooleanSupplier UNBIND_ENTITY = () -> false;
    public static IntSupplier UNIFORM_LIGHT_COUNT = () -> 0;
    public static int LAST_LIGHTS;

    public static boolean isColoredLightActive() {
        return COLORED_LIGHTING_ENABLED.getAsBoolean();
    }

    public static void registerOperator(BooleanSupplier enabled, BooleanSupplier uniforms, BooleanSupplier bindTerrain, BooleanSupplier bindEntity, BooleanSupplier unbindTerrain, BooleanSupplier unbindEntity) {
        BooleanSupplier prevBS = COLORED_LIGHTING_ENABLED;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "COLORED_LIGHTING_ENABLED", () -> prevBS != null && prevBS.getAsBoolean() || enabled.getAsBoolean());
        BooleanSupplier prevSUS = SHADER_UNIFORM_SETUP;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "SHADER_UNIFORM_SETUP", () -> {
            boolean got = prevSUS.getAsBoolean();
            return uniforms.getAsBoolean() || got;
        });
        BooleanSupplier prevBT = BIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "BIND_TERRAIN", () -> {
            boolean got = prevBT.getAsBoolean();
            return bindTerrain.getAsBoolean() || got;
        });
        BooleanSupplier prevBE = BIND_ENTITY;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "BIND_ENTITY", () -> {
            boolean got = prevBE.getAsBoolean();
            return bindEntity.getAsBoolean() || got;
        });
        BooleanSupplier prevUBT = UNBIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "UNBIND_TERRAIN", () -> {
            boolean got = prevUBT.getAsBoolean();
            return unbindTerrain.getAsBoolean() || got;
        });
        BooleanSupplier prevUBE = UNBIND_ENTITY;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "UNBIND_ENTITY", () -> {
            boolean got = prevUBE.getAsBoolean();
            return unbindEntity.getAsBoolean() || got;
        });
    }

    public static <A, B, C> Function<A, C> dfunc(Function<A, B> fa, Function<B, C> fb) {
        return a -> fb.apply(fa.apply(a));
    }

    public static EntityPlayer getClientPlayer() {
        return HammerCore.renderProxy.getClientPlayer();
    }

    public static void addGenerator(Function<Float, Stream<ColoredLight>> gen) {
        lightGenerators.add(gen);
    }

    public static Stream<ColoredLight> generate(float partialTicks) {
        return lightGenerators.stream().flatMap(f -> (Stream)f.apply(Float.valueOf(partialTicks))).filter(Objects::nonNull);
    }

    static {
        ColoredLightManager.addGenerator(partialTicks -> {
            EntityPlayer pl = ColoredLightManager.getClientPlayer();
            if (pl != null) {
                Stream players = pl.field_70170_p.field_72996_f.stream().flatMap(ent -> {
                    if (ent.func_98034_c(pl) || !ent.isAddedToWorld()) {
                        return Stream.empty();
                    }
                    if (ent instanceof EntityPlayer && ((EntityPlayer)ent).func_175149_v()) {
                        return Stream.empty();
                    }
                    if (ent instanceof EntityLivingBase) {
                        ItemStack off;
                        EntityLivingBase base = (EntityLivingBase)ent;
                        Stream.Builder<ColoredLight> lights = Stream.builder();
                        ItemStack main = base.func_184614_ca();
                        IGlowingItem igi = IGlowingItem.fromStack(main);
                        if (igi != null) {
                            lights.add(igi.produceColoredLight((Entity)base, main));
                        }
                        if ((igi = IGlowingItem.fromStack(off = base.func_184592_cb())) != null) {
                            lights.add(igi.produceColoredLight((Entity)base, off));
                        }
                        return lights.build().filter(Objects::nonNull).map(l -> l.reposition((Entity)ent, partialTicks.floatValue()));
                    }
                    if (ent instanceof EntityItem) {
                        EntityItem ei = (EntityItem)ent;
                        Stream.Builder<ColoredLight> lights = Stream.builder();
                        ItemStack item = ei.func_92059_d();
                        IGlowingItem igi = IGlowingItem.fromStack(item);
                        if (igi != null) {
                            lights.add(igi.produceColoredLight((Entity)ei, item));
                        }
                        return lights.build().filter(Objects::nonNull).map(l -> l.reposition((Entity)ent, partialTicks.floatValue()));
                    }
                    return Stream.empty();
                });
                Stream<ColoredLight> entities = Stream.concat(players, pl.field_70170_p.field_72996_f.stream().filter(e -> e.isAddedToWorld() && !e.func_98034_c(pl)).filter(IGlowingEntity.class::isInstance).map(e -> ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue())));
                Stream<ColoredLight> tiles = pl.field_70170_p.field_147482_g.stream().filter(IGlowingEntity.class::isInstance).map(e -> ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue()));
                return Stream.concat(tiles, entities);
            }
            return Stream.empty();
        });
    }
}

