/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;

final class LexAnn {
    private static Hashtable wordToken = new Hashtable();
    private static final int MAX_LINE_LENGTH = 1024;
    public static final int TT_WORD = 9000;
    public static final int TT_INTEGER = 9001;
    public static final int TT_DOUBLE = 9002;
    public static final int TT_EOF = 9003;
    public static final int TT_EOL = 9004;
    public static final int TT_STRING = 9005;
    public static final int TT_FUNC = 9006;
    public static final int TT_ARRAY = 9007;
    public static final int TT_NULL = 9008;
    public static final int TT_IF = 9009;
    public static final int TT_EIF = 9010;
    public static final int TT_ELSE = 9011;
    public static final int TT_THEN = 9012;
    public static final int TT_ELSIF = 9013;
    public static final int TT_DEFFUNC = 9014;
    public static final int TT_EDEFFUNC = 9015;
    public static final int TT_WHILE = 9016;
    public static final int TT_EWHILE = 9017;
    public static final int TT_DEFINT = 9018;
    public static final int TT_DEFSTRING = 9019;
    public static final int TT_DEFDOUBLE = 9020;
    public static final int TT_DEFOBJECT = 9021;
    public static final int TT_RETURN = 9022;
    public static final int TT_PLUS = 9023;
    public static final int TT_MINUS = 9024;
    public static final int TT_MULT = 9025;
    public static final int TT_DIV = 9026;
    public static final int TT_MOD = 9027;
    public static final int TT_LAND = 9028;
    public static final int TT_LOR = 9029;
    public static final int TT_LEQ = 9030;
    public static final int TT_LNEQ = 9031;
    public static final int TT_LGR = 9032;
    public static final int TT_LLS = 9033;
    public static final int TT_LGRE = 9034;
    public static final int TT_LLSE = 9035;
    public static final int TT_NOT = 9036;
    public static final int TT_EQ = 9037;
    int ttype;
    Object value;
    private boolean pBack;
    private char[] cBuf = new char[1024];
    private char[] line;
    private int length;
    private int c = 0;
    private static final int EOL = -1;
    private int pos = 0;

    public String toString() {
        Class<?> c = this.getClass();
        int n = 0;
        String tokenName = "";
        String ret = "";
        Field[] fields = c.getFields();
        for (n = 0; n < fields.length; ++n) {
            Field f = fields[n];
            try {
                if (!f.getName().startsWith("TT") || this.ttype != f.getInt(this)) continue;
                tokenName = f.getName();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ret = !tokenName.equals("") ? tokenName + ":" + this.value : String.valueOf((char)this.ttype) + ":" + this.value;
        return ret;
    }

    LexAnn() {
    }

    LexAnn(char[] firstLine) {
        this();
        this.setString(firstLine);
    }

    void setString(char[] str) {
        this.length = str.length;
        this.line = str;
        this.pos = 0;
        this.c = 0;
    }

    private int getChar() {
        if (this.pos < this.length) {
            return this.line[this.pos++];
        }
        return -1;
    }

    private int peekChar(int offset) {
        int n = this.pos + offset - 1;
        if (n >= this.length) {
            return -1;
        }
        return this.line[n];
    }

    int nextToken() throws IOException {
        if (!this.pBack) {
            return this.nextT();
        }
        this.pBack = false;
        return this.ttype;
    }

    void pushBack() {
        this.pBack = true;
    }

    String getLine() {
        return new String(this.line);
    }

    private int nextT() {
        int cPos = 0;
        this.value = null;
        this.ttype = 0;
        while (this.ttype == 0) {
            boolean getNext = true;
            switch (this.c) {
                case 0: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case -1: {
                    this.ttype = 9004;
                    break;
                }
                case 35: {
                    this.pos = this.length;
                    this.ttype = 9004;
                    break;
                }
                case 34: {
                    this.c = this.getChar();
                    while (this.c != -1 && this.c != 34) {
                        if (this.c == 92) {
                            switch (this.peekChar(1)) {
                                case 110: {
                                    this.cBuf[cPos++] = 10;
                                    this.getChar();
                                    break;
                                }
                                case 116: {
                                    this.cBuf[cPos++] = 9;
                                    this.getChar();
                                    break;
                                }
                                case 114: {
                                    this.cBuf[cPos++] = 13;
                                    this.getChar();
                                    break;
                                }
                                case 34: {
                                    this.cBuf[cPos++] = 34;
                                    this.getChar();
                                    break;
                                }
                                case 92: {
                                    this.cBuf[cPos++] = 92;
                                    this.getChar();
                                }
                            }
                        } else {
                            this.cBuf[cPos++] = (char)this.c;
                        }
                        this.c = this.getChar();
                    }
                    this.value = new String(this.cBuf, 0, cPos);
                    this.ttype = 9005;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    while (this.c >= 65 && this.c <= 90 || this.c >= 97 && this.c <= 122 || this.c >= 48 && this.c <= 57 || this.c == 95 || this.c == 46) {
                        this.cBuf[cPos++] = (char)this.c;
                        this.c = this.getChar();
                    }
                    getNext = false;
                    this.value = new String(this.cBuf, 0, cPos);
                    Integer tt = (Integer)wordToken.get(this.value);
                    if (tt != null) {
                        this.ttype = tt;
                        break;
                    }
                    if (this.c == 40) {
                        this.ttype = 9006;
                        break;
                    }
                    if (this.c == 91) {
                        this.ttype = 9007;
                        break;
                    }
                    this.ttype = 9000;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    boolean isDouble = false;
                    while (this.c >= 48 && this.c <= 57 || this.c == 46) {
                        if (this.c == 46) {
                            isDouble = true;
                        }
                        this.cBuf[cPos++] = (char)this.c;
                        this.c = this.getChar();
                    }
                    getNext = false;
                    String str = new String(this.cBuf, 0, cPos);
                    if (isDouble) {
                        this.ttype = 9002;
                        this.value = new Double(str);
                        break;
                    }
                    this.ttype = 9001;
                    this.value = new Integer(str);
                    break;
                }
                case 43: {
                    this.ttype = 9023;
                    break;
                }
                case 45: {
                    this.ttype = 9024;
                    break;
                }
                case 42: {
                    this.ttype = 9025;
                    break;
                }
                case 47: {
                    this.ttype = 9026;
                    break;
                }
                case 37: {
                    this.ttype = 9027;
                    break;
                }
                case 62: {
                    if (this.peekChar(1) == 61) {
                        this.getChar();
                        this.ttype = 9034;
                        break;
                    }
                    this.ttype = 9032;
                    break;
                }
                case 60: {
                    if (this.peekChar(1) == 61) {
                        this.getChar();
                        this.ttype = 9035;
                        break;
                    }
                    this.ttype = 9033;
                    break;
                }
                case 61: {
                    if (this.peekChar(1) == 61) {
                        this.getChar();
                        this.ttype = 9030;
                        break;
                    }
                    this.ttype = 9037;
                    break;
                }
                case 33: {
                    if (this.peekChar(1) == 61) {
                        this.getChar();
                        this.ttype = 9031;
                        break;
                    }
                    this.ttype = 9036;
                    break;
                }
                default: {
                    if (this.c == 124 && this.peekChar(1) == 124) {
                        this.getChar();
                        this.ttype = 9029;
                        break;
                    }
                    if (this.c == 38 && this.peekChar(1) == 38) {
                        this.getChar();
                        this.ttype = 9028;
                        break;
                    }
                    this.ttype = this.c;
                }
            }
            if (!getNext) continue;
            this.c = this.getChar();
        }
        return this.ttype;
    }

    static {
        wordToken.put("if", new Integer(9009));
        wordToken.put("then", new Integer(9012));
        wordToken.put("endif", new Integer(9010));
        wordToken.put("else", new Integer(9011));
        wordToken.put("elsif", new Integer(9013));
        wordToken.put("elseif", new Integer(9013));
        wordToken.put("while", new Integer(9016));
        wordToken.put("endwhile", new Integer(9017));
        wordToken.put("func", new Integer(9014));
        wordToken.put("endfunc", new Integer(9015));
        wordToken.put("return", new Integer(9022));
        wordToken.put("int", new Integer(9018));
        wordToken.put("string", new Integer(9019));
        wordToken.put("double", new Integer(9020));
        wordToken.put("object", new Integer(9021));
        wordToken.put("null", new Integer(9008));
    }
}

