/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils.render.cmd;

import com.bymarcin.zettaindustries.utils.render.cmd.RenderCommand;
import com.bymarcin.zettaindustries.utils.render.cmd.executor.IRenderCommandExecutor;
import com.bymarcin.zettaindustries.utils.render.cmd.executor.NormalExecutor;
import java.util.LinkedList;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class Normal
extends RenderCommand {
    public Normal(float x, float y, float z) {
        super(9);
        this.args = new float[]{x, y, z};
    }

    @Override
    public IRenderCommandExecutor getExecutor(LinkedList<Matrix4f> transformations, float minU, float maxU, float minV, float maxV) {
        Matrix4f matrix = new Matrix4f(transformations.getLast());
        matrix = Matrix4f.invert((Matrix4f)matrix, (Matrix4f)matrix);
        matrix = matrix.transpose(matrix);
        Vector4f result = Matrix4f.transform((Matrix4f)matrix, (Vector4f)new Vector4f(this.args[0], this.args[1], this.args[2], 0.0f), null);
        float biggestNormal = Math.max(Math.abs(this.args[1]), Math.max(Math.abs(this.args[0]), Math.abs(this.args[2])));
        int side = biggestNormal == Math.abs(this.args[1]) ? (this.args[1] < 0.0f ? 0 : 1) : (biggestNormal == Math.abs(this.args[2]) ? (this.args[2] < 0.0f ? 2 : 3) : (this.args[0] < 0.0f ? 4 : 5));
        return new NormalExecutor(result.x, result.y, result.z, side);
    }
}

