/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.nfc.smartcard;

import com.bymarcin.zettaindustries.mods.nfc.NFC;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardItem;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.crypto.KeyAgreement;
import li.cil.oc.api.Network;
import li.cil.oc.api.component.RackBusConnectable;
import li.cil.oc.api.component.RackMountable;
import li.cil.oc.api.internal.Rack;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Analyzable;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.api.util.StateAware;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class SmartCardTerminal
extends AbstractManagedEnvironment
implements RackMountable,
Analyzable {
    @Nonnull
    ItemStack card = ItemStack.field_190927_a;
    protected ComponentConnector node;
    UUID player;
    Rack host;

    public SmartCardTerminal(Rack host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("smartcard_terminal", Visibility.Network).create());
    }

    public Node node() {
        return this.node != null ? this.node : super.node();
    }

    protected void setNode(Node value) {
        if (value == null) {
            this.node = null;
        } else if (value instanceof ComponentConnector) {
            this.node = (ComponentConnector)value;
        }
        super.setNode(value);
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.player != null) {
            nbt.func_186854_a("PLAYER_UUID", this.player);
        }
        if (!this.card.func_190926_b()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.card.func_77955_b(tag);
            nbt.func_74782_a("CARD", (NBTBase)tag);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("PLAYER_UUID")) {
            this.player = nbt.func_186857_a("PLAYER_UUID");
        } else if (nbt.func_74764_b("PLAYER")) {
            this.player = NFC.getUUIDForPlayer(nbt.func_74779_i("PLAYER"));
        }
        this.card = nbt.func_74764_b("CARD") ? new ItemStack(nbt.func_74775_l("CARD")) : ItemStack.field_190927_a;
    }

    public EnumSet<StateAware.State> getCurrentState() {
        return EnumSet.noneOf(StateAware.State.class);
    }

    protected byte[] checkCost(Context context, Arguments args, double baseCost, double byteCost) throws Exception {
        byte[] data = args.checkByteArray(0);
        if (data.length > NFC.dataCardHardLimit) {
            throw new IllegalArgumentException("data size limit exceeded");
        }
        double cost = baseCost + (double)data.length * byteCost;
        if (!this.node.tryChangeBuffer(-cost)) {
            throw new Exception("not enough energy");
        }
        if (data.length > NFC.dataCardSoftLimit) {
            context.pause((double)NFC.dataCardTimeout);
        }
        return data;
    }

    protected byte[] asymmetricCost(Context context, Arguments args) throws Exception {
        return this.checkCost(context, args, NFC.dataCardAsymmetric, NFC.dataCardComplexByte);
    }

    protected void checkCost(Double baseCost) throws Exception {
        if (!this.node.tryChangeBuffer(-baseCost.doubleValue())) {
            throw new Exception("not enough energy");
        }
    }

    @Callback(direct=true)
    public Object[] hasCard(Context ctx, Arguments args) {
        Object[] objectArray;
        if (this.card.func_190926_b()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = true;
        }
        return objectArray;
    }

    @Callback(direct=true)
    public Object[] protect(Context ctx, Arguments args) {
        if (!this.card.func_190926_b() && !SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast")) {
            SmartCardItem.getNBT(this.card).func_186854_a("sc:owner_uuid", this.player);
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            return new Object[]{true, this.player};
        }
        return new Object[]{false};
    }

    @Callback(direct=true, limit=1, doc="function(data:string [, sig:string]):string or bool -- Signs or verifies data.")
    public Object[] ecdsa(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        if (SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast") && !SmartCardItem.getOwner(this.card).equals(this.player)) {
            return new Object[]{null, "You are not owner"};
        }
        byte[] data = this.asymmetricCost(context, args);
        byte[] sig = args.optByteArray(1, null);
        Signature sign = Signature.getInstance("SHA256withECDSA");
        if (sig != null) {
            byte[] key = SmartCardItem.getPublicKey(this.card);
            sign.initVerify((PublicKey)this.deserialize(KeyType.PUBLIC, key));
            sign.update(data);
            return new Object[]{sign.verify(sig)};
        }
        byte[] key = SmartCardItem.getPrivateKey(this.card);
        sign.initSign((PrivateKey)this.deserialize(KeyType.PRIVATE, key));
        sign.update(data);
        return new Object[]{sign.sign()};
    }

    @Callback(direct=true, doc="function():string")
    public Object[] getPublicKey(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        return new Object[]{SmartCardItem.getPublicKey(this.card)};
    }

    @Callback(direct=true, limit=1, doc="function(pub:userdata):string -- Generates a shared key. ecdh(a.priv, b.pub) == ecdh(b.priv, a.pub)")
    public Object[] ecdh(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        if (SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast") && !SmartCardItem.getOwner(this.card).equals(this.player)) {
            return new Object[]{null, "You are not owner"};
        }
        this.checkCost(NFC.dataCardAsymmetric);
        Key pubKey = this.deserialize(KeyType.PUBLIC, args.checkByteArray(0));
        Key privKey = this.deserialize(KeyType.PRIVATE, SmartCardItem.getPrivateKey(this.card));
        KeyAgreement ka = KeyAgreement.getInstance("ECDH");
        ka.init(privKey);
        ka.doPhase(pubKey, true);
        return new Object[]{ka.generateSecret()};
    }

    private Key deserialize(KeyType type, byte[] data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        switch (type) {
            case PRIVATE: {
                return KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(data));
            }
            case PUBLIC: {
                return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(data));
            }
        }
        throw new IllegalArgumentException("invalid key type, must be public or private");
    }

    public NBTTagCompound getData() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("hasCard", !this.card.func_190926_b());
        if (!this.card.func_190926_b() && SmartCardItem.getOwner(this.card) == null || !this.card.func_190926_b() && this.player != null && this.player.equals(SmartCardItem.getOwner(this.card))) {
            nbt.func_74757_a("validOwner", true);
            nbt.func_74757_a("isProtected", SmartCardItem.getOwner(this.card) != null);
        } else {
            nbt.func_74757_a("validOwner", false);
        }
        return nbt;
    }

    public int getConnectableCount() {
        return 0;
    }

    public RackBusConnectable getConnectableAt(int index) {
        return null;
    }

    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY) {
        if (this.card.func_190926_b() && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof SmartCardItem) {
            this.card = player.func_184614_ca().func_77946_l();
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.player = player.func_146103_bH().getId();
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"smartcard_in", player.func_70005_c_()});
            }
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            return true;
        }
        if (!this.card.func_190926_b() && player.func_184614_ca().func_190926_b()) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.card);
            this.player = null;
            this.card = ItemStack.field_190927_a;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"smartcard_out", player.func_70005_c_()});
            }
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            return true;
        }
        return false;
    }

    public Node[] onAnalyze(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return new Node[]{this.node};
    }

    static enum KeyType {
        PRIVATE,
        PUBLIC;

    }
}

