/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.forestrybackpacks.backpacks;

import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public abstract class BasicBackpack
implements IBackpackDefinition {
    private static List<String> names = new ArrayList<String>();
    protected EnumBackpackType type;
    private Predicate<ItemStack> itemStackPredicate = new ItemTest();

    public BasicBackpack(EnumBackpackType type, String ... names) {
        this(type);
        Collections.addAll(BasicBackpack.names, names);
    }

    public BasicBackpack(EnumBackpackType type) {
        this.type = type;
    }

    public abstract String getUniqueName();

    public String getName(ItemStack backpack) {
        return I18n.func_74838_a((String)("item." + this.getKey() + ".name"));
    }

    public String getKey() {
        return this.getUniqueName() + this.type.name();
    }

    public static List<String> getNames() {
        return names;
    }

    @Nonnull
    public Predicate<ItemStack> getFilter() {
        return this.itemStackPredicate;
    }

    public static class ItemTest
    implements Predicate<ItemStack> {
        @Override
        public boolean test(ItemStack itemstack) {
            if (!itemstack.func_190926_b()) {
                ResourceLocation rl = itemstack.func_77973_b().getRegistryName();
                String name = null;
                if (rl != null) {
                    name = rl.func_110623_a();
                }
                if (name == null || name.isEmpty()) {
                    return false;
                }
                for (String names : BasicBackpack.getNames()) {
                    if (!name.startsWith(names)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

