/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BasicRectangularMultiblockTileEntityBase;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BatteryController;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityPowerTap;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="computercraft")})
public class TileEntityComputerPort
extends BasicRectangularMultiblockTileEntityBase
implements SimpleComponent,
IPeripheralProvider {
    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public String getComponentName() {
        return "big_battery";
    }

    private BatteryController getControler() {
        return (BatteryController)this.getMultiblockController();
    }

    private TileEntityPowerTap findPowerTap(int id) {
        if (this.getControler() != null) {
            TileEntityPowerTap[] array = this.getControler().getPowerTaps().toArray(new TileEntityPowerTap[0]);
            if (id >= 0 && id < array.length) {
                return array[id];
            }
        }
        return null;
    }

    private TileEntityPowerTap findPowerTap(String label) {
        if (this.getControler() != null) {
            TileEntityPowerTap[] array = this.getControler().getPowerTaps().toArray(new TileEntityPowerTap[0]);
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].getLabel().equals(label)) continue;
                return array[i];
            }
        }
        return null;
    }

    @Callback(doc="function(name:string) - set power tap as input")
    @Optional.Method(modid="opencomputers")
    public Object[] setIn(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String name = null;
        int id = -1;
        if (args.isString(0)) {
            name = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        TileEntityPowerTap tileEntityPowerTap = powerTap = name != null ? this.findPowerTap(name) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setIn();
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function(name:string) - set power tap as output")
    @Optional.Method(modid="opencomputers")
    public Object[] setOut(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String name = null;
        int id = -1;
        if (args.isString(0)) {
            name = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        TileEntityPowerTap tileEntityPowerTap = powerTap = name != null ? this.findPowerTap(name) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setOut();
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function():number - returns how much energy is stored")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getRealEnergyStored()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - returns how much energy can be stored")
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getRealMaxEnergyStored()};
        }
        return new Object[]{null, "Controler block not found. Rebuild your battery."};
    }

    @Callback(doc="function(name:string, transfer:number) - set transfer for electrode")
    @Optional.Method(modid="opencomputers")
    public Object[] setElectrodeTransfer(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String label = null;
        int id = -1;
        if (args.isString(0)) {
            label = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        int transfer = args.checkInteger(1);
        TileEntityPowerTap tileEntityPowerTap = powerTap = label != null ? this.findPowerTap(label) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setTransfer(transfer);
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function(transfer:number) - set transfer for all electrodes")
    @Optional.Method(modid="opencomputers")
    public Object[] setAllElectrodeTransfer(Context c, Arguments args) {
        int transfer = args.checkInteger(0);
        if (this.getControler() != null) {
            for (TileEntityPowerTap tap : this.getControler().getPowerTaps()) {
                tap.setTransfer(transfer);
            }
            return null;
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - get max transfer for electrode")
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxElectrodeTransfer(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getMaxExtract()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - get energy balance from last tick(1/20s)")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyBalanceLastTick(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getLastTickBalance()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Optional.Method(modid="computercraft")
    public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
        TileEntity te = world.func_175625_s(blockPos);
        if (te instanceof TileEntityComputerPort) {
            return new BatteryPeripheral((TileEntityComputerPort)te);
        }
        return null;
    }

    @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")
    public static class BatteryPeripheral
    implements IPeripheral {
        TileEntityComputerPort te;

        public BatteryPeripheral(TileEntityComputerPort te) {
            this.te = te;
        }

        @Optional.Method(modid="computercraft")
        public String getType() {
            return "big_battery";
        }

        @Optional.Method(modid="computercraft")
        public String[] getMethodNames() {
            return new String[]{"getEnergyBalanceLastTick", "getEnergyStored", "getMaxElectrodeTransfer", "getMaxEnergyStored", "setAllElectrodeTransfer", "setElectrodeTransfer", "setIn", "setOut"};
        }

        @Optional.Method(modid="computercraft")
        public Object[] callMethod(@Nonnull IComputerAccess iComputerAccess, @Nonnull ILuaContext iLuaContext, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    if (this.te.getControler() != null) {
                        return new Object[]{this.te.getControler().getLastTickBalance()};
                    }
                    return new Object[]{null, "Controller block not found. Rebuild your battery."};
                }
                case 1: {
                    if (this.te.getControler() != null) {
                        return new Object[]{this.te.getControler().getStorage().getRealEnergyStored()};
                    }
                    return new Object[]{null, "Controller block not found. Rebuild your battery."};
                }
                case 2: {
                    if (this.te.getControler() != null) {
                        return new Object[]{this.te.getControler().getStorage().getMaxExtract()};
                    }
                    return new Object[]{null, "Controller block not found. Rebuild your battery."};
                }
                case 3: {
                    if (this.te.getControler() != null) {
                        return new Object[]{this.te.getControler().getStorage().getRealMaxEnergyStored()};
                    }
                    return new Object[]{null, "Controler block not found. Rebuild your battery."};
                }
                case 4: {
                    if (arguments == null || arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                        return new Object[]{null, "Wrong argument"};
                    }
                    int transfer = ((Double)arguments[0]).intValue();
                    if (this.te.getControler() != null) {
                        for (TileEntityPowerTap tap : this.te.getControler().getPowerTaps()) {
                            tap.setTransfer(transfer);
                        }
                        return null;
                    }
                    return new Object[]{null, "Controller block not found. Rebuild your battery."};
                }
                case 5: {
                    TileEntityPowerTap powerTap;
                    if (arguments == null || arguments.length <= 1 || !(arguments[1] instanceof Double) || !(arguments[0] instanceof Double) && !(arguments[0] instanceof String)) {
                        return new Object[]{null, "Wrong arguments"};
                    }
                    String label = null;
                    int id = -1;
                    if (arguments[0] instanceof String) {
                        label = (String)arguments[0];
                    } else {
                        id = ((Double)arguments[0]).intValue();
                    }
                    TileEntityPowerTap tileEntityPowerTap = powerTap = label != null ? this.te.findPowerTap(label) : this.te.findPowerTap(id);
                    if (powerTap != null) {
                        powerTap.setTransfer(((Double)arguments[1]).intValue());
                        return null;
                    }
                    return new Object[]{null, "Electrode or Controller not found."};
                }
                case 6: {
                    TileEntityPowerTap powerTapIN;
                    if (arguments == null || arguments.length <= 0 || !(arguments[0] instanceof Double) && !(arguments[0] instanceof String)) {
                        return new Object[]{null, "Wrong arguments"};
                    }
                    String name = null;
                    int eid = -1;
                    if (arguments[0] instanceof String) {
                        name = (String)arguments[0];
                    } else {
                        eid = ((Double)arguments[0]).intValue();
                    }
                    TileEntityPowerTap tileEntityPowerTap = powerTapIN = name != null ? this.te.findPowerTap(name) : this.te.findPowerTap(eid);
                    if (powerTapIN != null) {
                        powerTapIN.setIn();
                        return null;
                    }
                    return new Object[]{null, "Electrode or Controller not found."};
                }
                case 7: {
                    TileEntityPowerTap powerTapOUT;
                    if (arguments == null || arguments.length <= 0 || !(arguments[0] instanceof Double) && !(arguments[0] instanceof String)) {
                        return new Object[]{null, "Wrong arguments"};
                    }
                    String nameOut = null;
                    int oid = -1;
                    if (arguments[0] instanceof String) {
                        nameOut = (String)arguments[0];
                    } else {
                        oid = ((Double)arguments[0]).intValue();
                    }
                    TileEntityPowerTap tileEntityPowerTap = powerTapOUT = nameOut != null ? this.te.findPowerTap(nameOut) : this.te.findPowerTap(oid);
                    if (powerTapOUT != null) {
                        powerTapOUT.setOut();
                        return null;
                    }
                    return new Object[]{null, "Electrode or Controller not found."};
                }
            }
            return null;
        }

        @Optional.Method(modid="computercraft")
        public boolean equals(IPeripheral other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof TileEntity) {
                TileEntity tother = (TileEntity)other;
                return tother.func_174877_v().equals((Object)this.te.func_174877_v()) && tother.func_145831_w().equals(this.te.field_145850_b);
            }
            return false;
        }
    }
}

