/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import com.bymarcin.zettaindustries.mods.battery.AdvancedStorage;
import com.bymarcin.zettaindustries.mods.battery.Battery;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.IMultiblockPart;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.gui.BigBatteryContainer;
import com.bymarcin.zettaindustries.mods.battery.gui.EnergyUpdatePacket;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityComputerPort;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityControler;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityPowerTap;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BatteryController
extends RectangularMultiblockControllerBase {
    private Set<TileEntityPowerTap> powerTaps;
    private Set<TileEntityControler> controlers;
    private Set<TileEntityComputerPort> computerPorts;
    private Set<EntityPlayer> updatePlayers;
    private TileEntityControler controler;
    private short lastUpdate = 0;
    private long lastTickBalance = 0L;
    private long tickBalance = 0L;
    private long electrolyte = 0L;
    private AdvancedStorage storage = new AdvancedStorage(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    int i = 0;
    private int redstoneSignal = 0;

    public BatteryController(World world) {
        super(world);
        this.powerTaps = new HashSet<TileEntityPowerTap>();
        this.controlers = new HashSet<TileEntityControler>();
        this.computerPorts = new HashSet<TileEntityComputerPort>();
        this.updatePlayers = new HashSet<EntityPlayer>();
    }

    public Container getContainer(EntityPlayer player) {
        return new BigBatteryContainer(this.controler, player);
    }

    public Set<TileEntityPowerTap> getPowerTaps() {
        return this.powerTaps;
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        ZIRegistry.packetHandler.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    protected EnergyUpdatePacket getUpdatePacket() {
        return new EnergyUpdatePacket(this.controler, this.storage.getRealEnergyStored(), this.storage.getRealMaxEnergyStored());
    }

    public void onPacket(long capacity, long storage) {
        this.electrolyte = capacity;
        this.getStorage().setCapacity(capacity);
        this.getStorage().setEnergyStored(storage);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    public AdvancedStorage getStorage() {
        return this.storage;
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileEntityControler> iterator = this.controlers.iterator();
        while (iterator.hasNext()) {
            TileEntityControler c;
            this.controler = c = iterator.next();
        }
        this.recalculate();
    }

    public static boolean isSourceFluid(World worldObj, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        Block block = worldObj.func_180495_p(blockPos).func_177230_c();
        return (block instanceof BlockFluidBase || block instanceof BlockFluidClassic || block instanceof BlockStaticLiquid || block instanceof BlockLiquid) && (Integer)worldObj.func_180495_p(blockPos).func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0;
    }

    public static int checkElectrolyte(World worldObj, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        Block block = worldObj.func_180495_p(blockPos).func_177230_c();
        if (BatteryController.isSourceFluid(worldObj, x, y, z) && Battery.getElectrolyteList().containsKey(FluidRegistry.lookupFluidForBlock((Block)block))) {
            return Battery.getElectrolyteList().get(FluidRegistry.lookupFluidForBlock((Block)block));
        }
        return 0;
    }

    @Override
    protected void onMachineDisassembled() {
    }

    @Override
    protected void onMachineRestored() {
        this.recalculate();
    }

    public void recalculate() {
        this.electrolyte = 0L;
        for (int x = this.getMinimumCoord().x; x < this.getMaximumCoord().x; ++x) {
            for (int y = this.getMinimumCoord().y; y < this.getMaximumCoord().y; ++y) {
                for (int z = this.getMinimumCoord().z; z < this.getMaximumCoord().z; ++z) {
                    this.electrolyte += (long)BatteryController.checkElectrolyte(this.worldObj, x, y, z);
                }
            }
        }
        this.storage.setCapacity(this.electrolyte);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.powerTaps.size() == 0) {
            throw new MultiblockValidationException("BigBattery must have power tap");
        }
        if (this.controlers.size() == 0) {
            throw new MultiblockValidationException("BigBattery must have controler");
        }
        if (this.controlers.size() > 1) {
            throw new MultiblockValidationException("BigBattery have too many controlers");
        }
        boolean foundElectrolyte = false;
        block0: for (int x = this.getMinimumCoord().x; x < this.getMaximumCoord().x; ++x) {
            for (int y = this.getMinimumCoord().y; y < this.getMaximumCoord().y; ++y) {
                for (int z = this.getMinimumCoord().z; z < this.getMaximumCoord().z; ++z) {
                    if (BatteryController.checkElectrolyte(this.worldObj, x, y, z) <= 0) continue;
                    foundElectrolyte = true;
                    break block0;
                }
            }
        }
        if (!foundElectrolyte) {
            throw new MultiblockValidationException("BigBattery must have electrolyte");
        }
        super.isMachineWhole();
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (world.func_175623_d(blockPos)) {
            return;
        }
        Material material = world.func_180495_p(blockPos).func_185904_a();
        if (material instanceof MaterialLiquid) {
            return;
        }
        String blockName = world.func_180495_p(blockPos).func_177230_c().func_149732_F();
        throw new MultiblockValidationException(String.format("%d, %d, %d - Unrecognized block with ID %s, not valid for the reactor's interior", x, y, z, blockName));
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 36;
    }

    @Override
    protected int getMaximumXSize() {
        return 32;
    }

    @Override
    protected int getMaximumZSize() {
        return 32;
    }

    @Override
    protected int getMaximumYSize() {
        return 32;
    }

    public void modifyLastTickBalance(int energy) {
        this.tickBalance += (long)energy;
    }

    public int getRedstoneSignal() {
        return this.redstoneSignal;
    }

    @Override
    protected boolean updateServer() {
        if (this.electrolyte == 0L) {
            return false;
        }
        for (TileEntityPowerTap tileEntityPowerTap : this.powerTaps) {
            tileEntityPowerTap.onTransferEnergy();
        }
        if (this.lastUpdate % 4 == 0) {
            int newRedstoneSignal = (int)Math.round((double)this.storage.getRealEnergyStored() / (double)this.storage.getRealMaxEnergyStored() * 15.0);
            if (newRedstoneSignal != this.redstoneSignal) {
                this.redstoneSignal = newRedstoneSignal;
                for (TileEntityComputerPort computerPort : this.computerPorts) {
                    this.worldObj.func_175685_c(computerPort.func_174877_v(), this.worldObj.func_180495_p(computerPort.func_174877_v()).func_177230_c(), false);
                }
            }
            EnergyUpdatePacket energyUpdatePacket = this.getUpdatePacket();
            for (EntityPlayer p : this.updatePlayers) {
                ZIRegistry.packetHandler.sendTo((IMessage)energyUpdatePacket, (EntityPlayerMP)p);
            }
            this.lastUpdate = 0;
        }
        this.lastUpdate = (short)(this.lastUpdate + 1);
        this.lastTickBalance = this.tickBalance;
        this.tickBalance = 0L;
        return true;
    }

    public long getLastTickBalance() {
        return this.lastTickBalance;
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileEntityPowerTap) {
            this.powerTaps.add((TileEntityPowerTap)newPart);
        }
        if (newPart instanceof TileEntityControler) {
            this.controlers.add((TileEntityControler)newPart);
        }
        if (newPart instanceof TileEntityComputerPort) {
            this.computerPorts.add((TileEntityComputerPort)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileEntityPowerTap) {
            this.powerTaps.remove((Object)oldPart);
        }
        if (oldPart instanceof TileEntityControler) {
            this.controlers.remove((Object)oldPart);
        }
        if (oldPart instanceof TileEntityComputerPort) {
            this.computerPorts.remove((Object)oldPart);
        }
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase assimilated) {
        BatteryController other = (BatteryController)assimilated;
        this.storage.merge(other.getStorage());
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    @Override
    protected void updateClient() {
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74772_a("Electrolyte", this.electrolyte);
        this.storage.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("Electrolyte")) {
            this.electrolyte = data.func_74763_f("Electrolyte");
        }
        this.storage.readFromNBT(data);
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        data.func_74772_a("Electrolyte", this.electrolyte);
        this.storage.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        if (data.func_74764_b("Electrolyte")) {
            this.electrolyte = data.func_74763_f("Electrolyte");
        }
        this.storage.readFromNBT(data);
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }
}

